/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.model;

import edu.rice.cs.drjava.model.DocumentRegion;
import edu.rice.cs.drjava.model.OpenDefinitionsDocument;
import edu.rice.cs.plt.lambda.Thunk;
import edu.rice.cs.plt.text.TextUtil;
import edu.rice.cs.util.StringOps;
import edu.rice.cs.util.UnexpectedException;
import javax.swing.text.BadLocationException;
import javax.swing.text.Position;

public class MovingDocumentRegion
extends DocumentRegion {
    protected final Position _startPos;
    protected final Position _endPos;
    protected volatile Position _lineStartPos;
    protected volatile Position _lineEndPos;
    protected final Thunk<String> _stringSuspension;

    @Override
    public void update() {
        try {
            this._lineStartPos = this._doc.createPosition(this._doc._getLineStartPos(this.getStartOffset()));
            this._lineEndPos = this._doc.createPosition(this._doc._getLineEndPos(this.getEndOffset()));
        }
        catch (BadLocationException ble) {
            throw new UnexpectedException(ble);
        }
    }

    public MovingDocumentRegion(final OpenDefinitionsDocument doc, int start, int end, int lineStart, int lineEnd) {
        super(doc, start, end);
        assert (doc != null);
        try {
            this._startPos = doc.createPosition(start);
            this._endPos = doc.createPosition(end);
            this._lineStartPos = doc.createPosition(lineStart);
            this._lineEndPos = doc.createPosition(lineEnd);
        }
        catch (BadLocationException ble) {
            throw new UnexpectedException(ble);
        }
        this._stringSuspension = new Thunk<String>(){
            final /* synthetic */ MovingDocumentRegion this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public String value() {
                try {
                    String suffix;
                    String match;
                    String prefix;
                    this.this$0.update();
                    int endSel = this.this$0.getEndOffset();
                    int startSel = this.this$0.getStartOffset();
                    int selLength = endSel - startSel;
                    int excerptEnd = this.this$0.getLineEndOffset();
                    int excerptStart = this.this$0.getLineStartOffset();
                    int startRed = startSel - excerptStart;
                    int endRed = endSel - excerptStart;
                    int excerptLength = Math.min(120, excerptEnd - excerptStart);
                    String text = doc.getText(excerptStart, excerptLength);
                    if (excerptLength < startRed || startRed < 0) {
                        prefix = StringOps.compress(text.substring(0, excerptLength));
                        match = " ...";
                        suffix = "";
                    } else {
                        prefix = StringOps.compress(text.substring(0, startRed));
                        if (excerptLength < startRed + selLength) {
                            match = text.substring(startRed) + " ...";
                            suffix = "";
                        } else {
                            match = text.substring(startRed, endRed);
                            suffix = StringOps.compress(text.substring(endRed, excerptLength));
                        }
                    }
                    StringBuilder sb = new StringBuilder(TextUtil.htmlEscape(prefix));
                    sb.append("<font color=#ff0000>");
                    sb.append(TextUtil.htmlEscape(match));
                    sb.append("</font>");
                    sb.append(TextUtil.htmlEscape(suffix));
                    return sb.toString();
                }
                catch (BadLocationException e) {
                    return "";
                }
            }
        };
    }

    @Override
    public OpenDefinitionsDocument getDocument() {
        return this._doc;
    }

    @Override
    public int getStartOffset() {
        return this._startPos.getOffset();
    }

    @Override
    public int getEndOffset() {
        return this._endPos.getOffset();
    }

    @Override
    public int getLineStartOffset() {
        return this._lineStartPos.getOffset();
    }

    @Override
    public int getLineEndOffset() {
        return this._lineEndPos.getOffset();
    }

    @Override
    public String getString() {
        return this._stringSuspension.value();
    }

    public static boolean equals(Object a, Object b) {
        if (a == null) {
            return b == null;
        }
        return a.equals(b);
    }
}

