/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.model;

import edu.rice.cs.drjava.DrJava;
import edu.rice.cs.drjava.config.OptionConstants;
import edu.rice.cs.drjava.model.GlobalModel;
import edu.rice.cs.drjava.model.JDKDescriptor;
import edu.rice.cs.drjava.model.compiler.CompilerInterface;
import edu.rice.cs.drjava.model.compiler.NoCompilerAvailable;
import edu.rice.cs.drjava.model.debug.Debugger;
import edu.rice.cs.drjava.model.debug.NoDebuggerAvailable;
import edu.rice.cs.drjava.model.javadoc.DefaultJavadocModel;
import edu.rice.cs.drjava.model.javadoc.JavadocModel;
import edu.rice.cs.drjava.model.javadoc.NoJavadocAvailable;
import edu.rice.cs.plt.collect.CollectUtil;
import edu.rice.cs.plt.io.IOUtil;
import edu.rice.cs.plt.reflect.JavaVersion;
import edu.rice.cs.plt.reflect.ReflectException;
import edu.rice.cs.plt.reflect.ReflectUtil;
import edu.rice.cs.util.Log;
import java.io.File;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;

public class JDKToolsLibrary {
    private final JavaVersion.FullVersion _version;
    private final CompilerInterface _compiler;
    private final Debugger _debugger;
    private final JavadocModel _javadoc;
    private final JDKDescriptor _jdkDescriptor;
    static Log _log = new Log("JDKToolsLibrary.txt", false);
    public static final StringWriter LOG_STRINGWRITER = new StringWriter();

    protected JDKToolsLibrary(JavaVersion.FullVersion version, JDKDescriptor jdkDescriptor, CompilerInterface compiler, Debugger debugger, JavadocModel javadoc) {
        assert (jdkDescriptor != null);
        this._version = version;
        this._compiler = compiler;
        this._debugger = debugger;
        this._javadoc = javadoc;
        this._jdkDescriptor = jdkDescriptor;
    }

    public JavaVersion.FullVersion version() {
        return this._version;
    }

    public JDKDescriptor jdkDescriptor() {
        return this._jdkDescriptor;
    }

    public CompilerInterface compiler() {
        return this._compiler;
    }

    public Debugger debugger() {
        return this._debugger;
    }

    public JavadocModel javadoc() {
        return this._javadoc;
    }

    public boolean isValid() {
        return this._compiler.isAvailable() || this._debugger.isAvailable() || this._javadoc.isAvailable();
    }

    public String toString() {
        return this._jdkDescriptor.getDescription(this._version);
    }

    public static String adapterForCompiler(JavaVersion.FullVersion version) {
        switch (version.majorVersion()) {
            case FUTURE: {
                return "edu.rice.cs.drjava.model.compiler.Javac170Compiler";
            }
            case JAVA_8: {
                return "edu.rice.cs.drjava.model.compiler.Javac170Compiler";
            }
            case JAVA_7: {
                return "edu.rice.cs.drjava.model.compiler.Javac170Compiler";
            }
            case JAVA_6: {
                switch (version.vendor()) {
                    case OPENJDK: {
                        return "edu.rice.cs.drjava.model.compiler.Javac160OpenJDKCompiler";
                    }
                    case UNKNOWN: {
                        return null;
                    }
                }
                return "edu.rice.cs.drjava.model.compiler.Javac160Compiler";
            }
            case JAVA_5: {
                return "edu.rice.cs.drjava.model.compiler.Javac150Compiler";
            }
        }
        return null;
    }

    public static String adapterForDebugger(JavaVersion.FullVersion version) {
        switch (version.majorVersion()) {
            case JAVA_7: 
            case JAVA_6: 
            case JAVA_5: {
                return "edu.rice.cs.drjava.model.debug.jpda.JPDADebugger";
            }
        }
        return null;
    }

    protected static CompilerInterface getCompilerInterface(String className, JavaVersion.FullVersion version) {
        if (className != null) {
            List<File> bootClassPath = null;
            String bootProp = System.getProperty("sun.boot.class.path");
            if (bootProp != null) {
                bootClassPath = CollectUtil.makeList(IOUtil.parsePath(bootProp));
            }
            File toolsJar = DrJava.getConfig().getSetting(OptionConstants.JAVAC_LOCATION);
            try {
                Class[] sig = new Class[]{JavaVersion.FullVersion.class, String.class, List.class};
                Object[] args = new Object[]{version, "the runtime class path", bootClassPath};
                CompilerInterface attempt = (CompilerInterface)ReflectUtil.loadObject(className, sig, args);
                JDKToolsLibrary.msg("                 attempt = " + attempt + ", isAvailable() = " + attempt.isAvailable());
                if (attempt.isAvailable()) {
                    return attempt;
                }
            }
            catch (ReflectException reflectException) {
            }
            catch (LinkageError linkageError) {
                // empty catch block
            }
        }
        return NoCompilerAvailable.ONLY;
    }

    public static Iterable<JDKToolsLibrary> makeFromRuntime(GlobalModel model) {
        JavaVersion.FullVersion version = JavaVersion.CURRENT_FULL;
        String compilerAdapter = JDKToolsLibrary.adapterForCompiler(version);
        JDKToolsLibrary.msg("makeFromRuntime: compilerAdapter=" + compilerAdapter);
        CompilerInterface compiler = JDKToolsLibrary.getCompilerInterface(compilerAdapter, version);
        JDKToolsLibrary.msg("                 compiler=" + compiler.getClass().getName());
        Debugger debugger = NoDebuggerAvailable.ONLY;
        String debuggerAdapter = JDKToolsLibrary.adapterForDebugger(version);
        if (debuggerAdapter != null) {
            try {
                JDKToolsLibrary.msg("                 loading debugger: " + debuggerAdapter);
                Debugger attempt = (Debugger)ReflectUtil.loadObject(debuggerAdapter, new Class[]{GlobalModel.class}, new Object[]{model});
                JDKToolsLibrary.msg("                 debugger=" + attempt.getClass().getName());
                if (attempt.isAvailable()) {
                    debugger = attempt;
                }
            }
            catch (ReflectException e) {
                JDKToolsLibrary.msg("                 no debugger, ReflectException " + e);
            }
            catch (LinkageError e) {
                JDKToolsLibrary.msg("                 no debugger, LinkageError " + e);
            }
        }
        JavadocModel javadoc = new NoJavadocAvailable(model);
        try {
            Class.forName("com.sun.tools.javadoc.Main");
            javadoc = new DefaultJavadocModel(model, null, ReflectUtil.SYSTEM_CLASS_PATH);
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (LinkageError linkageError) {
            // empty catch block
        }
        ArrayList<JDKToolsLibrary> list = new ArrayList<JDKToolsLibrary>();
        if (compiler != NoCompilerAvailable.ONLY) {
            JDKToolsLibrary.msg("                 compiler found");
            list.add(new JDKToolsLibrary(version, JDKDescriptor.NONE, compiler, debugger, javadoc));
        }
        JDKToolsLibrary.msg("                 compilers found: " + list.size());
        if (list.size() == 0) {
            JDKToolsLibrary.msg("                 no compilers found, adding NoCompilerAvailable library");
            list.add(new JDKToolsLibrary(version, JDKDescriptor.NONE, NoCompilerAvailable.ONLY, debugger, javadoc));
        }
        return list;
    }

    public static void msg(String s) {
        _log.log(s);
    }
}

