/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.model;

import edu.rice.cs.drjava.model.JDKToolsLibrary;
import edu.rice.cs.drjava.model.JarJDKToolsLibrary;
import edu.rice.cs.plt.iter.IterUtil;
import edu.rice.cs.plt.reflect.JavaVersion;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import java.util.jar.JarFile;

public abstract class JDKDescriptor {
    public static final JDKDescriptor NONE = new None();

    public abstract String getName();

    public abstract Set<String> getToolsPackages();

    public abstract Iterable<File> getSearchDirectories();

    public abstract Iterable<File> getSearchFiles();

    public abstract boolean isCompound();

    public boolean isBaseForCompound() {
        return false;
    }

    public abstract String getAdapterForCompiler();

    public String getAdapterForCompiler(JavaVersion.FullVersion guessedVersion) {
        return this.getAdapterForCompiler();
    }

    public abstract String getAdapterForDebugger();

    public String getAdapterForDebugger(JavaVersion.FullVersion guessedVersion) {
        return this.getAdapterForDebugger();
    }

    public abstract boolean containsCompiler(File var1);

    public JavaVersion.FullVersion guessVersion(File f) {
        return JarJDKToolsLibrary.guessVersion(f, this);
    }

    public abstract JavaVersion getMinimumMajorVersion();

    public abstract Iterable<File> getAdditionalCompilerFiles(File var1) throws FileNotFoundException;

    public String getDescription(JavaVersion.FullVersion version) {
        return this.getName() + " library " + version.versionString();
    }

    public String toString() {
        return this.getClass().getName() + ": " + this.getName();
    }

    private static final class None
    extends JDKDescriptor {
        private None() {
        }

        @Override
        public String getName() {
            return "none";
        }

        @Override
        public String getDescription(JavaVersion.FullVersion version) {
            switch (version.vendor()) {
                case ORACLE: {
                    return "Oracle JDK library " + version.toString();
                }
                case OPENJDK: {
                    return "OpenJDK library " + version.toString();
                }
                case APPLE: {
                    return "Apple JDK library " + version.toString();
                }
            }
            return "JDK library " + version.toString();
        }

        @Override
        public Set<String> getToolsPackages() {
            return Collections.emptySet();
        }

        @Override
        public Iterable<File> getSearchDirectories() {
            return IterUtil.empty();
        }

        @Override
        public Iterable<File> getSearchFiles() {
            return IterUtil.empty();
        }

        @Override
        public boolean isCompound() {
            return false;
        }

        @Override
        public boolean isBaseForCompound() {
            return true;
        }

        @Override
        public String getAdapterForCompiler() {
            return "";
        }

        @Override
        public String getAdapterForCompiler(JavaVersion.FullVersion guessedVersion) {
            return JDKToolsLibrary.adapterForCompiler(guessedVersion);
        }

        @Override
        public String getAdapterForDebugger() {
            return "";
        }

        @Override
        public String getAdapterForDebugger(JavaVersion.FullVersion guessedVersion) {
            return JDKToolsLibrary.adapterForDebugger(guessedVersion);
        }

        @Override
        public boolean containsCompiler(File f) {
            return true;
        }

        @Override
        public JavaVersion getMinimumMajorVersion() {
            return JavaVersion.JAVA_1_1;
        }

        @Override
        public Iterable<File> getAdditionalCompilerFiles(File compiler) throws FileNotFoundException {
            return IterUtil.empty();
        }
    }

    public static class Util {
        public static boolean exists(File jarOrDir, String ... fileNames) {
            if (jarOrDir.isFile()) {
                try {
                    JarFile jf = new JarFile(jarOrDir);
                    for (String fn : fileNames) {
                        if (jf.getJarEntry(fn) != null) continue;
                        return false;
                    }
                    return true;
                }
                catch (IOException ioe) {
                    return false;
                }
            }
            if (jarOrDir.isDirectory()) {
                for (String fn : fileNames) {
                    if (new File(jarOrDir, fn).exists()) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        public static File oneOf(File dir, String ... fileNames) throws FileNotFoundException {
            if (dir.isDirectory()) {
                for (String fn : fileNames) {
                    File f = new File(dir, fn);
                    if (!f.exists()) continue;
                    return f;
                }
                throw new FileNotFoundException("None of " + IterUtil.toString(IterUtil.make(fileNames), "", ", ", "") + " found in " + dir);
            }
            throw new FileNotFoundException(dir + " is not a directory");
        }
    }
}

