/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.model;

import edu.rice.cs.util.ReaderWriterLock;
import java.util.LinkedList;

public abstract class EventNotifier<T> {
    protected final LinkedList<T> _listeners = new LinkedList();
    protected final ReaderWriterLock _lock = new ReaderWriterLock();

    public void addListener(T listener) {
        this._lock.startWrite();
        try {
            this._listeners.add(listener);
        }
        finally {
            this._lock.endWrite();
        }
    }

    public void removeListener(final T listener) {
        try {
            this._lock.startWrite();
            try {
                this._listeners.remove(listener);
            }
            finally {
                this._lock.endWrite();
            }
        }
        catch (ReaderWriterLock.DeadlockException e) {
            new Thread(new Runnable(){
                final /* synthetic */ EventNotifier this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void run() {
                    this.this$0._lock.startWrite();
                    try {
                        this.this$0._listeners.remove(listener);
                    }
                    finally {
                        this.this$0._lock.endWrite();
                    }
                }
            }, "Pending Listener Removal").start();
        }
    }

    public void removeAllListeners() {
        try {
            this._lock.startWrite();
            try {
                this._listeners.clear();
            }
            finally {
                this._lock.endWrite();
            }
        }
        catch (ReaderWriterLock.DeadlockException e) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    EventNotifier.this._lock.startWrite();
                    try {
                        EventNotifier.this._listeners.clear();
                    }
                    finally {
                        EventNotifier.this._lock.endWrite();
                    }
                }
            }, "Pending Listener Removal").start();
        }
    }
}

