/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.config;

import edu.rice.cs.drjava.config.Option;
import edu.rice.cs.drjava.config.OptionParseException;
import edu.rice.cs.drjava.platform.PlatformFactory;
import edu.rice.cs.util.UnexpectedException;
import java.awt.event.KeyEvent;
import java.lang.reflect.Field;
import java.util.HashMap;
import javax.swing.KeyStroke;

public class KeyStrokeOption
extends Option<KeyStroke> {
    static HashMap<Integer, String> keys = new HashMap();
    public static final KeyStroke NULL_KEYSTROKE = KeyStroke.getKeyStroke(0, 0);

    public KeyStrokeOption(String key, KeyStroke def) {
        super(key, def);
    }

    @Override
    public KeyStroke parse(String s) {
        KeyStroke ks;
        int oIndex;
        if (s.equals("<none>")) {
            return NULL_KEYSTROKE;
        }
        int cIndex = s.indexOf("command");
        if (cIndex > -1) {
            StringBuilder sb = new StringBuilder(s.substring(0, cIndex));
            sb.append("meta");
            sb.append(s.substring(cIndex + "command".length(), s.length()));
            s = sb.toString();
        }
        if ((oIndex = s.indexOf("option")) > -1) {
            StringBuilder sb = new StringBuilder(s.substring(0, oIndex));
            sb.append("alt");
            sb.append(s.substring(oIndex + "option".length(), s.length()));
            s = sb.toString();
        }
        if ((ks = KeyStroke.getKeyStroke(s)) == null) {
            throw new OptionParseException(this.name, s, "Must be a valid string representation of a Keystroke.");
        }
        return ks;
    }

    @Override
    public String format(KeyStroke k) {
        return KeyStrokeOption.formatKeyStroke(k);
    }

    public static String formatKeyStroke(KeyStroke k) {
        if (k == NULL_KEYSTROKE) {
            return "<none>";
        }
        int modifiers = k.getModifiers();
        boolean isMac = PlatformFactory.ONLY.isMacPlatform();
        StringBuilder buf = new StringBuilder();
        if ((modifiers & 4) > 0) {
            String meta = !isMac ? "meta " : "command ";
            buf.append(meta);
        }
        if ((modifiers & 2) > 0) {
            buf.append("ctrl ");
        }
        if ((modifiers & 8) > 0) {
            String alt = !isMac ? "alt " : "option ";
            buf.append(alt);
        }
        if ((modifiers & 1) > 0) {
            buf.append("shift ");
        }
        if (k.getKeyCode() != 0) {
            String key;
            if (k.isOnKeyRelease()) {
                buf.append("released ");
            }
            if ((key = keys.get(k.getKeyCode())) == null) {
                throw new IllegalArgumentException("Invalid keystroke");
            }
            if (key.equals("CONTROL") || key.equals("ALT") || key.equals("META") || key.equals("SHIFT") || key.equals("ALT_GRAPH")) {
                return buf.toString();
            }
            buf.append(key);
            return buf.toString();
        }
        buf.append("typed ");
        buf.append(k.getKeyChar());
        return buf.toString();
    }

    static {
        try {
            Field[] fields = KeyEvent.class.getFields();
            for (int i = 0; i < fields.length; ++i) {
                Field currfield = fields[i];
                String name = currfield.getName();
                if (!name.startsWith("VK_")) continue;
                keys.put(currfield.getInt(null), name.substring(3));
            }
        }
        catch (IllegalAccessException iae) {
            throw new UnexpectedException(iae);
        }
    }
}

