/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.config;

import edu.rice.cs.drjava.config.Option;
import edu.rice.cs.drjava.config.OptionParseException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;

public class ForcedChoiceOption
extends Option<String> {
    private Collection<String> _choices;
    private Collection<String> _deprecated;

    public ForcedChoiceOption(String key, String def, Collection<String> choices) {
        this(key, def, choices, Arrays.asList(new String[0]));
    }

    public ForcedChoiceOption(String key, String def, Collection<String> choices, Collection<String> deprecated) {
        super(key, def);
        this._choices = choices;
        this._deprecated = deprecated;
    }

    public boolean isLegal(String s) {
        return this._choices.contains(s);
    }

    public boolean isDeprecated(String s) {
        return this._deprecated.contains(s);
    }

    public Iterator<String> getLegalValues() {
        return this._choices.iterator();
    }

    public Iterator<String> getDeprecatedValues() {
        return this._deprecated.iterator();
    }

    public int getNumValues() {
        return this._choices.size();
    }

    @Override
    public String parse(String s) {
        if (this.isLegal(s)) {
            return s;
        }
        if (this.isDeprecated(s)) {
            return (String)this.defaultValue;
        }
        throw new OptionParseException(this.name, s, "Value is not an acceptable choice for this option.");
    }

    @Override
    public String format(String s) {
        return s;
    }
}

