/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.config;

import edu.rice.cs.drjava.config.Option;
import edu.rice.cs.drjava.config.OptionParseException;
import edu.rice.cs.util.FileOps;
import java.io.File;

public class FileOption
extends Option<File> {
    public FileOption(String key, File def) {
        super(key, def);
    }

    @Override
    public File parse(String s) {
        if (s.trim().equals("")) {
            return FileOps.NULL_FILE;
        }
        try {
            return new File(s).getAbsoluteFile();
        }
        catch (NullPointerException e) {
            throw new OptionParseException(this.name, s, "Must have a legal filename.");
        }
    }

    @Override
    public String format(File f) {
        return f.getAbsolutePath();
    }
}

