/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.config;

import edu.rice.cs.drjava.DrJava;
import edu.rice.cs.drjava.config.BinaryOpProperty;
import edu.rice.cs.drjava.config.ConstantProperty;
import edu.rice.cs.drjava.config.DrJavaProperty;
import edu.rice.cs.drjava.config.EagerProperty;
import edu.rice.cs.drjava.config.FileProperty;
import edu.rice.cs.drjava.config.MutableFileProperty;
import edu.rice.cs.drjava.config.OptionConstants;
import edu.rice.cs.drjava.config.PropertyMaps;
import edu.rice.cs.drjava.config.QuaternaryOpProperty;
import edu.rice.cs.drjava.config.RecursiveFileListProperty;
import edu.rice.cs.drjava.config.TernaryOpProperty;
import edu.rice.cs.drjava.config.UnaryOpProperty;
import edu.rice.cs.plt.concurrent.JVMBuilder;
import edu.rice.cs.plt.io.IOUtil;
import edu.rice.cs.plt.lambda.Lambda;
import edu.rice.cs.plt.lambda.Lambda2;
import edu.rice.cs.plt.lambda.Lambda3;
import edu.rice.cs.plt.lambda.Lambda4;
import edu.rice.cs.plt.lambda.Thunk;
import edu.rice.cs.plt.reflect.JavaVersion;
import edu.rice.cs.plt.text.TextUtil;
import edu.rice.cs.util.FileOps;
import edu.rice.cs.util.ProcessChain;
import edu.rice.cs.util.StringOps;
import edu.rice.cs.util.XMLConfig;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.DateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.jar.JarFile;

public class DrJavaPropertySetup
implements OptionConstants {
    public static void setup() {
        String DEF_DIR = "${drjava.working.dir}";
        String msg1 = "This property contains all the JVM arguments passed to DrJava's master JVM, i.e. the JVM the user is editing programs in. The arguments from the \"JVM Args for Main JVM\" and the special -X arguments from \"Maximum  Heap Size for Main JVM\" are combined.";
        EagerProperty prop1 = new EagerProperty("config.master.jvm.args.combined", msg1){

            @Override
            public void update(PropertyMaps pm) {
                StringBuilder sb = new StringBuilder();
                if (!DrJava.getConfig().getSetting(OptionConstants.MASTER_JVM_XMX).equals("default") && !DrJava.getConfig().getSetting(OptionConstants.MASTER_JVM_XMX).equals("")) {
                    sb.append("-Xmx");
                    sb.append(DrJava.getConfig().getSetting(OptionConstants.MASTER_JVM_XMX));
                    sb.append("M ");
                }
                sb.append(DrJava.getConfig().getSetting(OptionConstants.MASTER_JVM_ARGS));
                this._value = sb.toString().trim();
            }

            @Override
            public String getLazy(PropertyMaps pm) {
                return this.getCurrent(pm);
            }

            @Override
            public void resetAttributes() {
                this._attributes.clear();
            }
        };
        PropertyMaps.TEMPLATE.setProperty("Config", prop1).listenToInvalidatesOf(PropertyMaps.TEMPLATE.getProperty("Config", "config.master.jvm.args")).listenToInvalidatesOf(PropertyMaps.TEMPLATE.getProperty("Config", "config.master.jvm.xmx"));
        String msg2 = "This property contains all the JVM arguments passed to DrJava's master JVM, i.e. the JVM the user is editing programs in. The arguments from the \"JVM Args for Slave JVM\" and the special -X arguments from \"Maximum Heap Size for Main JVM\" are combined.";
        EagerProperty prop2 = new EagerProperty("config.slave.jvm.args.combined", msg2){

            @Override
            public void update(PropertyMaps pm) {
                StringBuilder sb = new StringBuilder();
                if (!DrJava.getConfig().getSetting(OptionConstants.SLAVE_JVM_XMX).equals("default") && !DrJava.getConfig().getSetting(OptionConstants.SLAVE_JVM_XMX).equals("")) {
                    sb.append("-Xmx");
                    sb.append(DrJava.getConfig().getSetting(OptionConstants.SLAVE_JVM_XMX));
                    sb.append("M ");
                }
                sb.append(DrJava.getConfig().getSetting(OptionConstants.SLAVE_JVM_ARGS));
                this._value = sb.toString().trim();
            }

            @Override
            public String getLazy(PropertyMaps pm) {
                return this.getCurrent(pm);
            }

            @Override
            public void resetAttributes() {
                this._attributes.clear();
            }
        };
        PropertyMaps.TEMPLATE.setProperty("Config", prop2).listenToInvalidatesOf(PropertyMaps.TEMPLATE.getProperty("Config", "config.slave.jvm.args")).listenToInvalidatesOf(PropertyMaps.TEMPLATE.getProperty("Config", "config.slave.jvm.xmx"));
        String msg3 = "Creates a temporary file and returns the name of it.\nOptional attributes:\n\tname=\"<name for temp file>\"\n\tdir=\"<dir for temp file>\"\n\tkeep=\"<true if the file should not be erased>\"\n\tcontent=\"<text to go into the file>\"";
        DrJavaProperty prop3 = new DrJavaProperty("tmpfile", msg3){
            Random _r = new Random();

            @Override
            public void update(PropertyMaps pm) {
                try {
                    String name = (String)this._attributes.get("name");
                    String dir = (String)this._attributes.get("dir");
                    if (name.equals("")) {
                        name = "DrJava-Execute-" + System.currentTimeMillis() + "-" + (this._r.nextInt() & 0xFFFF) + ".tmp";
                    }
                    dir = dir.equals("") ? System.getProperty("java.io.tmpdir") : StringOps.unescapeFileName(dir);
                    File f = new File(dir, name);
                    f.deleteOnExit();
                    this._value = StringOps.escapeFileName(f.toString());
                }
                catch (SecurityException e) {
                    this._value = "Error.";
                }
            }

            @Override
            public String getLazy(PropertyMaps pm) {
                return this.getCurrent(pm);
            }

            @Override
            public String getCurrent(PropertyMaps pm) {
                this.invalidate();
                String s = super.getCurrent(pm);
                File f = new File(StringOps.unescapeFileName(this._value));
                String keep = (String)this._attributes.get("keep");
                if (!(keep.equals("true") || keep.equals("yes") || keep.equals("1"))) {
                    f.deleteOnExit();
                }
                String text = StringOps.unescapeFileName((String)this._attributes.get("content"));
                try {
                    FileWriter fw = new FileWriter(f);
                    fw.write(text, 0, text.length());
                    fw.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return s;
            }

            @Override
            public void resetAttributes() {
                this._attributes.clear();
                this._attributes.put("dir", "");
                this._attributes.put("name", "");
                this._attributes.put("keep", "");
                this._attributes.put("content", "");
            }
        };
        PropertyMaps.TEMPLATE.setProperty("Misc", prop3);
        String msg4 = "Return a list of files found in the starting dir.\nOptional attributes:\n\tsep=\"<separator between files>\"\n\tdir=\"<dir where to start>\"\n\trel=\"<dir to which the files are relative>\"\n\tfilter=\"<filter, like *.txt, for files to list>\"\n\tdirfilter=\"<filter for which dirs to recurse>\"\n\tsquote=\"<true to enclose file in single quotes>\"\n\tdquote=\"<true to enclose file in double quotes>\"";
        RecursiveFileListProperty prop4 = new RecursiveFileListProperty("file.find", File.pathSeparator, "${drjava.working.dir}", "${drjava.working.dir}", msg4);
        PropertyMaps.TEMPLATE.setProperty("File", prop4);
        String msg5 = "Return true if the specified file is a directory, false otherwise.\nRequired attributes:\n\tfile=\"<file to test>\"\nMultiple files can be specified, separated by ${path.separator}, which is " + File.pathSeparator + " on this machine. If multiple files are specified, then a list of values, each separated by ${path.separator}, is returned.";
        DrJavaProperty prop5 = new DrJavaProperty("file.isdir", msg5){

            @Override
            public void update(PropertyMaps pm) {
                String s = (String)this._attributes.get("file");
                if (s == null) {
                    this._value = "(file.isdir Error...)";
                    return;
                }
                StringBuilder sb = new StringBuilder();
                for (String fs : s.split(TextUtil.regexEscape(File.pathSeparator), -1)) {
                    File f = new File(StringOps.unescapeFileName(fs));
                    sb.append(File.pathSeparator);
                    sb.append(f.exists() && f.isDirectory() ? "true" : "false");
                }
                s = sb.toString();
                this._value = s.startsWith(File.pathSeparator) ? s.substring(File.pathSeparator.length()) : s;
            }

            @Override
            public boolean isCurrent() {
                return false;
            }

            @Override
            public void resetAttributes() {
                this._attributes.clear();
                this._attributes.put("file", null);
            }
        };
        PropertyMaps.TEMPLATE.setProperty("File", prop5);
        String msg6 = "Return true if the specified file is a file, not a directory.\nRequired attributes:\n\tfile=\"<file to test>\"\nMultiple files can be specified, separated by ${path.separator}, which is " + File.pathSeparator + " on this machine. If multiple files are specified, then a list of values, each separated by ${path.separator}, is returned.";
        DrJavaProperty prop6 = new DrJavaProperty("file.isfile", msg6){

            @Override
            public void update(PropertyMaps pm) {
                String s = (String)this._attributes.get("file");
                if (s == null) {
                    this._value = "(file.isfile Error...)";
                    return;
                }
                StringBuilder sb = new StringBuilder();
                for (String fs : s.split(TextUtil.regexEscape(File.pathSeparator), -1)) {
                    fs = StringOps.unescapeFileName(fs);
                    File f = new File(fs);
                    sb.append(File.pathSeparator);
                    sb.append(f.exists() && f.isFile() ? "true" : "false");
                }
                s = sb.toString();
                this._value = s.startsWith(File.pathSeparator) ? s.substring(File.pathSeparator.length()) : s;
            }

            @Override
            public boolean isCurrent() {
                return false;
            }

            @Override
            public void resetAttributes() {
                this._attributes.clear();
                this._attributes.put("file", null);
            }
        };
        PropertyMaps.TEMPLATE.setProperty("File", prop6);
        String msg7 = "Return true if the specified file exists.\nRequired attributes:\n\tfile=\"<file to test>\"\nMultiple files can be specified, separated by ${path.separator}, which is " + File.pathSeparator + " on this machine. If multiple files are specified, then a list of values, each separated by ${path.separator}, is returned.";
        DrJavaProperty prop7 = new DrJavaProperty("file.exists", msg7){

            @Override
            public void update(PropertyMaps pm) {
                String s = (String)this._attributes.get("file");
                if (s == null) {
                    this._value = "(file.exists Error... )";
                    return;
                }
                StringBuilder sb = new StringBuilder();
                for (String fs : s.split(TextUtil.regexEscape(File.pathSeparator), -1)) {
                    fs = StringOps.unescapeFileName(fs);
                    File f = new File(fs);
                    sb.append(File.pathSeparator);
                    sb.append(f.exists() ? "true" : "false");
                }
                s = sb.toString();
                this._value = s.startsWith(File.pathSeparator) ? s.substring(File.pathSeparator.length()) : s;
            }

            @Override
            public boolean isCurrent() {
                return false;
            }

            @Override
            public void resetAttributes() {
                this._attributes.clear();
                this._attributes.put("file", null);
            }
        };
        PropertyMaps.TEMPLATE.setProperty("File", prop7);
        String msg8 = "Return the path of the parent, or and empty string \"\" if no parent exists.\nRequired attributes:\n\tfile=\"<file for which to return the parent>\"\nMultiple files can be specified, separated by ${path.separator}, which is " + File.pathSeparator + " on this machine. If multiple files are specified, then a list of values, each separated by ${path.separator}, is returned.";
        DrJavaProperty prop8 = new DrJavaProperty("file.parent", msg8){

            @Override
            public void update(PropertyMaps pm) {
                String s = (String)this._attributes.get("file");
                if (s == null) {
                    this._value = "(file.parent Error...)";
                    return;
                }
                StringBuilder sb = new StringBuilder();
                for (String fs : s.split(TextUtil.regexEscape(File.pathSeparator), -1)) {
                    fs = StringOps.unescapeFileName(fs);
                    File f = new File(fs);
                    String p = StringOps.escapeFileName(f.getParent());
                    sb.append(File.pathSeparator);
                    sb.append(p != null ? p : "");
                }
                s = sb.toString();
                this._value = s.startsWith(File.pathSeparator) ? s.substring(File.pathSeparator.length()) : s;
            }

            @Override
            public boolean isCurrent() {
                return false;
            }

            @Override
            public void resetAttributes() {
                this._attributes.clear();
                this._attributes.put("file", null);
            }
        };
        PropertyMaps.TEMPLATE.setProperty("File", prop8);
        String msg9 = "Return the absolute path of the file which has been relative to another file.\nRequired attributes:\n\tfile=\"<file for which to return the absolute path>\"\n\tbase=\"<other file which serves as base path>\"\nMultiple files can be specified for the file attribute, each separated by ${path.separator}, which is " + File.pathSeparator + " on this machine. If multiple files are specified, then a list of values, each separated by ${path.separator}, is returned.";
        PropertyMaps.TEMPLATE.setProperty("File", new DrJavaProperty("file.abs", msg9){

            @Override
            public void update(PropertyMaps pm) {
                String s = (String)this._attributes.get("base");
                if (s == null) {
                    this._value = "(file.abs Error: base missing...)";
                    return;
                }
                s = StringOps.unescapeFileName(s);
                File base = new File(s);
                s = (String)this._attributes.get("file");
                if (s == null) {
                    this._value = "(file.abs Error: file missing...)";
                    return;
                }
                StringBuilder sb = new StringBuilder();
                for (String fs : s.split(TextUtil.regexEscape(File.pathSeparator), -1)) {
                    fs = StringOps.unescapeFileName(fs);
                    File f = new File(base, fs);
                    sb.append(File.pathSeparator);
                    sb.append(StringOps.escapeFileName(f.getAbsolutePath()));
                }
                s = sb.toString();
                this._value = s.startsWith(File.pathSeparator) ? s.substring(File.pathSeparator.length()) : s;
            }

            @Override
            public boolean isCurrent() {
                return false;
            }

            @Override
            public void resetAttributes() {
                this._attributes.clear();
                this._attributes.put("file", null);
                this._attributes.put("base", null);
            }
        });
        String msg10 = "Return the path of the file, relative to another file.\nRequired attributes:\n\tfile=\"<file for which to return the relative path>\"\n\tbase=\"<other file which serves as base path>\"\nMultiple files can be specified for the file attribute, each separated by ${path.separator}, which is " + File.pathSeparator + " on this machine. If multiple files are specified, then a list of values, each separated by ${path.separator}, is returned.";
        PropertyMaps.TEMPLATE.setProperty("File", new DrJavaProperty("file.rel", msg10){

            @Override
            public void update(PropertyMaps pm) {
                String s = (String)this._attributes.get("base");
                if (s == null) {
                    this._value = "(file.rel Error: base missing...)";
                    return;
                }
                s = StringOps.unescapeFileName(s);
                File b = new File(s);
                s = (String)this._attributes.get("file");
                if (s == null) {
                    this._value = "(file.rel Error: file missing...)";
                    return;
                }
                StringBuilder sb = new StringBuilder();
                for (String fs : s.split(TextUtil.regexEscape(File.pathSeparator), -1)) {
                    fs = StringOps.unescapeFileName(fs);
                    File f = new File(fs);
                    try {
                        File[] roots;
                        s = FileOps.stringMakeRelativeTo(f, b);
                        if (s.endsWith(File.separator) && (roots = File.listRoots()) != null) {
                            boolean equalsRoot = false;
                            for (File r : roots) {
                                if (!s.equals(r.toString())) continue;
                                equalsRoot = true;
                                break;
                            }
                            if (!equalsRoot) {
                                s = s.substring(0, s.length() - 1);
                            }
                        }
                        if (s.length() == 0) {
                            s = ".";
                        }
                        sb.append(File.pathSeparator);
                        sb.append(StringOps.escapeFileName(s));
                    }
                    catch (IOException e) {
                        this._value = "(file.rel I/O Error...)";
                        return;
                    }
                }
                s = sb.toString();
                this._value = s.startsWith(File.pathSeparator) ? s.substring(File.pathSeparator.length()) : s;
            }

            @Override
            public boolean isCurrent() {
                return false;
            }

            @Override
            public void resetAttributes() {
                this._attributes.clear();
                this._attributes.put("file", null);
                this._attributes.put("base", null);
            }
        });
        String msg11 = "Make the directory with the provided file name. Evaluates to the empty string \"\" if successful.\nRequired attributes:\n\tfile=\"<directory to create>\"\nMultiple files can be specified for the file attribute, each separated by ${path.separator}, which is " + File.pathSeparator + " on this machine. If multiple files are specified, then DrJava will attempt to make all those directories.";
        PropertyMaps.TEMPLATE.setProperty("File", new DrJavaProperty("file.mkdir", msg11){

            @Override
            public void update(PropertyMaps pm) {
                String s = (String)this._attributes.get("file");
                if (s == null) {
                    this._value = "(file.mkdir Error: file missing...)";
                    return;
                }
                for (String fs : s.split(TextUtil.regexEscape(File.pathSeparator), -1)) {
                    File n = new File(fs = StringOps.unescapeFileName(fs));
                    if (n.mkdir()) continue;
                    this._value = "(file.mkdir I/O Error...)";
                    return;
                }
                this._value = "";
            }

            @Override
            public boolean isCurrent() {
                return false;
            }

            @Override
            public void resetAttributes() {
                this._attributes.clear();
                this._attributes.put("file", null);
            }
        });
        String msg12 = "Remove the specified file or directory, recursively if desired. Evaluates to the empty string \"\" if successful.\nRequired attributes:\n\tfile=\"<file or directory to remove>\"\nOptional attributes:\n\trec=\"<true for recursive removal>\"\n(if not specified, false is used and removal is not recursive)\nMultiple files can be specified for the file attribute, each separated by ${path.separator}, which is " + File.pathSeparator + " on this machine. If multiple files are specified, then DrJava will attempt to remove all those files.";
        PropertyMaps.TEMPLATE.setProperty("File", new DrJavaProperty("file.rm", msg12){

            @Override
            public void update(PropertyMaps pm) {
                String s = (String)this._attributes.get("rec");
                boolean rec = new Boolean(s);
                s = (String)this._attributes.get("file");
                if (s == null) {
                    this._value = "(file.rm Error...)";
                    return;
                }
                s = StringOps.unescapeFileName(s);
                boolean res = false;
                for (String fs : s.split(TextUtil.regexEscape(File.pathSeparator), -1)) {
                    fs = StringOps.unescapeFileName(fs);
                    File f = new File(fs);
                    if (rec) {
                        try {
                            res = IOUtil.deleteRecursively(f);
                        }
                        catch (Exception e) {
                            res = false;
                        }
                        continue;
                    }
                    try {
                        res = f.delete();
                    }
                    catch (SecurityException e) {
                        res = false;
                    }
                }
                this._value = res ? "" : "(file.rm I/O Error...)";
            }

            @Override
            public boolean isCurrent() {
                return false;
            }

            @Override
            public void resetAttributes() {
                this._attributes.clear();
                this._attributes.put("file", null);
                this._attributes.put("rec", "false");
            }
        });
        String msg13 = "Move the specified file or directory to a new location. Evaluates to the empty string \"\" if successful.\nRequired attributes:\n\tfile=\"<file or directory to move>\"\tnew=\"<new location>\"";
        PropertyMaps.TEMPLATE.setProperty("File", new DrJavaProperty("file.mv", msg13){

            @Override
            public void update(PropertyMaps pm) {
                String s = (String)this._attributes.get("file");
                if (s == null) {
                    this._value = "(file.mv Error: file missing...)";
                    return;
                }
                File f = new File(s);
                s = (String)this._attributes.get("new");
                if (s == null) {
                    this._value = "(file.mv Error: new missing...)";
                    return;
                }
                File n = new File(s);
                boolean res = false;
                if (f.getParent() != null && f.getParent().equals(n.getParent())) {
                    res = IOUtil.attemptRenameTo(f, n);
                } else if (f.isFile()) {
                    try {
                        res = IOUtil.attemptMove(f, n);
                    }
                    catch (Exception e) {
                        res = false;
                    }
                } else {
                    try {
                        res = FileOps.moveRecursively(f, n);
                    }
                    catch (Exception e) {
                        res = false;
                    }
                }
                this._value = res ? "" : "(file.mv I/O Error...)";
            }

            @Override
            public boolean isCurrent() {
                return false;
            }

            @Override
            public void resetAttributes() {
                this._attributes.clear();
                this._attributes.put("file", null);
                this._attributes.put("new", null);
            }
        });
        String msg14 = "Returns the current time in milliseconds since 01/01/1970, unless other format is specified by the fmt attribute.\nOptional attributes:\n\tfmt=\"full\" or \"long\" or \"medium\" or \"short\"";
        PropertyMaps.TEMPLATE.setProperty("DrJava", new DrJavaProperty("drjava.current.time.millis", msg14){

            @Override
            public void update(PropertyMaps pm) {
                long millis = System.currentTimeMillis();
                String f = ((String)this._attributes.get("fmt")).toLowerCase();
                this._value = f.equals("full") ? DateFormat.getDateInstance(0).format(new Date(millis)) : (f.equals("long") ? DateFormat.getDateInstance(1).format(new Date(millis)) : (f.equals("medium") ? DateFormat.getDateInstance(2).format(new Date(millis)) : (f.equals("short") ? DateFormat.getDateInstance(3).format(new Date(millis)) : String.valueOf(millis))));
            }

            @Override
            public String getLazy(PropertyMaps pm) {
                return this.getCurrent(pm);
            }

            @Override
            public void resetAttributes() {
                this._attributes.clear();
                this._attributes.put("fmt", "millis");
            }
        });
        String msg15 = "Evaluates the string specified in the command attribute, but ignore the result of the evaluation. Only side effects of the evaluation are apparent. This property always evaluates to the empty string \"\" (unless the command attribute is missing).\nRequired attributes:\n\tcmd=\"<command to evaluate>\"";
        PropertyMaps.TEMPLATE.setProperty("Misc", new DrJavaProperty("ignore", msg15){

            @Override
            public void update(PropertyMaps pm) {
                String s = (String)this._attributes.get("cmd");
                if (s == null) {
                    this._value = "(ignore Error...)";
                    return;
                }
                this._value = "";
            }

            @Override
            public void resetAttributes() {
                this._attributes.clear();
                this._attributes.put("cmd", null);
            }
        });
        String msg16 = "If the cond attribute evaluates to true, returns the evaluation of the then attribute, otherwise the evaluation of the else attribute.\nRequired attribute:\n\tcond=\"<string evaluating to true of false>\"\nOptional attributes:\n\tthen=\"<evaluated if true>\"\n\telse=\"<evaluated if false>\"";
        PropertyMaps.TEMPLATE.setProperty("Misc", new DrJavaProperty("if", msg16){

            @Override
            public void update(PropertyMaps pm) {
                if (this._attributes.get("cond") == null) {
                    this._value = "(if Error...)";
                    return;
                }
                if (((String)this._attributes.get("cond")).toLowerCase().equals("true")) {
                    this._value = (String)this._attributes.get("then");
                } else if (((String)this._attributes.get("cond")).toLowerCase().equals("false")) {
                    this._value = (String)this._attributes.get("else");
                } else {
                    this._value = "(if Error...)";
                    return;
                }
            }

            @Override
            public String getCurrent(PropertyMaps pm) {
                this.invalidate();
                return super.getCurrent(pm);
            }

            @Override
            public String getLazy(PropertyMaps pm) {
                return this.getCurrent(pm);
            }

            @Override
            public void resetAttributes() {
                this._attributes.clear();
                this._attributes.put("cond", null);
                this._attributes.put("then", "");
                this._attributes.put("else", "");
            }
        });
        String msg17 = "If the op1 is greater than op2, returns true,false otherwise.\nRequired attributes:\n\top1=\"<string evaluating to a number>\"\n\top2=\"<string evaluating to a number>\"";
        Lambda2<Double, Double, Boolean> lam17 = new Lambda2<Double, Double, Boolean>(){

            @Override
            public Boolean value(Double op1, Double op2) {
                return op1 > op2;
            }
        };
        BinaryOpProperty<Double, Double, Boolean> prop17 = new BinaryOpProperty<Double, Double, Boolean>("gt", msg17, lam17, UnaryOpProperty.PARSE_DOUBLE, UnaryOpProperty.PARSE_DOUBLE, UnaryOpProperty.FORMAT_BOOL);
        PropertyMaps.TEMPLATE.setProperty("Misc", prop17);
        String msg18 = "If the op1 is less than op2, returns true,false otherwise.\nRequired attributes:\n\top1=\"<string evaluating to a number>\"\n\top2=\"<string evaluating to a number>\"";
        Lambda2<Double, Double, Boolean> lam18 = new Lambda2<Double, Double, Boolean>(){

            @Override
            public Boolean value(Double op1, Double op2) {
                return op1 < op2;
            }
        };
        BinaryOpProperty<Double, Double, Boolean> prop18 = new BinaryOpProperty<Double, Double, Boolean>("lt", msg18, lam18, UnaryOpProperty.PARSE_DOUBLE, UnaryOpProperty.PARSE_DOUBLE, UnaryOpProperty.FORMAT_BOOL);
        PropertyMaps.TEMPLATE.setProperty("Misc", prop18);
        String msg19 = "If the op1 is greater than or equal to op2, returns true,false otherwise.\nRequired attributes:\n\top1=\"<string evaluating to a number>\"\n\top2=\"<string evaluating to a number>\"";
        Lambda2<Double, Double, Boolean> lam19 = new Lambda2<Double, Double, Boolean>(){

            @Override
            public Boolean value(Double op1, Double op2) {
                return op1 >= op2;
            }
        };
        BinaryOpProperty<Double, Double, Boolean> prop19 = new BinaryOpProperty<Double, Double, Boolean>("gte", msg19, lam19, UnaryOpProperty.PARSE_DOUBLE, UnaryOpProperty.PARSE_DOUBLE, UnaryOpProperty.FORMAT_BOOL);
        PropertyMaps.TEMPLATE.setProperty("Misc", prop19);
        String msg20 = "If the op1 is less than or equal to op2, returns true,false otherwise.\nRequired attributes:\n\top1=\"<string evaluating to a number>\"\n\top2=\"<string evaluating to a number>\"";
        Lambda2<Double, Double, Boolean> lam20 = new Lambda2<Double, Double, Boolean>(){

            @Override
            public Boolean value(Double op1, Double op2) {
                return op1 <= op2;
            }
        };
        BinaryOpProperty<Double, Double, Boolean> prop20 = new BinaryOpProperty<Double, Double, Boolean>("lte", msg20, lam20, UnaryOpProperty.PARSE_DOUBLE, UnaryOpProperty.PARSE_DOUBLE, UnaryOpProperty.FORMAT_BOOL);
        PropertyMaps.TEMPLATE.setProperty("Misc", prop20);
        String msg21 = "If the op1 is equal to op2, returns true,false otherwise.\nRequired attributes:\n\top1=\"<string>\"\n\top2=\"<string>\"";
        Lambda2<String, String, Boolean> lam21 = new Lambda2<String, String, Boolean>(){

            @Override
            public Boolean value(String op1, String op2) {
                return op1.equals(op2);
            }
        };
        PropertyMaps.TEMPLATE.setProperty("Misc", new BinaryOpProperty<String, String, Boolean>("eq", msg21, lam21, UnaryOpProperty.PARSE_STRING, UnaryOpProperty.PARSE_STRING, UnaryOpProperty.FORMAT_BOOL));
        String msg22 = "If the op1 is not equal to op2, returns true,false otherwise.\nRequired attributes:\n\top1=\"<string>\"\n\top2=\"<string>\"";
        Lambda2<String, String, Boolean> lam22 = new Lambda2<String, String, Boolean>(){

            @Override
            public Boolean value(String op1, String op2) {
                return !op1.equals(op2);
            }
        };
        PropertyMaps.TEMPLATE.setProperty("Misc", new BinaryOpProperty<String, String, Boolean>("neq", msg22, lam22, UnaryOpProperty.PARSE_STRING, UnaryOpProperty.PARSE_STRING, UnaryOpProperty.FORMAT_BOOL));
        String msg23 = "If op1 and op2 are true, returns true,false otherwise.\nRequired attributes:\n\top1=\"<boolean>\"\n\top2=\"<boolean>\"";
        Lambda2<Boolean, Boolean, Boolean> lam23 = new Lambda2<Boolean, Boolean, Boolean>(){

            @Override
            public Boolean value(Boolean op1, Boolean op2) {
                return op1 != false && op2 != false;
            }
        };
        PropertyMaps.TEMPLATE.setProperty("Misc", new BinaryOpProperty<Boolean, Boolean, Boolean>("and", msg23, lam23, UnaryOpProperty.PARSE_BOOL, UnaryOpProperty.PARSE_BOOL, UnaryOpProperty.FORMAT_BOOL));
        String msg24 = "If at least one of op1, op2 is true, returns true,false otherwise.\nRequired attributes:\n\top1=\"<boolean>\"\n\top2=\"<boolean>\"";
        Lambda2<Boolean, Boolean, Boolean> lam24 = new Lambda2<Boolean, Boolean, Boolean>(){

            @Override
            public Boolean value(Boolean op1, Boolean op2) {
                return op1 != false || op2 != false;
            }
        };
        PropertyMaps.TEMPLATE.setProperty("Misc", new BinaryOpProperty<Boolean, Boolean, Boolean>("or", msg24, lam24, UnaryOpProperty.PARSE_BOOL, UnaryOpProperty.PARSE_BOOL, UnaryOpProperty.FORMAT_BOOL));
        Lambda<Boolean, Boolean> lam25 = new Lambda<Boolean, Boolean>(){

            @Override
            public Boolean value(Boolean op) {
                return op == false;
            }
        };
        PropertyMaps.TEMPLATE.setProperty("Misc", new UnaryOpProperty<Boolean, Boolean>("not", "If op is true, returns false,true otherwise.\nRequired attributes:\n\top=\"<boolean>\"", lam25, UnaryOpProperty.PARSE_BOOL, UnaryOpProperty.FORMAT_BOOL));
        Lambda2<Double, Double, Double> lam26 = new Lambda2<Double, Double, Double>(){

            @Override
            public Double value(Double op1, Double op2) {
                return op1 + op2;
            }
        };
        PropertyMaps.TEMPLATE.setProperty("Misc", new BinaryOpProperty<Double, Double, Double>("add", "Returns the sum of the two operands (op1+op2).\nRequired attributes:\n\top1=\"<string evaluating to a number>\"\n\top2=\"<string evaluating to a number>\"", lam26, UnaryOpProperty.PARSE_DOUBLE, UnaryOpProperty.PARSE_DOUBLE, UnaryOpProperty.FORMAT_DOUBLE));
        Lambda2<Double, Double, Double> lam27 = new Lambda2<Double, Double, Double>(){

            @Override
            public Double value(Double op1, Double op2) {
                return op1 - op2;
            }
        };
        PropertyMaps.TEMPLATE.setProperty("Misc", new BinaryOpProperty<Double, Double, Double>("sub", "Returns the difference between the two operands (op1-op2).\nRequired attributes:\n\top1=\"<string evaluating to a number>\"\n\top2=\"<string evaluating to a number>\"", lam27, UnaryOpProperty.PARSE_DOUBLE, UnaryOpProperty.PARSE_DOUBLE, UnaryOpProperty.FORMAT_DOUBLE));
        Lambda2<Double, Double, Double> lam28 = new Lambda2<Double, Double, Double>(){

            @Override
            public Double value(Double op1, Double op2) {
                return op1 * op2;
            }
        };
        PropertyMaps.TEMPLATE.setProperty("Misc", new BinaryOpProperty<Double, Double, Double>("mul", "Returns the product of the two operands (op1*op2).\nRequired attributes:\n\top1=\"<string evaluating to a number>\"\n\top2=\"<string evaluating to a number>\"", lam28, UnaryOpProperty.PARSE_DOUBLE, UnaryOpProperty.PARSE_DOUBLE, UnaryOpProperty.FORMAT_DOUBLE));
        Lambda2<Double, Double, Double> lam29 = new Lambda2<Double, Double, Double>(){

            @Override
            public Double value(Double op1, Double op2) {
                return op1 / op2;
            }
        };
        PropertyMaps.TEMPLATE.setProperty("Misc", new BinaryOpProperty<Double, Double, Double>("div", "Returns the quotient of the two operands (op1/op2).\nRequired attributes:\n\top1=\"<string evaluating to a number>\"\n\top2=\"<string evaluating to a number>\"", lam29, UnaryOpProperty.PARSE_DOUBLE, UnaryOpProperty.PARSE_DOUBLE, UnaryOpProperty.FORMAT_DOUBLE));
        Lambda<String, Double> lam30 = new Lambda<String, Double>(){

            @Override
            public Double value(String s) {
                return s.length();
            }
        };
        PropertyMaps.TEMPLATE.setProperty("Misc", new UnaryOpProperty<String, Double>("strlen", "Returns the length of the operand in characters.\nRequired attributes:\n\top=\"<string>\"", lam30, UnaryOpProperty.PARSE_STRING, UnaryOpProperty.FORMAT_DOUBLE));
        Lambda2<String, String, Double> lam31 = new Lambda2<String, String, Double>(){

            @Override
            public Double value(String s, String sep) {
                if (s.length() == 0) {
                    return 0.0;
                }
                return s.split(TextUtil.regexEscape(sep), -1).length;
            }
        };
        PropertyMaps.TEMPLATE.setProperty("Misc", new BinaryOpProperty<String, String, Double>("count", "Counts the number of elements in the list.\nRequired attributes:\n\tlist=\"<list string>\"\nOptional attributes:\n\tsep=\"<separator string>\"\n(if none specified, ${path.separator} will be used)", lam31, "list", null, UnaryOpProperty.PARSE_STRING, "sep", System.getProperty("path.separator"), UnaryOpProperty.PARSE_STRING, UnaryOpProperty.FORMAT_DOUBLE));
        String msg32 = "Extracts a sublist of elements from a list, beginning at a specified index, and including a specified number of elements.\nRequired attributes:\n\tlist=\"<list string>\"\n\tindex=\"<index in list, starting with 0>\"\nOptional attributes:\n\tcount=\"<number of items>\"\n(if not specified, 1 will be used)\n\tsep=\"<separator string>\"\n(if none specified, ${path.separator} will be used)";
        Lambda4<String, Double, Double, String, String> lam32 = new Lambda4<String, Double, Double, String, String>(){

            @Override
            public String value(String s, Double index, Double count, String sep) {
                if (s.length() == 0) {
                    return "";
                }
                int i = index.intValue();
                int c = count.intValue();
                StringBuilder sb = new StringBuilder();
                String[] els = s.split(TextUtil.regexEscape(sep), -1);
                for (int j = 0; j < c && i + j < els.length; ++j) {
                    sb.append(sep);
                    sb.append(els[i + j]);
                }
                s = sb.toString();
                if (s.length() >= sep.length()) {
                    return s.substring(sep.length());
                }
                return "";
            }
        };
        PropertyMaps.TEMPLATE.setProperty("Misc", new QuaternaryOpProperty<String, Double, Double, String, String>("sublist", msg32, lam32, "list", null, UnaryOpProperty.PARSE_STRING, "index", null, UnaryOpProperty.PARSE_DOUBLE, "count", "1", UnaryOpProperty.PARSE_DOUBLE, "sep", System.getProperty("path.separator"), UnaryOpProperty.PARSE_STRING, UnaryOpProperty.FORMAT_STRING));
        Lambda3<String, String, String, String> lam33 = new Lambda3<String, String, String, String>(){

            @Override
            public String value(String s, String oldSep, String newSep) {
                if (s.length() == 0) {
                    return "";
                }
                StringBuilder sb = new StringBuilder();
                for (String el : s.split(TextUtil.regexEscape(oldSep), -1)) {
                    sb.append(newSep);
                    sb.append(el);
                }
                s = sb.toString();
                if (s.startsWith(newSep)) {
                    s = s.substring(newSep.length());
                }
                return s;
            }
        };
        PropertyMaps.TEMPLATE.setProperty("Misc", new TernaryOpProperty<String, String, String, String>("change.sep", "Changes the separator used in a list of values.Required attributes:\n\tlist=\"<list string>\"\n\told=\"<old separator>\"\n\tnew=\"<new separator>\"", lam33, "list", null, UnaryOpProperty.PARSE_STRING, "old", null, UnaryOpProperty.PARSE_STRING, "new", null, UnaryOpProperty.PARSE_STRING, UnaryOpProperty.FORMAT_STRING));
        Lambda3<String, String, String, String> lam34 = new Lambda3<String, String, String, String>(){

            @Override
            public String value(String s, String oldStr, String newStr) {
                if (s.length() == 0) {
                    return "";
                }
                return s.replaceAll(TextUtil.regexEscape(oldStr), newStr);
            }
        };
        PropertyMaps.TEMPLATE.setProperty("Misc", new TernaryOpProperty<String, String, String, String>("replace.string", "Replaces each occurrence in a string.Required attributes:\n\ttext=\"<text in which to replace>\"\n\told=\"<old string>\"\n\tnew=\"<new string>\"", lam34, "text", null, UnaryOpProperty.PARSE_STRING, "old", null, UnaryOpProperty.PARSE_STRING, "new", null, UnaryOpProperty.PARSE_STRING, UnaryOpProperty.FORMAT_STRING));
        String msg35 = "Read data from an XML file.\nRequired attributes:\n\tfile=\"<file with the XML>\"\n\tpath=\"<path into the XML tree>\"\n\tdefault=\"<default value if not found>\"\n\tmulti=\"<true if multiple values are allowed>\"\n\tsep=\"<separator between results>\"";
        PropertyMaps.TEMPLATE.setProperty("Misc", new DrJavaProperty("xml.in", "(XML Input...)", msg35){

            @Override
            public String toString() {
                return "(XML Input...)";
            }

            @Override
            public void update(PropertyMaps pm) {
                String xmlfile = (String)this._attributes.get("file");
                String xmlpath = (String)this._attributes.get("path");
                String defval = (String)this._attributes.get("default");
                String multi = (String)this._attributes.get("multi");
                String sep = (String)this._attributes.get("sep");
                if (xmlfile == null || xmlpath == null || defval == null) {
                    this._value = "(XML Input Error...)";
                    return;
                }
                try {
                    File f = new File(xmlfile);
                    if (!f.exists()) {
                        this._value = defval;
                        return;
                    }
                    XMLConfig xc = new XMLConfig(f);
                    List<String> values = xc.getMultiple(xmlpath);
                    if (!"true".equals(multi.toLowerCase())) {
                        if (values.size() != 1) {
                            this._value = defval;
                            return;
                        }
                        this._value = values.get(0);
                        return;
                    }
                    StringBuilder sb = new StringBuilder();
                    for (String v : values) {
                        sb.append(sep);
                        sb.append(v);
                    }
                    this._value = sb.toString().substring(1);
                }
                catch (XMLConfig.XMLConfigException xce) {
                    this._value = defval;
                }
            }

            @Override
            public String getCurrent(PropertyMaps pm) {
                this.invalidate();
                return super.getCurrent(pm);
            }

            @Override
            public void resetAttributes() {
                this._attributes.clear();
                this._attributes.put("file", null);
                this._attributes.put("path", null);
                this._attributes.put("default", null);
                this._attributes.put("multi", "true");
                this._attributes.put("sep", File.pathSeparator);
            }
        });
        String msg36 = "Write data to an XML file. Since this is an action, it will not produce any output, but it will write to the XML file.\nRequired attributes:\n\tfile=\"<file with the XML>\"\n\tpath=\"<path into the XML tree>\"\n\tcontent=\"<value to write into the XML>\"\n\tappend=\"<true to append, false to overwrite existing>\"";
        PropertyMaps.TEMPLATE.setProperty("Misc", new DrJavaProperty("xml.out.action", "(XML Output...)", msg36){

            @Override
            public String toString() {
                return "(XML Output...)";
            }

            @Override
            public void update(PropertyMaps pm) {
                String xmlfile = (String)this._attributes.get("file");
                String xmlpath = (String)this._attributes.get("path");
                String content = (String)this._attributes.get("content");
                String append = (String)this._attributes.get("append");
                if (xmlfile == null || xmlpath == null) {
                    this._value = "(XML Output Error...)";
                }
                try {
                    File f = new File(xmlfile);
                    XMLConfig xc = f.exists() ? new XMLConfig(f) : new XMLConfig();
                    xc.set(xmlpath, content, append.toLowerCase().equals("false"));
                    xc.save(xmlfile);
                    this._value = "";
                }
                catch (XMLConfig.XMLConfigException xce) {
                    this._value = "(XML Output Error...)";
                }
            }

            @Override
            public String getCurrent(PropertyMaps pm) {
                this.invalidate();
                return super.getCurrent(pm);
            }

            @Override
            public void resetAttributes() {
                this._attributes.clear();
                this._attributes.put("file", null);
                this._attributes.put("path", null);
                this._attributes.put("content", "");
                this._attributes.put("append", "false");
            }
        });
        String msg37 = "Create a new scope and define a variable with the specified name and value; then evaluate the command with the new variable in the environment.\nRequired attributes:\n\tname=\"<name of the variable>\"\n\tval=\"<value of the variable>\"\n\tcmd=\"<command to evaluate>\"";
        PropertyMaps.TEMPLATE.setProperty("Misc", new DrJavaProperty("var", msg37){

            @Override
            public void update(PropertyMaps pm) {
                String name = (String)this._attributes.get("name");
                String val = (String)this._attributes.get("val");
                String cmd = (String)this._attributes.get("cmd");
                if (name == null) {
                    this._value = "(var Error: name missing...)";
                    return;
                }
                if (val == null) {
                    this._value = "(var Error: val missing...)";
                    return;
                }
                if (cmd == null) {
                    this._value = "(var Error: cmd missing...)";
                    return;
                }
                try {
                    PropertyMaps.TEMPLATE.addVariable(name, val);
                    this._value = StringOps.replaceVariables(cmd, pm, PropertyMaps.GET_CURRENT);
                    PropertyMaps.TEMPLATE.removeVariable(name);
                }
                catch (IllegalArgumentException e) {
                    this._value = "(var Error: " + e.getMessage() + "...)";
                }
            }

            @Override
            public String getLazy(PropertyMaps pm) {
                return this.getCurrent(pm);
            }

            @Override
            public boolean isCurrent() {
                return false;
            }

            @Override
            public void resetAttributes() {
                this._attributes.clear();
                this._attributes.put("name", null);
                this._attributes.put("val", null);
                this._attributes.put("cmd", null);
            }

            @Override
            public String toString() {
                return "--uninitialized--";
            }

            @Override
            public void setAttributes(HashMap<String, String> attrs, Lambda<String, String> replaceLambda) {
                for (Map.Entry<String, String> e : attrs.entrySet()) {
                    if (e.getKey().equals("cmd")) {
                        this.setAttribute(e.getKey(), e.getValue());
                        continue;
                    }
                    this.setAttribute(e.getKey(), replaceLambda.value(e.getValue()));
                }
            }
        });
        String msg38 = "Mutate the value of the variable with the specified name and value.\nRequired attributes:\n\tname=\"<name of the variable>\"\n\tval=\"<value of the variable>\"";
        PropertyMaps.TEMPLATE.setProperty("Misc", new DrJavaProperty("var.set", msg38){

            @Override
            public void update(PropertyMaps pm) {
                String name = (String)this._attributes.get("name");
                String val = (String)this._attributes.get("val");
                if (name == null) {
                    this._value = "(var.set Error: name missing...)";
                    return;
                }
                if (val == null) {
                    this._value = "(var.set Error: val missing...)";
                    return;
                }
                try {
                    pm.setVariable(name, val);
                }
                catch (IllegalArgumentException e) {
                    this._value = "(var.set Error: " + e.getMessage() + "...)";
                    return;
                }
                this._value = "";
            }

            @Override
            public String getLazy(PropertyMaps pm) {
                return this.getCurrent(pm);
            }

            @Override
            public boolean isCurrent() {
                return false;
            }

            @Override
            public void resetAttributes() {
                this._attributes.clear();
                this._attributes.put("name", null);
                this._attributes.put("val", null);
            }

            @Override
            public String toString() {
                return "";
            }
        });
        String msg39 = "Create a new scope and define a variable with the specified name. Then process the given list in smaller pieces, assigning them to the variable.\nRequired attributes:\n\tlist=\"<list string>\"\n\tvar=\"<name of the variable>\"\n\tcmd=\"<command to evaluate for each piece>\"\nOptional attributes:\n\tsep=\"<separator between elements>\"\n(if not defined, ${path.separator}, which is " + File.pathSeparator + " on this machine)\n\toutsep=\"<separator between elements in the output>\"\n(if not defined, ${process.separator}, which is " + ProcessChain.PROCESS_SEPARATOR + " on this machine, will be used)\n\teach=\"<number of elements to process as one piece>\"\n(if not defined, 1 is used)";
        PropertyMaps.TEMPLATE.setProperty("Misc", new DrJavaProperty("for", msg39){

            @Override
            public void update(PropertyMaps pm) {
                String val;
                String list = (String)this._attributes.get("list");
                String var = (String)this._attributes.get("var");
                String cmd = (String)this._attributes.get("cmd");
                if (list == null) {
                    this._value = "(for Error: list missing...)";
                    return;
                }
                if (var == null) {
                    this._value = "(for Error: var missing...)";
                    return;
                }
                if (cmd == null) {
                    this._value = "(for Error: cmd missing...)";
                    return;
                }
                String sep = (String)this._attributes.get("sep");
                String outSep = (String)this._attributes.get("outsep");
                int each = 1;
                try {
                    each = new Integer((String)this._attributes.get("each"));
                    if (each < 1) {
                        throw new NumberFormatException();
                    }
                }
                catch (NumberFormatException e) {
                    this._value = "(for Error: each not a positive number...)";
                    return;
                }
                StringBuilder sb = new StringBuilder();
                StringBuilder sbVar = new StringBuilder();
                pm.addVariable(var, "");
                try {
                    String[] els = list.split(TextUtil.regexEscape(sep), -1);
                    for (int start = 0; start < els.length; start += each) {
                        sbVar.setLength(0);
                        for (int i = start; i < start + each && i < els.length; ++i) {
                            sbVar.append(sep);
                            sbVar.append(els[i]);
                        }
                        val = sbVar.toString();
                        if (val.startsWith(sep)) {
                            val = val.substring(sep.length());
                        }
                        pm.setVariable(var, val);
                        sb.append(outSep);
                        sb.append(StringOps.replaceVariables(cmd, pm, PropertyMaps.GET_CURRENT));
                    }
                }
                catch (IllegalArgumentException e) {
                    this._value = "(for Error: " + e.getMessage() + "...)";
                }
                pm.removeVariable(var);
                val = sb.toString();
                if (val.startsWith(outSep)) {
                    val = val.substring(outSep.length());
                }
                this._value = val;
            }

            @Override
            public boolean isCurrent() {
                return false;
            }

            @Override
            public void resetAttributes() {
                this._attributes.clear();
                this._attributes.put("list", null);
                this._attributes.put("var", null);
                this._attributes.put("cmd", null);
                this._attributes.put("sep", File.pathSeparator);
                this._attributes.put("outsep", ProcessChain.PROCESS_SEPARATOR);
                this._attributes.put("each", "1");
            }

            @Override
            public String toString() {
                return "--uninitialized--";
            }

            @Override
            public void setAttributes(HashMap<String, String> attrs, Lambda<String, String> replaceLambda) {
                for (Map.Entry<String, String> e : attrs.entrySet()) {
                    if (e.getKey().equals("cmd")) {
                        this.setAttribute(e.getKey(), e.getValue());
                        continue;
                    }
                    this.setAttribute(e.getKey(), replaceLambda.value(e.getValue()));
                }
            }
        });
        ConstantProperty prop40 = new ConstantProperty("process.separator", ProcessChain.PROCESS_SEPARATOR, "This property contains the separator used between processes.");
        PropertyMaps.TEMPLATE.setProperty("Config", prop40);
        String msg41 = "If the command line was enclosed in a .djapp file that was a JAR file, then this property contains the file. Otherwise, it is empty.\nOptional attributes:\n\trel=\"<dir to which the files are relative>\"\n\tsquote=\"<true to enclose file in single quotes>\"\n\tdquote=\"<true to enclose file in double quotes>\"";
        PropertyMaps.TEMPLATE.setProperty("Misc", new MutableFileProperty("enclosing.djapp.file", null, msg41));
        String[] cps = System.getProperty("java.class.path").split(TextUtil.regexEscape(File.pathSeparator), -1);
        File found = null;
        for (String cp : cps) {
            try {
                JarFile jf;
                File f = new File(cp);
                if (!f.exists()) continue;
                if (f.isDirectory()) {
                    File cf = new File(f, DrJava.class.getName().replace('.', File.separatorChar) + ".class");
                    if (!cf.exists() || !cf.isFile()) continue;
                    found = f;
                    break;
                }
                if (!f.isFile() || (jf = new JarFile(f)).getJarEntry(DrJava.class.getName().replace('.', '/') + ".class") == null) continue;
                found = f;
                break;
            }
            catch (IOException f) {
                // empty catch block
            }
        }
        final File drjavaFile = found;
        String msg42 = "Returns the executable file of DrJava that is currently running.\nOptional attributes:\n\trel=\"<dir to which the output should be relative\"\n\tsquote=\"<true to enclose file in single quotes>\"\n\tdquote=\"<true to enclose file in double quotes>\"";
        Thunk<File> thunk42 = new Thunk<File>(){

            @Override
            public File value() {
                return drjavaFile;
            }
        };
        FileProperty prop42 = new FileProperty("drjava.file", (Thunk)thunk42, msg42){

            @Override
            public String getLazy(PropertyMaps pm) {
                return this.getCurrent(pm);
            }
        };
        PropertyMaps.TEMPLATE.setProperty("Misc", prop42);
        String msg43 = "Returns the Java interpreter executable file.\nOptional attributes:\n\trel=\"<dir to which the output should be relative\"\n\tsquote=\"<true to enclose file in single quotes>\"\n\tdquote=\"<true to enclose file in double quotes>\"";
        FileProperty prop43 = new FileProperty("java.file", (Thunk)new Thunk<File>(){

            @Override
            public File value() {
                return new File(JVMBuilder.DEFAULT.javaCommand());
            }
        }, msg43){

            @Override
            public String getLazy(PropertyMaps pm) {
                return this.getCurrent(pm);
            }
        };
        PropertyMaps.TEMPLATE.setProperty("Misc", prop43);
        PropertyMaps.TEMPLATE.setProperty("Misc", new DrJavaProperty("echo", "Echo text to the console.\nRequired attributes:\n\ttext=\"<text to echo>\""){

            @Override
            public void update(PropertyMaps pm) {
                String text = (String)this._attributes.get("text");
                if (text == null) {
                    this._value = "(echo Error: text missing...)";
                    return;
                }
                StringBuilder sb = new StringBuilder();
                String osName = System.getProperty("os.name");
                if (osName.indexOf("Windows") >= 0) {
                    String exe = "cmd";
                    if (osName.indexOf("95") >= 0 || osName.indexOf("98") >= 0) {
                        exe = "command";
                    }
                    if (JavaVersion.CURRENT.supports(JavaVersion.JAVA_5)) {
                        String var = System.getenv("ComSpec");
                        if (var != null) {
                            sb.append(var);
                        } else {
                            var = System.getenv("WinDir");
                            if (var != null) {
                                sb.append(var);
                                sb.append("\\System32\\");
                            }
                            sb.append(exe);
                        }
                    } else {
                        sb.append(exe);
                    }
                    sb.append(" /c echo ");
                    sb.append(text);
                } else {
                    sb.append("echo ");
                    sb.append(text);
                }
                this._value = sb.toString();
            }

            @Override
            public boolean isCurrent() {
                return false;
            }

            @Override
            public void resetAttributes() {
                this._attributes.clear();
                this._attributes.put("text", null);
            }

            @Override
            public String toString() {
                return "--uninitialized--";
            }
        });
    }
}

