/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.config;

import edu.rice.cs.drjava.DrJava;
import edu.rice.cs.drjava.Version;
import edu.rice.cs.drjava.config.OptionConstants;
import edu.rice.cs.drjava.config.OptionEvent;
import edu.rice.cs.drjava.config.OptionListener;
import edu.rice.cs.plt.concurrent.JVMBuilder;
import edu.rice.cs.util.StringOps;
import edu.rice.cs.util.swing.ConfirmCheckBoxDialog;
import java.awt.EventQueue;
import java.io.IOException;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class ConfigOptionListeners
implements OptionConstants {
    public static void sanitizeSlaveJVMArgs(JFrame parent, String value, final OptionListener<String> l) {
        int pos = value.indexOf("-Xmx");
        if (pos > 1 && Character.isWhitespace(value.charAt(pos - 1)) || pos == 0) {
            int result;
            Object[] options;
            long heapSize;
            int endpos;
            for (endpos = pos + "-Xmx".length(); endpos < value.length() && !Character.isWhitespace(value.charAt(endpos)); ++endpos) {
            }
            int startpos = pos + "-Xmx".length();
            String size = value.substring(startpos, endpos);
            long factor = 1L;
            switch (size.toLowerCase().charAt(size.length() - 1)) {
                case 'g': {
                    factor *= 1024L;
                }
                case 'm': {
                    factor *= 1024L;
                }
                case 'k': {
                    factor *= 1024L;
                    break;
                }
                default: {
                    if (Character.isDigit(size.toLowerCase().charAt(size.length() - 1))) break;
                    factor = 0L;
                }
            }
            try {
                heapSize = factor == 1L ? new Long(size) : (factor > 1L ? new Long(size.substring(0, size.length() - 1)) * factor : -1L);
            }
            catch (NumberFormatException nfe) {
                heapSize = -1L;
            }
            long heapSizeMB = heapSize / 1024L / 1024L;
            String newSetting = ConfigOptionListeners.getNextBiggerHeapSize(heapSizeMB);
            if (heapSize >= 0L) {
                options = new String[]{"Copy to \"Maximum Heap\" Setting", "Clean \"Slave JVM Args\"", "Ignore"};
                result = JOptionPane.showOptionDialog(parent, "You seem to have specified the maximum heap size as part of the\n\"JVM Args for Interactions JVM\" setting: \"-Xmx" + size + "\"\nThe \"Maximum Heap Memory for Interactions JVM\" setting should be used instead.\nWould you like to copy the value \"" + newSetting + "\" into the \"Maximum Heap\" setting,\njust clean up \"JVM Args for Interactions JVM\", or ignore this potential problem?", "Maximum Heap Size Set in JVM Arguments", 0, 3, null, options, options[0]);
            } else {
                options = new String[]{"Clean \"Main JVM Args\"", "Ignore"};
                result = JOptionPane.showOptionDialog(parent, "You seem to have specified the maximum heap size as part of the\n\"JVM Args for Interactions JVM\" setting: \"-Xmx" + size + "\"\nThe \"Maximum Heap Memory for Interactions JVM\" setting should be used instead.\nFurthermore, the specified heap size \"" + size + "\" is invalid.\nWould you like to clean up the \"JVM Args for Interactions JVM\"\nor ignore this potential problem?", "Maximum Heap Size Set in JVM Arguments", 0, 3, null, options, options[0]);
                if (result == 1) {
                    result = 2;
                }
            }
            if (result != 2) {
                while (endpos < value.length() && Character.isWhitespace(value.charAt(endpos))) {
                    ++endpos;
                }
                String newValue = value.substring(0, pos) + value.substring(endpos);
                DrJava.getConfig().removeOptionListener(SLAVE_JVM_ARGS, l);
                DrJava.getConfig().addOptionListener(SLAVE_JVM_ARGS, new OptionListener<String>(){

                    @Override
                    public void optionChanged(OptionEvent<String> oe) {
                        DrJava.getConfig().removeOptionListener(OptionConstants.SLAVE_JVM_ARGS, this);
                        EventQueue.invokeLater(new Runnable(){
                            final /* synthetic */ 1 this$0;
                            {
                                this.this$0 = this$0;
                            }

                            @Override
                            public void run() {
                                DrJava.getConfig().addOptionListener(OptionConstants.SLAVE_JVM_ARGS, l);
                            }
                        });
                    }
                });
                DrJava.getConfig().setSetting(SLAVE_JVM_ARGS, newValue);
                if (result == 0) {
                    DrJava.getConfig().setSetting(SLAVE_JVM_XMX, newSetting);
                } else {
                    JOptionPane.showMessageDialog(parent, "You will have to reset the interactions pane before changes take effect.");
                }
            }
        }
    }

    public static void sanitizeSlaveJVMXMX(JFrame parent, String value) {
        if (!value.equals("") && !value.equals(OptionConstants.heapSizeChoices.get(0))) {
            long heapSize;
            String size = value.trim();
            try {
                heapSize = new Long(size);
            }
            catch (NumberFormatException nfe) {
                heapSize = -1L;
            }
            if (heapSize < 0L) {
                Object[] options = new String[]{"Clean \"Maximum Heap\" Setting", "Ignore"};
                int result = JOptionPane.showOptionDialog(parent, "The \"Maximum Heap Memory for Interactions JVM\" setting is invalid: \"" + size + "\"\nWould you like to clean up the \"Maximum Heap\" setting or ignore this potential problem?", "Invalid Maximum Heap Size", 0, 3, null, options, options[0]);
                if (result == 0) {
                    DrJava.getConfig().setSetting(SLAVE_JVM_XMX, OptionConstants.heapSizeChoices.get(0));
                }
            } else if (heapSize > 0L && !ConfigOptionListeners.checkHeapSize(heapSize)) {
                JOptionPane.showMessageDialog(parent, "The \"Maximum Heap Memory for Interactions JVM\" setting is too big: \"" + size + "\"\nDrJava has reset the heap size to the default. You should choose something smaller.", "Maximum Heap Size Too Big", 0);
                DrJava.getConfig().setSetting(SLAVE_JVM_XMX, OptionConstants.heapSizeChoices.get(0));
            }
        }
    }

    static String getNextBiggerHeapSize(long heapSizeMB) {
        String newSetting = OptionConstants.heapSizeChoices.get(0);
        for (int i = 1; i < OptionConstants.heapSizeChoices.size(); ++i) {
            try {
                newSetting = OptionConstants.heapSizeChoices.get(i);
                float choice = new Float(newSetting).floatValue();
                if (!(choice >= (float)heapSizeMB)) continue;
                return newSetting;
            }
            catch (NumberFormatException nfe) {
                return OptionConstants.heapSizeChoices.get(0);
            }
        }
        return newSetting;
    }

    public static void sanitizeMasterJVMArgs(JFrame parent, String value, final OptionListener<String> l) {
        int pos = value.indexOf("-Xmx");
        if (pos > 1 && Character.isWhitespace(value.charAt(pos - 1)) || pos == 0) {
            int result;
            Object[] options;
            long heapSize;
            int endpos;
            for (endpos = pos + "-Xmx".length(); endpos < value.length() && !Character.isWhitespace(value.charAt(endpos)); ++endpos) {
            }
            int startpos = pos + "-Xmx".length();
            String size = value.substring(startpos, endpos);
            long factor = 1L;
            switch (size.toLowerCase().charAt(size.length() - 1)) {
                case 'g': {
                    factor *= 1024L;
                }
                case 'm': {
                    factor *= 1024L;
                }
                case 'k': {
                    factor *= 1024L;
                    break;
                }
                default: {
                    if (Character.isDigit(size.toLowerCase().charAt(size.length() - 1))) break;
                    factor = 0L;
                }
            }
            try {
                heapSize = factor == 1L ? new Long(size) : (factor > 1L ? new Long(size.substring(0, size.length() - 1)) * factor : -1L);
            }
            catch (NumberFormatException nfe) {
                heapSize = -1L;
            }
            long heapSizeMB = heapSize / 1024L / 1024L;
            String newSetting = ConfigOptionListeners.getNextBiggerHeapSize(heapSizeMB);
            if (heapSize >= 0L) {
                options = new String[]{"Copy to \"Maximum Heap\" Setting", "Clean \"Master JVM Args\"", "Ignore"};
                result = JOptionPane.showOptionDialog(parent, "You seem to have specified the maximum heap size as part of the\n\"JVM Args for Main JVM\" setting: \"-Xmx" + size + "\"\nThe \"Maximum Heap Memory for Main JVM\" setting should be used instead.\nWould you like to copy the value \"" + newSetting + "\" into the \"Maximum Heap\" setting,\njust clean up \"JVM Args for Main JVM\", or ignore this potential problem?", "Maximum Heap Size Set in JVM Arguments", 0, 3, null, options, options[0]);
            } else {
                options = new String[]{"Clean \"Main JVM Args\"", "Ignore"};
                result = JOptionPane.showOptionDialog(parent, "You seem to have specified the maximum heap size as part of the\n\"JVM Args for Main JVM\" setting: \"-Xmx" + size + "\"\nThe \"Maximum Heap Memory for Main JVM\" setting should be used instead.\nFurthermore, the specified heap size \"" + size + "\" is invalid.\nWould you like to clean up the \"JVM Args for Main JVM\"\nor ignore this potential problem?", "Maximum Heap Size Set in JVM Arguments", 0, 3, null, options, options[0]);
                if (result == 1) {
                    result = 2;
                }
            }
            if (result != 2) {
                while (endpos < value.length() && Character.isWhitespace(value.charAt(endpos))) {
                    ++endpos;
                }
                String newValue = value.substring(0, pos) + value.substring(endpos);
                DrJava.getConfig().removeOptionListener(MASTER_JVM_ARGS, l);
                DrJava.getConfig().addOptionListener(MASTER_JVM_ARGS, new OptionListener<String>(){

                    @Override
                    public void optionChanged(OptionEvent<String> oe) {
                        DrJava.getConfig().removeOptionListener(OptionConstants.MASTER_JVM_ARGS, this);
                        EventQueue.invokeLater(new Runnable(){
                            final /* synthetic */ 2 this$0;
                            {
                                this.this$0 = this$0;
                            }

                            @Override
                            public void run() {
                                DrJava.getConfig().addOptionListener(OptionConstants.MASTER_JVM_ARGS, l);
                            }
                        });
                    }
                });
                DrJava.getConfig().setSetting(MASTER_JVM_ARGS, newValue);
                if (result == 0) {
                    DrJava.getConfig().setSetting(MASTER_JVM_XMX, newSetting);
                } else {
                    JOptionPane.showMessageDialog(parent, "You will have to restart DrJava before the change takes effect.");
                }
            }
        }
    }

    public static void sanitizeMasterJVMXMX(JFrame parent, String value) {
        if (!value.equals("") && !value.equals(OptionConstants.heapSizeChoices.get(0))) {
            long heapSize;
            String size = value.trim();
            try {
                heapSize = new Long(size);
            }
            catch (NumberFormatException nfe) {
                heapSize = -1L;
            }
            if (heapSize < 0L) {
                Object[] options = new String[]{"Clean \"Maximum Heap\" Setting", "Ignore"};
                int result = JOptionPane.showOptionDialog(parent, "The \"Maximum Heap Memory for Main JVM\" setting is invalid: \"" + size + "\"\nWould you like to clean up the \"Maximum Heap\" setting or ignore this potential problem?", "Invalid Maximum Heap Size", 0, 3, null, options, options[0]);
                if (result == 0) {
                    DrJava.getConfig().setSetting(MASTER_JVM_XMX, OptionConstants.heapSizeChoices.get(0));
                }
            } else if (heapSize > 0L && !ConfigOptionListeners.checkHeapSize(heapSize)) {
                JOptionPane.showMessageDialog(parent, "The \"Maximum Heap Memory for Main JVM\" setting is too big: \"" + size + "\"\nDrJava has reset the heap size to the default. You should choose something smaller.", "Maximum Heap Size Too Big", 0);
                DrJava.getConfig().setSetting(MASTER_JVM_XMX, OptionConstants.heapSizeChoices.get(0));
            }
        }
    }

    public static boolean checkHeapSize(long heapSize) {
        int exitValue = 1;
        try {
            JVMBuilder jvmb = JVMBuilder.DEFAULT.jvmArguments("-Xmx" + heapSize + "M");
            Process p = jvmb.start(MemoryCheckDummy.class.getName(), new String[0]);
            exitValue = p.waitFor();
        }
        catch (IOException e) {
            exitValue = 1;
        }
        catch (InterruptedException e) {
            exitValue = 1;
        }
        return exitValue == 0;
    }

    public static void sanitizeJavadocCustomParams(JFrame parent, String value) {
        boolean containsPackage;
        boolean containsPrivate = value.indexOf("-private") >= 0;
        boolean containsProtected = value.indexOf("-protected") >= 0;
        boolean containsPublic = value.indexOf("-public") >= 0;
        boolean bl = containsPackage = value.indexOf("-package") >= 0;
        if (containsPrivate || containsProtected || containsPublic || containsPackage) {
            StringBuilder sb = new StringBuilder();
            if (containsPublic) {
                sb.append("-public ");
            }
            if (containsProtected) {
                sb.append("-protected ");
            }
            if (containsPrivate) {
                sb.append("-private ");
            }
            if (containsPackage) {
                sb.append("-package ");
            }
            Object[] options = new String[]{"Copy to \"Access Level\" Setting", "Clean \"Custom Javadoc Parameters\"", "Ignore"};
            int result = JOptionPane.showOptionDialog(parent, "You seem to have specified " + sb.toString() + "as part of the\n\"Custom Javadoc Parameters\" setting. The \"Access Level\"\nsetting should be used instead. Would you like to copy the\nparameter into the \"Access Level\" setting, just clean up\n\"Custom Javadoc Parameters\", or ignore this potential problem?", "Access Level Set in Custom Javadoc Parameters", 0, 3, null, options, options[0]);
            if (result != 2) {
                if (result == 0) {
                    if (containsPublic) {
                        DrJava.getConfig().setSetting(JAVADOC_ACCESS_LEVEL, "public");
                    } else if (containsProtected) {
                        DrJava.getConfig().setSetting(JAVADOC_ACCESS_LEVEL, "protected");
                    } else if (containsPrivate) {
                        DrJava.getConfig().setSetting(JAVADOC_ACCESS_LEVEL, "private");
                    } else if (containsPackage) {
                        DrJava.getConfig().setSetting(JAVADOC_ACCESS_LEVEL, "package");
                    }
                }
                String[] params = value.split("(-private|-protected|-package|-public)");
                sb = new StringBuilder();
                for (int i = 0; i < params.length; ++i) {
                    if (params[i].trim().equals("")) continue;
                    sb.append(params[i].trim());
                    sb.append(' ');
                }
                DrJava.getConfig().setSetting(JAVADOC_CUSTOM_PARAMS, sb.toString().trim());
            }
        }
    }

    public static class MemoryCheckDummy {
        public static void main(String[] args) {
            StringBuilder sb = new StringBuilder("DrJava Version : ");
            sb.append(Version.getVersionString());
            sb.append("\nDrJava Build Time: ");
            sb.append(Version.getBuildTimeString());
            sb.append("\n\nUsed memory: about ");
            sb.append(StringOps.memSizeToString(Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()));
            sb.append("\nFree memory: about ");
            sb.append(StringOps.memSizeToString(Runtime.getRuntime().freeMemory()));
            sb.append("\nTotal memory: about ");
            sb.append(StringOps.memSizeToString(Runtime.getRuntime().totalMemory()));
            sb.append("\nTotal memory can expand to: about ");
            sb.append(StringOps.memSizeToString(Runtime.getRuntime().maxMemory()));
            System.out.println(sb.toString());
            System.exit(0);
        }
    }

    public static class DefaultCompilerListener
    implements OptionListener<String> {
        protected JFrame _parent;

        public DefaultCompilerListener(JFrame parent) {
            this._parent = parent;
        }

        @Override
        public void optionChanged(OptionEvent<String> oe) {
            ConfirmCheckBoxDialog dialog;
            String title = "Apply Default Compiler Preference Change";
            String msg = "Default Compiler Preference will take effect when you restart DrJava.";
            if (DrJava.getConfig().getSetting(OptionConstants.WARN_CHANGE_DCP).booleanValue() && (dialog = new ConfirmCheckBoxDialog(this._parent, title, msg, "Do not show this message again", 1, -1)).show() == 0 && dialog.getCheckBoxValue()) {
                DrJava.getConfig().setSetting(OptionConstants.WARN_CHANGE_DCP, Boolean.FALSE);
            }
        }
    }

    public static class RequiresInteractionsRestartListener<T>
    implements OptionListener<T> {
        protected JFrame _parent;
        protected String _description;

        public RequiresInteractionsRestartListener(JFrame parent, String description) {
            this._parent = parent;
            this._description = description;
        }

        @Override
        public void optionChanged(OptionEvent<T> oe) {
            ConfirmCheckBoxDialog dialog;
            String title = "Apply Preference Changes";
            String msg = "Changes to the '" + this._description + "' preferences\nwill only take effect when you reset the Interactions Pane.";
            if (DrJava.getConfig().getSetting(OptionConstants.WARN_CHANGE_INTERACTIONS).booleanValue() && (dialog = new ConfirmCheckBoxDialog(this._parent, title, msg, "Do not show this message again", 1, -1)).show() == 0 && dialog.getCheckBoxValue()) {
                DrJava.getConfig().setSetting(OptionConstants.WARN_CHANGE_INTERACTIONS, Boolean.FALSE);
            }
        }
    }

    public static class RequiresDrJavaRestartListener<T>
    implements OptionListener<T> {
        protected JFrame _parent;
        protected String _description;

        public RequiresDrJavaRestartListener(JFrame parent, String description) {
            this._parent = parent;
            this._description = description;
        }

        @Override
        public void optionChanged(OptionEvent<T> oe) {
            ConfirmCheckBoxDialog dialog;
            String title = "Apply Preference Changes";
            String msg = "Changes to the '" + this._description + "' preferences\nwill only take effect when you restart DrJava.";
            if (DrJava.getConfig().getSetting(OptionConstants.WARN_CHANGE_MISC).booleanValue() && (dialog = new ConfirmCheckBoxDialog(this._parent, title, msg, "Do not show this message again", 1, -1)).show() == 0 && dialog.getCheckBoxValue()) {
                DrJava.getConfig().setSetting(OptionConstants.WARN_CHANGE_MISC, Boolean.FALSE);
            }
        }
    }

    public static class PlasticThemeListener
    implements OptionListener<String> {
        protected JFrame _parent;

        public PlasticThemeListener(JFrame parent) {
            this._parent = parent;
        }

        @Override
        public void optionChanged(OptionEvent<String> oe) {
            ConfirmCheckBoxDialog dialog;
            String title = "Apply Theme";
            String msg = "Changes to the theme will take effect when you restart DrJava.";
            if (DrJava.getConfig().getSetting(OptionConstants.WARN_CHANGE_THEME).booleanValue() && (dialog = new ConfirmCheckBoxDialog(this._parent, title, msg, "Do not show this message again", 1, -1)).show() == 0 && dialog.getCheckBoxValue()) {
                DrJava.getConfig().setSetting(OptionConstants.WARN_CHANGE_THEME, Boolean.FALSE);
            }
        }
    }

    public static class LookAndFeelListener
    implements OptionListener<String> {
        protected JFrame _parent;

        public LookAndFeelListener(JFrame parent) {
            this._parent = parent;
        }

        @Override
        public void optionChanged(OptionEvent<String> oe) {
            ConfirmCheckBoxDialog dialog;
            String title = "Apply Look and Feel";
            String msg = "Look and feel changes will take effect when you restart DrJava.";
            if (DrJava.getConfig().getSetting(OptionConstants.WARN_CHANGE_LAF).booleanValue() && (dialog = new ConfirmCheckBoxDialog(this._parent, title, msg, "Do not show this message again", 1, -1)).show() == 0 && dialog.getCheckBoxValue()) {
                DrJava.getConfig().setSetting(OptionConstants.WARN_CHANGE_LAF, Boolean.FALSE);
            }
        }
    }

    public static class JavadocCustomParamsListener
    implements OptionListener<String>,
    OptionConstants {
        protected JFrame _parent;

        public JavadocCustomParamsListener(JFrame parent) {
            this._parent = parent;
        }

        @Override
        public void optionChanged(OptionEvent<String> oe) {
            ConfigOptionListeners.sanitizeJavadocCustomParams(this._parent, (String)oe.value);
        }
    }

    public static class MasterJVMXMXListener
    implements OptionListener<String>,
    OptionConstants {
        protected JFrame _parent;

        public MasterJVMXMXListener(JFrame parent) {
            this._parent = parent;
        }

        @Override
        public void optionChanged(OptionEvent<String> oe) {
            DrJava.getConfig().removeOptionListener(MASTER_JVM_XMX, this);
            ConfigOptionListeners.sanitizeMasterJVMXMX(this._parent, (String)oe.value);
            JOptionPane.showMessageDialog(this._parent, "You will have to restart DrJava before the change takes effect.");
            DrJava.getConfig().addOptionListener(MASTER_JVM_XMX, this);
        }
    }

    public static class MasterJVMArgsListener
    implements OptionListener<String>,
    OptionConstants {
        protected JFrame _parent;

        public MasterJVMArgsListener(JFrame parent) {
            this._parent = parent;
        }

        @Override
        public void optionChanged(OptionEvent<String> oe) {
            DrJava.getConfig().removeOptionListener(MASTER_JVM_ARGS, this);
            if (!((String)oe.value).equals("")) {
                int result = JOptionPane.showConfirmDialog(this._parent, "Specifying Main JVM Args is an advanced option. Invalid arguments may cause\nDrJava to fail on start up.  You may need to edit or delete your .drjava preferences file\nto recover.\n Are you sure you want to set this option?\n(You will have to restart Drjava before changes take effect.)", "Confirm Main JVM Arguments", 0);
                if (result != 0) {
                    DrJava.getConfig().setSetting(oe.option, "");
                } else {
                    ConfigOptionListeners.sanitizeMasterJVMArgs(this._parent, (String)oe.value, this);
                }
            }
            DrJava.getConfig().addOptionListener(MASTER_JVM_ARGS, this);
        }
    }

    public static class SlaveJVMXMXListener
    implements OptionListener<String>,
    OptionConstants {
        protected JFrame _parent;

        public SlaveJVMXMXListener(JFrame parent) {
            this._parent = parent;
        }

        @Override
        public void optionChanged(OptionEvent<String> oe) {
            DrJava.getConfig().removeOptionListener(SLAVE_JVM_XMX, this);
            ConfigOptionListeners.sanitizeSlaveJVMXMX(this._parent, (String)oe.value);
            DrJava.getConfig().addOptionListener(SLAVE_JVM_XMX, this);
            JOptionPane.showMessageDialog(this._parent, "You will have to reset the interactions pane before changes take effect.");
        }
    }

    public static class SlaveJVMArgsListener
    implements OptionListener<String>,
    OptionConstants {
        protected JFrame _parent;

        public SlaveJVMArgsListener(JFrame parent) {
            this._parent = parent;
        }

        @Override
        public void optionChanged(OptionEvent<String> oe) {
            DrJava.getConfig().removeOptionListener(SLAVE_JVM_ARGS, this);
            if (!((String)oe.value).equals("")) {
                int result = JOptionPane.showConfirmDialog(this._parent, "Specifying Interations JVM Args is an advanced option. Invalid arguments may cause\nthe Interactions Pane to stop working.\nAre you sure you want to set this option?\n(You will have to reset the interactions pane before changes take effect.)", "Confirm Interactions JVM Arguments", 0);
                if (result != 0) {
                    DrJava.getConfig().setSetting(oe.option, "");
                } else {
                    ConfigOptionListeners.sanitizeSlaveJVMArgs(this._parent, (String)oe.value, this);
                }
            }
            DrJava.getConfig().addOptionListener(SLAVE_JVM_ARGS, this);
        }
    }

    public static class DisplayAllCompilerVersionsListener
    implements OptionListener<Boolean>,
    OptionConstants {
        protected JFrame _parent;

        public DisplayAllCompilerVersionsListener(JFrame parent) {
            this._parent = parent;
        }

        @Override
        public void optionChanged(OptionEvent<Boolean> oe) {
            JOptionPane.showMessageDialog(this._parent, "You will have to restart DrJava before the change takes effect.");
        }
    }
}

