/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.android;

import com.github.javaparser.Range;
import com.github.javaparser.StaticJavaParser;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.stmt.BlockStmt;
import edu.rice.cs.drjava.android.CS1AppUtils;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.swing.JOptionPane;

public class LogValidator {
    private static HashMap<String, int[]> methodRanges;
    private static String selectedText;
    private static String selectedMethod;

    private static String unescapeText(String escapedText) {
        return escapedText.replace("\\c", ":").replace("\\n", "\n").replace("\\r", "\r").replace("\\\\", "\\");
    }

    private static LogOperation parseLogLine(String line) {
        if (line == null || line.trim().isEmpty() || line.startsWith("#") || line.startsWith("SESSION_START")) {
            return null;
        }
        Pattern logEntryPattern = Pattern.compile("^([+-]?\\d+):([ID]):(.*)$");
        Matcher matcher = logEntryPattern.matcher(line);
        if (!matcher.matches()) {
            return null;
        }
        String sessionId = "SessionID";
        long timeOffset = Long.parseLong(matcher.group(1));
        String operation = matcher.group(2);
        String remainder = matcher.group(3);
        int colonIndex = remainder.indexOf(":");
        if (colonIndex == -1) {
            return null;
        }
        int position = Integer.parseInt(remainder.substring(0, colonIndex));
        String content = remainder.substring(colonIndex + 1);
        if ("I".equals(operation)) {
            String unescapedText = LogValidator.unescapeText(content);
            return new LogOperation("I", position, unescapedText, timeOffset, sessionId);
        }
        if ("D".equals(operation)) {
            return new LogOperation("D", position, content, timeOffset, sessionId);
        }
        return null;
    }

    private static List<LogOperation> readLogFile(File logFile) throws IOException {
        ArrayList<LogOperation> operations = new ArrayList<LogOperation>();
        try (BufferedReader reader = new BufferedReader(new FileReader(logFile));){
            String line;
            while ((line = reader.readLine()) != null) {
                LogOperation op = LogValidator.parseLogLine(line);
                if (op == null) continue;
                operations.add(op);
            }
        }
        return operations;
    }

    private static String reconstructContent(List<LogOperation> operations) {
        StringBuilder content = new StringBuilder();
        for (LogOperation op : operations) {
            if ("I".equals(op.type)) {
                if (op.offset <= content.length()) {
                    content.insert(op.offset, op.content);
                    continue;
                }
                System.err.println("Warning: Insert offset " + op.offset + " beyond content length " + content.length() + ". Appending to end.");
                content.append(op.content);
                continue;
            }
            if (!"D".equals(op.type)) continue;
            int deleteLength = Integer.parseInt(op.content);
            int endOffset = Math.min(op.offset + deleteLength, content.length());
            if (op.offset < content.length()) {
                content.delete(op.offset, endOffset);
                continue;
            }
            System.err.println("Warning: Delete offset " + op.offset + " beyond content length " + content.length() + ". Ignoring delete operation.");
        }
        return content.toString();
    }

    public static String getClipboardValidJavaCode() {
        try {
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            Transferable contents = clipboard.getContents(null);
            if (contents == null || !contents.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                return null;
            }
            String clipboardText = (String)contents.getTransferData(DataFlavor.stringFlavor);
            if (LogValidator.isValidJavaCode(clipboardText)) {
                return clipboardText;
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static boolean isValidJavaCode(String code) {
        if (code == null) {
            return false;
        }
        long semicols = code.chars().filter(ch -> ch == 59).count();
        if (semicols > 4L) {
            return false;
        }
        if ((code = code.replaceAll("//.*(\r?\n|$)", "")).indexOf(32) == -1) {
            return false;
        }
        try {
            Object expr = StaticJavaParser.parseExpression(code.replaceAll(";", ""));
            if (((Expression)expr).isIntegerLiteralExpr() || ((Expression)expr).isDoubleLiteralExpr() || ((Expression)expr).isLongLiteralExpr() || ((Expression)expr).isBooleanLiteralExpr() || ((Expression)expr).isCharLiteralExpr() || ((Expression)expr).isStringLiteralExpr() || ((Expression)expr).isNullLiteralExpr() || ((Expression)expr).isNameExpr()) {
                return false;
            }
        }
        catch (Exception expr) {
            // empty catch block
        }
        try {
            BlockStmt block = StaticJavaParser.parseBlock("{" + code + "}");
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean hasMainMethod(File javaFile) {
        return LogValidator.hasMethod(javaFile, "public static", "void", "main", "String[]");
    }

    public static boolean hasRunMethod(File javaFile) {
        return LogValidator.hasMethod(javaFile, "public", "void", "run", new String[0]);
    }

    public static int[] getMainRange(File javaFile) {
        return LogValidator.getMethodRange(javaFile, "public static", "void", "main", "String[]");
    }

    public static int[] getMainRange(String javaCode) {
        return LogValidator.getMethodRange(javaCode, "public static", "void", "main", "String[]");
    }

    public static int[] getRunRange(File javaFile) {
        return LogValidator.getMethodRange(javaFile, "public", "void", "run", new String[0]);
    }

    public static int[] getRunRange(String javaCode) {
        return LogValidator.getMethodRange(javaCode, "public", "void", "run", new String[0]);
    }

    public static boolean hasMethod(File javaFile, String isPublic, String isStatic, String methodName, String ... paramTypes) {
        return null != LogValidator.getMethodRange(javaFile, isPublic, isStatic, methodName, paramTypes);
    }

    public static int[] getMethodRange(File javaFile, String isPublicStatic, String returnType, String methodName, String ... paramTypes) {
        String className = javaFile.getName().replaceFirst(".java$", "");
        try {
            FileInputStream stream = new FileInputStream(javaFile);
            return LogValidator.getMethodRange(stream, isPublicStatic, returnType, methodName, paramTypes);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static int[] getMethodRange(String javaCode, String isPublicStatic, String returnType, String methodName, String ... paramTypes) {
        ByteArrayInputStream stream = new ByteArrayInputStream(javaCode.getBytes(StandardCharsets.UTF_8));
        return LogValidator.getMethodRange(stream, isPublicStatic, returnType, methodName, paramTypes);
    }

    public static int[] getMethodRange(InputStream stream, String isPublicStatic, String returnType, String methodName, String ... paramTypes) {
        CompilationUnit cu = null;
        try {
            cu = StaticJavaParser.parse(stream);
            stream.close();
        }
        catch (Exception e) {
            return null;
        }
        Optional<ClassOrInterfaceDeclaration> myClass = cu.getTypes().stream().filter(type -> type.isClassOrInterfaceDeclaration()).map(type -> (ClassOrInterfaceDeclaration)type).findFirst();
        if (!myClass.isPresent()) {
            return null;
        }
        Optional<MethodDeclaration> classMethod = myClass.get().getMethods().stream().filter(method -> {
            if (!method.getNameAsString().equals(methodName) || isPublicStatic.startsWith("public") != method.isPublic() || isPublicStatic.endsWith("static") != method.isStatic() || !method.getTypeAsString().equals(returnType)) {
                return false;
            }
            List currParamTypes = method.getParameters().stream().map(p -> p.getTypeAsString()).collect(Collectors.toList());
            return Arrays.asList(paramTypes).equals(currParamTypes);
        }).findFirst();
        if (!classMethod.isPresent()) {
            return null;
        }
        Optional<Range> range = classMethod.get().getRange();
        if (!range.isPresent()) {
            return null;
        }
        int beginLine = range.get().begin.line;
        int beginColumn = range.get().begin.column;
        int endLine = range.get().end.line;
        int endColumn = range.get().end.column;
        return new int[]{beginLine, beginColumn, endLine, endColumn};
    }

    public static void parseAllMethodRanges(File javaFile) {
        try {
            FileInputStream stream = new FileInputStream(javaFile);
            LogValidator.parseAllMethodRanges(stream);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void parseAllMethodRanges(String javaCode) {
        ByteArrayInputStream stream = new ByteArrayInputStream(javaCode.getBytes(StandardCharsets.UTF_8));
        LogValidator.parseAllMethodRanges(stream);
    }

    public static void parseAllMethodRanges(InputStream stream) {
        methodRanges = null;
        CompilationUnit cu = null;
        try {
            cu = StaticJavaParser.parse(stream);
            stream.close();
        }
        catch (Exception e) {
            return;
        }
        Optional<ClassOrInterfaceDeclaration> myClass = cu.getTypes().stream().filter(type -> type.isClassOrInterfaceDeclaration()).map(type -> (ClassOrInterfaceDeclaration)type).findFirst();
        if (!myClass.isPresent()) {
            return;
        }
        methodRanges = new HashMap();
        myClass.get().getMethods().stream().forEach(method -> {
            Optional<Range> range = method.getRange();
            if (!range.isPresent()) {
                return;
            }
            int beginLine = range.get().begin.line;
            int beginColumn = range.get().begin.column;
            int endLine = range.get().end.line;
            int endColumn = range.get().end.column;
            String decl = method.getDeclarationAsString(true, true, true);
            methodRanges.put(decl, new int[]{beginLine, beginColumn, endLine, endColumn});
        });
    }

    public static void clearPaste() {
        methodRanges = null;
        selectedText = null;
        selectedMethod = null;
    }

    public static void copySelection(String text, int beginLine, int beginCol, int endLine, int endCol) {
        if (text.trim().isEmpty()) {
            return;
        }
        selectedText = null;
        selectedMethod = null;
        if (methodRanges == null) {
            return;
        }
        for (String decl : methodRanges.keySet()) {
            int[] range = methodRanges.get(decl);
            if (range[0] + 1 >= beginLine || endLine >= range[2]) continue;
            selectedText = text;
            selectedMethod = decl;
            try {
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                clipboard.setContents(new StringSelection(selectedText), null);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return;
        }
    }

    public static boolean isPasteAllowed(String javaCode, int pasteLine, int pasteCol) {
        if (selectedText != null && !LogValidator.isValidJavaCode(selectedText)) {
            LogValidator.showPasteRestrictedDialog();
            return false;
        }
        if (methodRanges == null) {
            JOptionPane.showMessageDialog(null, "Before cut/copy to paste ensure there are no errors (use Run button).", "Paste Restricted", 2);
            return false;
        }
        LogValidator.parseAllMethodRanges(javaCode);
        String decl = null;
        for (String d : methodRanges.keySet()) {
            int[] range = methodRanges.get(d);
            if (range[0] + 1 >= pasteLine || pasteLine >= range[2]) continue;
            decl = d;
            break;
        }
        if (decl == null) {
            LogValidator.showPasteRestrictedDialog();
            return false;
        }
        if (selectedText != null && decl.equals(selectedMethod)) {
            return true;
        }
        if (decl.equals("public void run()") || decl.equals("public static void main(String[] args)")) {
            String str = LogValidator.getClipboardValidJavaCode();
            if (str == null) {
                LogValidator.showPasteRestrictedDialog();
                return false;
            }
            String message = "<html>Check the paste details below and select if you wish to continue:<br><br><b>method:</b> " + decl + "<br><br><b>text:</b><pre>" + str;
            int result = JOptionPane.showConfirmDialog(null, message, "Paste Attempted", 0, 3);
            return result == 0;
        }
        LogValidator.showPasteRestrictedDialog();
        return false;
    }

    private static void showPasteRestrictedDialog() {
        String message = "<html><b>Paste Restricted</b><br><br>Note: Pasting has to be done immediately after cut/copy.<br><br>&nbsp;&nbsp;\u2022 the pasted text must be valid Java code<br><br>&nbsp;&nbsp;\u2022 no more than 4 Java lines (i.e. no more than 4 ; ending lines)<br><br>Note: Pasting is only allowed inside the following methods:<br><br>&nbsp;&nbsp;\u2022 the method from which text was copied<br><br>&nbsp;&nbsp;\u2022 <font face='monospace' color='#0000FF'>public</font> <font face='monospace' color='#800080'>static void</font> <font face='monospace'>main</font>(...)<br><br>&nbsp;&nbsp;\u2022 <font face='monospace' color='#0000FF'>public</font> <font face='monospace' color='#800080'>void</font> <font face='monospace'>run</font>()<br><br>Please position your cursor inside one of these methods to paste code.</html>";
        JOptionPane.showMessageDialog(null, message, "Paste Restricted", 2);
    }

    public static boolean ignoreLogging() {
        return CS1AppUtils.appName.toLowerCase().startsWith("smiley") || CS1AppUtils.appName.toLowerCase().startsWith("mypet") || CS1AppUtils.appName.toLowerCase().startsWith("pacman") || CS1AppUtils.appName.toLowerCase().startsWith("math") || CS1AppUtils.appName.toLowerCase().startsWith("calc");
    }

    public static ValidationResult validateDocument(File javaFile) {
        if (!javaFile.getParentFile().getName().equals(CS1AppUtils.appName)) {
            return new ValidationResult(true, "Skipped log validation since file not in curren project:\nFile: " + javaFile.getAbsolutePath() + "\nProject: " + CS1AppUtils.appName, "", "");
        }
        if (LogValidator.ignoreLogging()) {
            return new ValidationResult(true, "Skipped log validation for old projects:\nFile: " + javaFile.getAbsolutePath() + "\nProject: " + CS1AppUtils.appName, "", "");
        }
        String currentContent = null;
        try {
            currentContent = new String(Files.readAllBytes(javaFile.toPath()));
        }
        catch (IOException e) {
            return new ValidationResult(false, "Could not read file: " + javaFile.getAbsolutePath(), null, "");
        }
        try {
            File logFile = new File(javaFile.getAbsolutePath().replaceFirst("\\.java$", ".log"));
            if (!logFile.exists()) {
                return new ValidationResult(false, "Log file not found: " + logFile.getAbsolutePath(), null, "");
            }
            List<LogOperation> operations = LogValidator.readLogFile(logFile);
            String reconstructedContent = LogValidator.reconstructContent(operations);
            boolean matches = reconstructedContent.equals(currentContent);
            if (matches) {
                String message = "Document content matches reconstructed logs (" + operations.size() + " operations)";
                return new ValidationResult(matches, message, "", "");
            }
            int count = CS1AppUtils.appLibPath.listFiles().length;
            File javaFileCopy = new File(CS1AppUtils.appLibPath, javaFile.getName() + "." + count);
            File logFileCopy = new File(CS1AppUtils.appLibPath, logFile.getName() + "." + count);
            try {
                Files.move(javaFile.toPath(), javaFileCopy.toPath(), StandardCopyOption.ATOMIC_MOVE);
            }
            catch (IOException e) {
                return new ValidationResult(false, "Could not make back up of Java file: " + javaFile.getAbsolutePath(), "", "");
            }
            try {
                Files.copy(logFile.toPath(), logFileCopy.toPath(), StandardCopyOption.COPY_ATTRIBUTES);
            }
            catch (IOException e) {
                return new ValidationResult(false, "Could not make back up of Log file: " + logFile.getAbsolutePath(), "", "");
            }
            Files.write(javaFile.toPath(), reconstructedContent.getBytes(), new OpenOption[0]);
            String message = String.format("Document content does NOT match reconstructed logs!\n\nReplacing content with reconstructed log!\n\nLog file: %s\n", logFile.getAbsolutePath());
            return new ValidationResult(matches, message, "", "");
        }
        catch (IOException e) {
            return new ValidationResult(false, "Error reading log file: " + e.getMessage(), null, "");
        }
        catch (Exception e) {
            return new ValidationResult(false, "Unexpected error during validation: " + e.getMessage(), null, "");
        }
    }

    private static class LogOperation {
        public final String type;
        public final int offset;
        public final String content;
        public final long timeOffset;
        public final String sessionId;

        public LogOperation(String type, int offset, String content, long timeOffset, String sessionId) {
            this.type = type;
            this.offset = offset;
            this.content = content;
            this.timeOffset = timeOffset;
            this.sessionId = sessionId;
        }

        public String toString() {
            return String.format("LogOperation{type='%s', offset=%d, content='%s', timeOffset=%d, sessionId='%s'}", this.type, this.offset, this.content, this.timeOffset, this.sessionId);
        }
    }

    public static class ValidationResult {
        public final boolean isValid;
        public final String message;
        public final String reconstructedContent;
        public final String currentContent;

        public ValidationResult(boolean isValid, String message, String reconstructedContent, String currentContent) {
            this.isValid = isValid;
            this.message = message;
            this.reconstructedContent = reconstructedContent;
            this.currentContent = currentContent;
        }

        public String getDetailedComparison() {
            if (this.isValid || this.reconstructedContent == null) {
                return this.message;
            }
            StringBuilder sb = new StringBuilder();
            sb.append(this.message).append("\n\n");
            int minLength = Math.min(this.reconstructedContent.length(), this.currentContent.length());
            int firstDiff = -1;
            for (int i = 0; i < minLength; ++i) {
                if (this.reconstructedContent.charAt(i) == this.currentContent.charAt(i)) continue;
                firstDiff = i;
                break;
            }
            if (firstDiff >= 0) {
                sb.append("First difference at position ").append(firstDiff).append(":\n");
                int start = Math.max(0, firstDiff - 20);
                int endReconstructed = Math.min(this.reconstructedContent.length(), firstDiff + 20);
                int endCurrent = Math.min(this.currentContent.length(), firstDiff + 20);
                sb.append("Reconstructed: \"").append(this.reconstructedContent.substring(start, endReconstructed).replace("\n", "\\n")).append("\"\n");
                sb.append("Current:       \"").append(this.currentContent.substring(start, endCurrent).replace("\n", "\\n")).append("\"\n");
            } else if (this.reconstructedContent.length() != this.currentContent.length()) {
                sb.append("Contents are identical up to position ").append(minLength).append(", but lengths differ.\n");
            }
            return sb.toString();
        }
    }
}

