/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.android;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Line {
    String trimmed;
    int indent;
    boolean isBlank;
    boolean isComment;
    boolean isClosingCurlyBrace;
    private static Pattern nonSpaceChar = Pattern.compile("\\S");

    public Line(String line) {
        this.trimmed = line.replaceAll(" ", "");
        this.indent = this.indentValue(line);
        if (this.indent == -1) {
            this.isBlank = true;
        } else if (this.isComment()) {
            this.isComment = true;
        } else if (this.trimmed.equals("}")) {
            this.isClosingCurlyBrace = true;
        }
    }

    private boolean isComment() {
        if (this.trimmed.startsWith("//")) {
            return true;
        }
        if (this.trimmed.startsWith("/*")) {
            return true;
        }
        if (this.trimmed.startsWith("*")) {
            return true;
        }
        return this.trimmed.endsWith("*/");
    }

    public boolean isNonVoidMethod() {
        return !this.isComment && this.indent == 4 && this.trimmed.endsWith(")") && !this.trimmed.contains("void");
    }

    private int indentValue(String line) {
        Matcher matcher = nonSpaceChar.matcher(line);
        if (matcher.find()) {
            return line.indexOf(matcher.group());
        }
        return -1;
    }
}

