/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.android;

import edu.rice.cs.drjava.android.CS1AppUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JOptionPane;

public class CheckStyleReader {
    public static final int ERROR_MSG_INDEX = 8;
    private static String CHECKSTYLE_PATH = null;
    private static String STYLE_RULES_PATH = null;
    private static String JAVA_PATH = null;

    public static boolean init() {
        CHECKSTYLE_PATH = CheckStyleReader.loadResource("checkstyle-10.12.3-all.jar");
        STYLE_RULES_PATH = CheckStyleReader.loadResource("CS1App.xml");
        String path = System.getenv("CS1APP_JAVA_HOME");
        if (path == null) {
            JOptionPane.showMessageDialog(null, "Could not find java home.", "StyleChecker Error", 0);
        } else {
            JAVA_PATH = Paths.get(path, "bin", "java").toString();
        }
        return true;
    }

    public static String loadResource(String filename) {
        Path target;
        String root = System.getenv("CS1APP_ROOT");
        if (root == null) {
            JOptionPane.showMessageDialog(null, "Could not find root folder for style files.", "StyleChecker Error", 0);
        }
        if (!(target = Paths.get(root, "drjava/lib", filename)).toFile().getParentFile().canWrite()) {
            return target.toString();
        }
        if (target.startsWith("checkstyle") && target.toFile().exists()) {
            return target.toString();
        }
        if (target.startsWith("javaparser") && target.toFile().exists()) {
            return target.toString();
        }
        InputStream source = null;
        try {
            source = CheckStyleReader.class.getResourceAsStream(filename);
            Files.copy(source, target, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (Exception e) {
            String ext = filename.substring(filename.lastIndexOf("."));
            JOptionPane.showMessageDialog(null, "Could not load style file: " + ext, "StyleChecker Error", 0);
            return null;
        }
        return target.toString();
    }

    public static void main(String[] args) {
    }

    public static ArrayList<CS1AppUtils.StyleError> getCheckStyleErrors(File javaFile) {
        ArrayList<CS1AppUtils.StyleError> errors = new ArrayList<CS1AppUtils.StyleError>();
        if (!new File(CHECKSTYLE_PATH).exists()) {
            String errMsg = String.format("%s:1:1: Could not load style file .jar [StyleConfigErr]", javaFile.getAbsolutePath());
            CS1AppUtils.StyleError err = CS1AppUtils.StyleError.toStyleError(errMsg);
            errors.add(err);
            return errors;
        }
        if (!new File(STYLE_RULES_PATH).exists()) {
            String errMsg = String.format("%s:1:1: Could not load style file .xml [StyleConfigErr]", javaFile.getAbsolutePath());
            CS1AppUtils.StyleError err = CS1AppUtils.StyleError.toStyleError(errMsg);
            errors.add(err);
            return errors;
        }
        try {
            String line;
            ProcessBuilder processBuilder = new ProcessBuilder(JAVA_PATH, "-jar", CHECKSTYLE_PATH, "-c", STYLE_RULES_PATH, javaFile.getAbsolutePath());
            Process process = processBuilder.start();
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while ((line = reader.readLine()) != null) {
                if (!line.startsWith("[")) continue;
                line = line.substring(8);
                CS1AppUtils.StyleError err = CS1AppUtils.StyleError.toStyleError(line);
                errors.add(err);
            }
            process.waitFor();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "StyleChecker execution error", "StyleChecker Error", 0);
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            JOptionPane.showMessageDialog(null, sw.toString(), "StyleChecker execution error", 0);
        }
        return errors;
    }

    private static <T> void print(List<T> list) {
        for (T item : list) {
            System.out.println(item);
        }
    }
}

