/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.android;

import edu.rice.cs.drjava.DrJava;
import edu.rice.cs.drjava.android.CheckStyleReader;
import edu.rice.cs.drjava.android.ErrorLabel;
import edu.rice.cs.drjava.android.Line;
import edu.rice.cs.drjava.android.LogValidator;
import edu.rice.cs.drjava.config.OptionConstants;
import edu.rice.cs.drjava.model.AbstractGlobalModel;
import edu.rice.cs.drjava.model.DJError;
import edu.rice.cs.drjava.model.compiler.CompilerError;
import edu.rice.cs.drjava.model.definitions.ColoringView;
import edu.rice.cs.util.FileOpenSelector;
import edu.rice.cs.util.OperationCanceledException;
import java.awt.Color;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JTextPane;
import javax.swing.JToolBar;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.text.AttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;

public class CS1AppUtils {
    private static boolean initStyle = CheckStyleReader.init();
    private static String AVD_NAME = "CS1Phone";
    private static String EMU_PORT = "5554";
    private static String EMU_SERIAL;
    private static String DEVICE;
    private static boolean sdkFound;
    public static volatile boolean compilationSuccess;
    private static String CS1APP_JAR;
    private static String CS1APP_MAIN_SCRIPT;
    private static String CS1APP_USE_ANDROID;
    private static String CS1APP_ANDROID_JAR;
    public static File appRoot;
    public static File appSrcPath;
    public static File appLibPath;
    public static String appName;
    private static JComboBox<String> buttonGroup;
    private static AbstractGlobalModel _model;
    public static JTextPane _textArea;
    static final int INDENT_SPACES = 4;
    private static Process logcatProcess;
    private static Thread logcatThread;
    private static Thread runAppThread;
    private static Process runDeviceProcess;
    private static Pattern methodName;
    private static Pattern methodCall;
    private static Set<String> nonVoidMethods;

    public static boolean checkPaths() {
        boolean found = sdkFound;
        if (!sdkFound) {
            CS1AppUtils.printToConsole("cs1app: Could not find Android SDK", Color.DARK_GRAY);
        }
        if (!found) {
            return false;
        }
        return found;
    }

    private static boolean setupTools() {
        File cs1app8Jar;
        File toolsJar;
        if (Toolkit.getDefaultToolkit().getSystemSelection() != null) {
            Toolkit.getDefaultToolkit().addAWTEventListener(event -> {
                if (event.getID() == 500 && ((MouseEvent)event).getButton() == 2) {
                    Toolkit.getDefaultToolkit().getSystemSelection().setContents(new StringSelection(""), null);
                }
            }, 16L);
        }
        CS1APP_JAR = System.getenv("CS1APP_JAR");
        CS1APP_MAIN_SCRIPT = System.getenv("CS1APP_MAIN_SCRIPT");
        CS1APP_USE_ANDROID = System.getenv("CS1APP_USE_ANDROID");
        CS1APP_ANDROID_JAR = System.getenv("CS1APP_ANDROID_JAR");
        if (CS1APP_MAIN_SCRIPT == null) {
            JOptionPane.showMessageDialog(null, "Could not find the main script. Ensure CS1APP_MAIN_SCRIPT is set.", "Main Script Not Found", 0);
        }
        if (!(toolsJar = DrJava.getConfig().getSetting(OptionConstants.JAVAC_LOCATION)).exists()) {
            String toolsJarPath = System.getenv("CS1APP_JAVA_HOME").replaceFirst("java$", CS1AppUtils.normPath("java8/lib/tools.jar"));
            DrJava.getConfig().setSetting(OptionConstants.JAVAC_LOCATION, new File(toolsJarPath));
        }
        Vector extraPaths = (Vector)((Object)DrJava.getConfig().getSetting(OptionConstants.EXTRA_CLASSPATH));
        boolean cs1appFound = false;
        for (File f : extraPaths) {
            if (!f.getName().equals("cs1app-java8.jar")) continue;
            extraPaths.remove(f);
            break;
        }
        if ((cs1app8Jar = new File(CS1APP_JAR.replace("java11", "java8"))).exists()) {
            extraPaths.add(cs1app8Jar);
        } else {
            JOptionPane.showMessageDialog(null, "Could not find cs1app-java8.jar. Check Edit=>Preferences=>Classpath.", "cs1app.jar Not Found", 0);
        }
        if (CS1APP_USE_ANDROID != null) {
            boolean androidFound = false;
            for (File f : extraPaths) {
                if (!f.getName().equals("android.jar")) continue;
                androidFound = true;
                break;
            }
            if (!androidFound) {
                JOptionPane.showMessageDialog(null, "Could not find android.jar. Check Edit=>Preferences=>Classpath.", "android.jar Not Found", 0);
            }
        }
        DrJava.getConfig().setSetting(OptionConstants.EXTRA_CLASSPATH, extraPaths);
        DrJava.getConfig().setSetting(OptionConstants.INDENT_LEVEL, 4);
        DrJava.getConfig().setSetting(OptionConstants.LANGUAGE_LEVEL, 5);
        return true;
    }

    private static String parseInput(InputStream is, String regex) {
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                if (!line.matches(regex)) continue;
                return line;
            }
        }
        catch (Exception e) {
            CS1AppUtils.printToConsole(e);
        }
        return null;
    }

    public static void beginLogcatToInteractionsPane() {
        if (logcatThread == null || !logcatThread.isAlive()) {
            logcatThread = new Thread(){

                private void startLogcat() {
                    try {
                        Process clearLogcat = new ProcessBuilder(CS1APP_MAIN_SCRIPT, "logcat", "-b all -c").start();
                        clearLogcat.waitFor();
                        logcatProcess = new ProcessBuilder(CS1APP_MAIN_SCRIPT, "logcat").start();
                    }
                    catch (IOException e) {
                        CS1AppUtils.printToConsole(e);
                    }
                    catch (InterruptedException e) {
                        CS1AppUtils.printToConsole(e);
                    }
                    InputStream is = logcatProcess.getInputStream();
                    InputStream errStream = logcatProcess.getErrorStream();
                    this.parseLogcat(is, errStream);
                }

                private void parseLogcat(InputStream output, InputStream error) {
                    CS1AppUtils.printStdOut("\n.............................................................\n");
                    BufferedReader reader = new BufferedReader(new InputStreamReader(output));
                    try {
                        String line;
                        while ((line = reader.readLine()) != null) {
                            if (line.contains("System.out")) {
                                line = line.replaceAll("^.*System", "System");
                                CS1AppUtils.printStdOut(line);
                                continue;
                            }
                            if (!line.contains("System.err") || !line.contains("Exception") && !line.contains("cs1.")) continue;
                            line = line.replaceAll("^.*System", "System");
                            CS1AppUtils.printStdErr(line);
                        }
                    }
                    catch (Exception e) {
                        CS1AppUtils.printToConsole(e);
                        this.startLogcat();
                    }
                }

                @Override
                public void run() {
                    this.startLogcat();
                }
            };
            logcatThread.start();
        }
    }

    public static void printToConsole(Exception e) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        e.printStackTrace(pw);
        CS1AppUtils.printToConsole(sw.toString(), Color.DARK_GRAY);
    }

    public static void printToConsole(String line) {
        CS1AppUtils.printToConsole(line, Color.DARK_GRAY);
    }

    public static void printToConsole(String line, Color c) {
        CS1AppUtils.appendToPane(line + "\n", c);
    }

    public static void printCS1AppErr(String line) {
        CS1AppUtils.appendToPane("cs1app: " + line + "\n", Color.DARK_GRAY);
    }

    public static void printStdOut(String line) {
        CS1AppUtils.appendToPane(line + "\n", ColoringView.INTERACTIONS_SYSTEM_OUT_COLOR);
    }

    public static void printStdErr(String line) {
        CS1AppUtils.appendToPane(line + "\n", ColoringView.INTERACTIONS_SYSTEM_ERR_COLOR);
    }

    private static void appendToPane(String msg, Color c) {
        StyleContext sc = StyleContext.getDefaultStyleContext();
        AttributeSet aset = sc.addAttribute(SimpleAttributeSet.EMPTY, StyleConstants.Foreground, c);
        aset = sc.addAttribute(aset, StyleConstants.FontFamily, "Courier");
        aset = sc.addAttribute(aset, StyleConstants.Alignment, 3);
        int len = _textArea.getDocument().getLength();
        _textArea.setCaretPosition(len);
        _textArea.setCharacterAttributes(aset, false);
        _textArea.replaceSelection(msg);
    }

    private static void logOutput(final InputStream stdOut, final InputStream stdErr) {
        new Thread(){

            @Override
            public void run() {
                BufferedReader reader = new BufferedReader(new InputStreamReader(stdErr));
                try {
                    String line;
                    while ((line = reader.readLine()) != null) {
                        if (line.contains("scripts") && line.contains("Killed")) continue;
                        CS1AppUtils.printStdErr(line);
                    }
                    reader.close();
                }
                catch (Exception e) {
                    CS1AppUtils.printToConsole(e);
                }
            }
        }.start();
        new Thread(){

            @Override
            public void run() {
                BufferedReader reader = new BufferedReader(new InputStreamReader(stdOut));
                try {
                    String line;
                    while ((line = reader.readLine()) != null) {
                        if (line.startsWith("PID")) {
                            String pid = line.replaceFirst("PID ", "");
                            CS1AppUtils.killPhoneApp(pid);
                            continue;
                        }
                        CS1AppUtils.printStdOut(line);
                    }
                    reader.close();
                }
                catch (Exception e) {
                    CS1AppUtils.printToConsole(e);
                }
            }
        }.start();
    }

    public static void killPhoneApp(String pid) {
        try {
            Process killProc = new ProcessBuilder(CS1APP_MAIN_SCRIPT, "killApp", pid).start();
            killProc.waitFor();
        }
        catch (Exception e) {
            CS1AppUtils.printToConsole(e);
            CS1AppUtils.printToConsole(e.getMessage(), Color.DARK_GRAY);
        }
    }

    private static void initializeDevice(InputStream is) {
        String[] info;
        String status;
        DEVICE = EMU_SERIAL;
        String line = CS1AppUtils.parseInput(is, "^(?!emulator).*\t+.+");
        if (line != null && (status = (info = line.split("[\t]+"))[1]).equals("device")) {
            DEVICE = info[0];
            CS1AppUtils.printToConsole("Found device " + DEVICE, Color.DARK_GRAY);
        }
    }

    private static String deviceStatus(InputStream is) {
        String line = CS1AppUtils.parseInput(is, DEVICE + ".*");
        if (line != null) {
            String[] info = line.split("[\t]+");
            String status = info[1];
            return status;
        }
        return "";
    }

    public static void runDevice() {
        if (runDeviceProcess != null) {
            try {
                runDeviceProcess.exitValue();
            }
            catch (IllegalThreadStateException e) {
                CS1AppUtils.printStdErr(e.getMessage());
                return;
            }
        }
        boolean connected = false;
        try {
            Process proc;
            if (!connected) {
                proc = new ProcessBuilder(CS1APP_MAIN_SCRIPT, "adbDevices").start();
                CS1AppUtils.initializeDevice(proc.getInputStream());
                proc.waitFor();
                if (DEVICE.startsWith("emulator")) {
                    proc = new ProcessBuilder(CS1APP_MAIN_SCRIPT, "adbDevices").start();
                    String line = CS1AppUtils.parseInput(proc.getInputStream(), DEVICE + ".*");
                    proc.waitFor();
                    if (line == null) {
                        runDeviceProcess = new ProcessBuilder(CS1APP_MAIN_SCRIPT, "runEmulator").start();
                        CS1AppUtils.printToConsole("\nStarted " + DEVICE, Color.DARK_GRAY);
                        CS1AppUtils.printToConsole("Waiting for device ...", Color.DARK_GRAY);
                    }
                }
                connected = true;
            }
            Thread.sleep(2000L);
            proc = new ProcessBuilder(CS1APP_MAIN_SCRIPT, "adbDevices").start();
            String status = CS1AppUtils.deviceStatus(proc.getInputStream());
            proc.waitFor();
            if (status.equals("device")) {
                CS1AppUtils.printToConsole("\nDevice " + DEVICE + " is ready", Color.DARK_GRAY);
                return;
            }
            if (status.equals("")) {
                connected = false;
            }
        }
        catch (Exception e) {
            CS1AppUtils.printToConsole(e);
        }
    }

    public static void runEmulatorAndLogcat(AbstractGlobalModel model) {
        _model = model;
        if (CS1APP_USE_ANDROID == null) {
            return;
        }
        new Thread(){

            @Override
            public void run() {
                CS1AppUtils.runDevice();
            }
        }.start();
        new Thread(){

            @Override
            public void run() {
                CS1AppUtils.beginLogcatToInteractionsPane();
            }
        }.start();
    }

    public static FileOpenSelector _newClass() {
        String className;
        if (CS1AppUtils.isDrJavaRunning()) {
            return null;
        }
        if (appName == null) {
            JOptionPane.showMessageDialog(null, "Create a new project or open an existing one before creating a new class.", "New Class Error", 0);
            return null;
        }
        String fileName = JOptionPane.showInputDialog(null, "Enter the class name", "Create Class", 3);
        if (fileName == null) {
            return null;
        }
        String string = className = fileName.endsWith(".java") ? fileName.substring(0, fileName.lastIndexOf(".")) : fileName;
        if (!CS1AppUtils.isValidClassName(className)) {
            return null;
        }
        if (!fileName.endsWith(".java")) {
            fileName = fileName + ".java";
        }
        try {
            Process proc = new ProcessBuilder(CS1APP_MAIN_SCRIPT, "addClass", appName, className).directory(appRoot).start();
            CS1AppUtils.logOutput(proc.getInputStream(), proc.getErrorStream());
            proc.waitFor();
            File newFile = new File(appSrcPath, fileName);
            return CS1AppUtils.getFileOpenSelector(newFile);
        }
        catch (Exception e) {
            CS1AppUtils.printToConsole(e);
            return null;
        }
    }

    public static boolean isDrJavaRunning() {
        return false;
    }

    public static void runApp(File activeFile) {
        if (CS1APP_USE_ANDROID != null) {
            CS1AppUtils.runAppAndroid(activeFile);
        } else {
            CS1AppUtils.runAppJava(activeFile);
        }
    }

    public static void runAppJava(File activeFile) {
        String activeFileAppName = activeFile.getParentFile().getName();
        if (!activeFileAppName.equals(appName)) {
            JOptionPane.showMessageDialog(null, "File " + activeFile.getName() + " is not part of the main project " + appName + "\nand cannot be run. Switch to a file from the main project.", "Non-project File", 2);
            return;
        }
        runAppThread = new Thread(){

            @Override
            public void run() {
                try {
                    Process proc = new ProcessBuilder(CS1APP_MAIN_SCRIPT, "runApp", appName, DEVICE).directory(appRoot).start();
                    _textArea.setText("");
                    CS1AppUtils.logOutput(proc.getInputStream(), proc.getErrorStream());
                    proc.waitFor();
                }
                catch (Exception e) {
                    CS1AppUtils.printToConsole(e);
                }
            }
        };
        runAppThread.start();
    }

    public static void runAppAndroid(File activeFile) {
        if (runAppThread == null || !runAppThread.isAlive()) {
            runAppThread = new Thread(){

                @Override
                public void run() {
                    _textArea.setText("");
                    CS1AppUtils.printStdOut("Installing app, looking for device...");
                    CS1AppUtils.runDevice();
                    try {
                        CS1AppUtils.printToConsole("Installing on device " + DEVICE, Color.DARK_GRAY);
                        CS1AppUtils.printToConsole("Project folder: " + appRoot, Color.DARK_GRAY);
                        CS1AppUtils.printToConsole("Project name: " + appName, Color.DARK_GRAY);
                        Process runProc = new ProcessBuilder(CS1APP_MAIN_SCRIPT, "runApp", appName, DEVICE).directory(appRoot).start();
                        CS1AppUtils.logOutput(runProc.getInputStream(), runProc.getErrorStream());
                        while (true) {
                            try {
                                runProc.exitValue();
                                return;
                            }
                            catch (Exception exception) {
                                try {
                                    Thread.sleep(2000L);
                                    Process statusProc = new ProcessBuilder(CS1APP_MAIN_SCRIPT, "adbDevices").start();
                                    String status = CS1AppUtils.deviceStatus(statusProc.getInputStream());
                                    statusProc.waitFor();
                                    if (status.equals("device")) continue;
                                    runProc.destroy();
                                    CS1AppUtils.printStdOut("\n.............................................................\n");
                                    CS1AppUtils.printToConsole("Device disconnected, wait to restart\n", Color.DARK_GRAY);
                                    CS1AppUtils.runDevice();
                                    return;
                                }
                                catch (Exception e) {
                                    CS1AppUtils.printToConsole(e);
                                    continue;
                                }
                            }
                            break;
                        }
                    }
                    catch (Exception e) {
                        CS1AppUtils.printToConsole(e);
                        return;
                    }
                }
            };
            runAppThread.start();
        }
    }

    private static String normPath(String path) {
        return path.replace("/", File.separator);
    }

    public static boolean makeApp(File appRoot) {
        String appName = appRoot.getName();
        try {
            Process proc = new ProcessBuilder(CS1APP_MAIN_SCRIPT, "newApp", appName).directory(appRoot.getParentFile()).start();
            CS1AppUtils.logOutput(proc.getInputStream(), proc.getErrorStream());
            proc.waitFor();
            _textArea.setText("");
            return true;
        }
        catch (Exception e) {
            CS1AppUtils.printToConsole(e);
            return false;
        }
    }

    public static boolean isValidClassName(String className) {
        if (className.matches("[A-Z][a-zA-Z0-9]*")) {
            return true;
        }
        JOptionPane.showMessageDialog(null, "The app (or class) name should:\n- start with capital letter\n- contain only letters and numbers", "Invalid App Name", 2);
        return false;
    }

    public static boolean isValidProject(File appRoot) {
        String[] projFiles;
        if (appRoot == null) {
            return false;
        }
        String manifestFile = CS1APP_USE_ANDROID != null ? "AndroidManifest.xml" : "";
        for (String fileName : projFiles = new String[]{"bin", "lib", "res", "src", manifestFile}) {
            File filePath = new File(appRoot, fileName);
            if (fileName.isEmpty() || filePath.exists()) continue;
            JOptionPane.showMessageDialog(null, "Invalid project, missing: " + filePath);
            return false;
        }
        return true;
    }

    public static void main(String[] args) {
        if (args.length != 0) {
            if (args[0].equals("rundevice")) {
                CS1AppUtils.runDevice();
            } else if (args[0].equals("runapp")) {
                CS1AppUtils.runApp(new File("."));
            } else if (args[0].equals("makeapp")) {
                CS1AppUtils.makeApp(new File(args[1]));
            }
        }
    }

    public static FileOpenSelector getFileOpenSelector(final File ... files) {
        return new FileOpenSelector(){

            @Override
            public File[] getFiles() throws OperationCanceledException {
                return files;
            }
        };
    }

    public static FileOpenSelector openAndroidProject(File appRoot) {
        File[] javaFiles;
        if (appRoot == null) {
            return null;
        }
        File appFile = appRoot;
        boolean dirSelected = appRoot.isDirectory();
        if (!dirSelected) {
            try {
                appRoot = appRoot.getParentFile().getParentFile().getParentFile().getParentFile();
            }
            catch (Exception e) {
                appRoot = null;
            }
        }
        if (!CS1AppUtils.isValidProject(appRoot)) {
            JOptionPane.showMessageDialog(null, "The folder you selected is not a valid CS111 Project folder.");
            return null;
        }
        if (!dirSelected && CS1AppUtils.appRoot != null) {
            return CS1AppUtils.getFileOpenSelector(appFile);
        }
        String appName = appRoot.getName();
        CS1AppUtils.appRoot = appRoot;
        appSrcPath = Paths.get(appRoot.getAbsolutePath(), "src", "cs1", appName).toFile();
        appLibPath = Paths.get(appRoot.getAbsolutePath(), "lib").toFile();
        CS1AppUtils.appName = appName;
        Path cs1appMainPath = Paths.get(CS1APP_JAR, new String[0]);
        Path cs1appAppPath = Paths.get(appRoot.getAbsolutePath(), "lib", "cs1app.jar");
        try {
            Files.copy(cs1appMainPath, cs1appAppPath, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (Exception e) {
            CS1AppUtils.printToConsole(e);
            JOptionPane.showMessageDialog(null, "Could not synchronize lib/cs1app.jar for " + appRoot.getName(), "App Open Error", 0);
        }
        for (File file : javaFiles = appSrcPath.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".java");
            }
        })) {
            LogValidator.ValidationResult result = LogValidator.validateDocument(file);
            if (result.isValid) continue;
            JOptionPane.showMessageDialog(null, result.message, "Log Validation Error", 0);
        }
        return CS1AppUtils.getFileOpenSelector(javaFiles);
    }

    public static FileOpenSelector _open() {
        if (CS1AppUtils.isDrJavaRunning()) {
            return null;
        }
        File workDir = CS1AppUtils.getWorkDir();
        if (_model != null && _model.getActiveDocument() != null) {
            workDir = _model.getActiveDocument().getParentDirectory();
        }
        JFileChooser fileChooser = new JFileChooser(workDir);
        fileChooser.setDialogTitle("Open App");
        fileChooser.setFileSelectionMode(2);
        fileChooser.setFileFilter(new FileNameExtensionFilter("Java files", "java"));
        int returnVal = fileChooser.showOpenDialog(null);
        if (returnVal != 0) {
            return null;
        }
        return CS1AppUtils.openAndroidProject(fileChooser.getSelectedFile());
    }

    public static File getWorkDir() {
        File workDir = new File(".");
        if (workDir.getAbsolutePath().startsWith("/usr/local/cs111")) {
            workDir = new File(System.getProperty("user.home"));
        }
        return workDir;
    }

    public static FileOpenSelector _new() {
        if (CS1AppUtils.isDrJavaRunning()) {
            return null;
        }
        File workDir = CS1AppUtils.getWorkDir();
        JFileChooser fileChooser = new JFileChooser(workDir);
        fileChooser.setDialogTitle("Create New App");
        fileChooser.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.isDirectory();
            }

            @Override
            public String getDescription() {
                return "Directories Only";
            }
        });
        int returnVal = fileChooser.showSaveDialog(null);
        if (returnVal != 0) {
            return null;
        }
        File appRoot = fileChooser.getSelectedFile();
        if (appRoot.exists()) {
            JOptionPane.showMessageDialog(null, "This name is already in use. Please pick a new one.", "Duplicate Project Name", 2);
            return null;
        }
        String appName = appRoot.getName();
        if (!CS1AppUtils.isValidClassName(appName)) {
            return null;
        }
        boolean result = CS1AppUtils.makeApp(appRoot);
        if (!result) {
            return null;
        }
        CS1AppUtils.appRoot = appRoot;
        appSrcPath = Paths.get(appRoot.getAbsolutePath(), "src", "cs1", appName).toFile();
        appLibPath = Paths.get(appRoot.getAbsolutePath(), "lib").toFile();
        CS1AppUtils.appName = appName;
        File appFile = new File(appSrcPath, appName + ".java");
        return CS1AppUtils.getFileOpenSelector(appFile);
    }

    public static void setupButtons(JToolBar _toolBar) {
        buttonGroup = new JComboBox<String>(new String[]{"Android", "Java"});
        buttonGroup.setSelectedIndex(0);
        _toolBar.add(buttonGroup);
    }

    public static void setButtonsEnabled(boolean enable) {
        buttonGroup.setEnabled(enable);
    }

    public static boolean isAndroidSelected() {
        return buttonGroup.getSelectedItem().equals("Android");
    }

    public static void addFormattingErrors(List<DJError> errors) {
        File[] javaFiles;
        if (!errors.isEmpty()) {
            compilationSuccess = false;
            return;
        }
        for (File file : javaFiles = appSrcPath.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".java");
            }
        })) {
            nonVoidMethods.clear();
            ArrayList<Line> lines = CS1AppUtils.fileToLines(file);
            if (lines == null) continue;
            errors.addAll(CS1AppUtils.findNonVoidAssignment(file, lines));
            ArrayList<StyleError> checkStyleErrs = CheckStyleReader.getCheckStyleErrors(file);
            if (checkStyleErrs.isEmpty()) continue;
            CS1AppUtils.deleteClassFile(file);
            errors.addAll(checkStyleErrs);
            compilationSuccess = false;
        }
    }

    private static void deleteClassFile(File file) {
        String absPath = file.getAbsolutePath();
        if (absPath.endsWith(".java")) {
            new File(absPath.replace("java", "class")).delete();
        }
    }

    private static ArrayList<Line> fileToLines(File file) {
        block9: {
            ArrayList<Line> arrayList;
            BufferedReader br = new BufferedReader(new FileReader(file));
            try {
                String line;
                ArrayList<Line> lines = new ArrayList<Line>();
                while ((line = br.readLine()) != null) {
                    Line formattedLine = new Line(line);
                    lines.add(formattedLine);
                    if (!formattedLine.isNonVoidMethod()) continue;
                    String methodName = CS1AppUtils.methodName(line);
                    nonVoidMethods.add(methodName);
                }
                arrayList = lines;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        br.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (FileNotFoundException e) {
                    CS1AppUtils.printToConsole(e);
                    break block9;
                }
                catch (IOException e) {
                    CS1AppUtils.printToConsole(e);
                }
            }
            br.close();
            return arrayList;
        }
        return null;
    }

    private static ArrayList<Warning> findNonVoidAssignment(File file, List<Line> lines) {
        ArrayList<Warning> warnings = new ArrayList<Warning>();
        for (int numLine = 0; numLine < lines.size(); ++numLine) {
            String statement;
            Line curLine = lines.get(numLine);
            String content = curLine.trimmed;
            Matcher matcher = methodCall.matcher(content);
            if (!matcher.find() || !nonVoidMethods.contains(statement = matcher.group())) continue;
            warnings.add(new Warning(file, numLine));
        }
        return warnings;
    }

    public static String methodName(String line) {
        Matcher matcher = methodName.matcher(line);
        if (matcher.find()) {
            return matcher.group();
        }
        return null;
    }

    static {
        DEVICE = EMU_SERIAL = "emulator-" + EMU_PORT;
        sdkFound = CS1AppUtils.setupTools();
        methodName = Pattern.compile("\\w+(?=\\s*\\()");
        methodCall = Pattern.compile(".*(?=\\s*\\()");
        nonVoidMethods = new HashSet<String>();
    }

    static class Warning
    extends CompilerError {
        private static final String WARNING_LABEL = "Result of 'non-void' method should be stored in a variable.";

        public Warning(File file, int lineNumber) {
            super(file, lineNumber, 1, WARNING_LABEL, true);
        }
    }

    static class StyleError
    extends CompilerError {
        public StyleError(File file, int lineNumber, ErrorLabel label) {
            super(file, lineNumber, 1, label.toString(), false);
        }

        private StyleError(File file, int lineIndex, int charIndex, String errName) {
            super(file, lineIndex, charIndex, errName, false);
        }

        public static StyleError toStyleError(String checkStyleErr) {
            String[] errSplitted;
            String errName;
            String[] msgSplitted = checkStyleErr.split(": ");
            String location = msgSplitted[0];
            String errDescription = msgSplitted[1];
            String[] locationSplitted = location.split(".java:");
            String fileName = locationSplitted[0] + ".java";
            File file = new File(fileName);
            locationSplitted = locationSplitted[1].split(":");
            int lineIndex = Integer.parseInt(locationSplitted[0]);
            int charIndex = -1;
            if (locationSplitted.length == 2) {
                charIndex = Integer.parseInt(locationSplitted[1]);
            }
            if ((errName = (errSplitted = errDescription.split(" \\["))[0]).startsWith("+") || errName.startsWith("-")) {
                int lineIncrement = Integer.parseInt(errName.substring(0, 2));
                lineIndex += lineIncrement;
                errName = errName.substring(2);
            }
            return new StyleError(file, lineIndex - 1, charIndex, errName);
        }
    }
}

