/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava;

import edu.rice.cs.drjava.DrJava;
import edu.rice.cs.plt.concurrent.JVMBuilder;
import edu.rice.cs.plt.io.IOUtil;
import edu.rice.cs.util.FileOps;
import edu.rice.cs.util.Log;
import java.io.File;
import javax.swing.JOptionPane;

public class DrJavaRestart {
    public static final int ATTEMPTS = 5;
    public static final int TIME_BETWEEN_ATTEMPTS = 1000;
    public static Log LOG = new Log("version.txt", false);

    public static void message(String message) {
        LOG.log(message);
        JOptionPane.showMessageDialog(null, message, "Error Updating DrJava", 0);
    }

    public static boolean delete(File f) {
        for (int i = 0; i < 5; ++i) {
            if (f.delete()) {
                return true;
            }
            LOG.log("Failed to delete " + f + ", trying again");
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return false;
    }

    public static boolean deleteRecursively(File f) {
        for (int i = 0; i < 5; ++i) {
            if (IOUtil.deleteRecursively(f)) {
                return true;
            }
            LOG.log("Failed to recursively delete " + f + ", trying again");
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return false;
    }

    public static boolean rename(File from, File to2) {
        for (int i = 0; i < 5; ++i) {
            if (from.renameTo(to2)) {
                return true;
            }
            LOG.log("Failed to rename " + from + " to " + to2 + ", trying again");
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return false;
    }

    public static void main(String[] args) {
        File dest;
        File source = new File(args[0]);
        File exec = dest = new File(args[1]);
        try {
            LOG.log("source: " + source.getAbsolutePath());
            LOG.log("dest  : " + dest.getAbsolutePath());
            if (dest.exists()) {
                if (dest.isFile()) {
                    if (DrJavaRestart.delete(dest)) {
                        if (!DrJavaRestart.rename(source, dest)) {
                            exec = source;
                            DrJavaRestart.message("A new version of DrJava was downloaded. However, it could not be\ninstalled in the same place as the old DrJava.\n\nThe new copy is now installed at:\n" + source.getAbsolutePath() + "\n\nThe old copy has been deleted.");
                        }
                    } else {
                        exec = source;
                        DrJavaRestart.message("A new version of DrJava was downloaded. However, it could not be\ninstalled in the same place as the old DrJava.\n\nThe new copy is now installed at:\n" + source.getAbsolutePath() + "\n\nThe old copy is still installed at:\n" + dest.getAbsolutePath());
                    }
                    LOG.log("Restarting...");
                    Process p = JVMBuilder.DEFAULT.classPath(exec).start(DrJava.class.getName(), "-new", "-delete-after-restart", args[2]);
                    LOG.log("Done with DrJavaRestart");
                    System.exit(0);
                } else {
                    Process p;
                    File old = FileOps.generateNewFileName(dest);
                    if (DrJavaRestart.rename(dest, old)) {
                        if (DrJavaRestart.rename(source, dest)) {
                            DrJavaRestart.delete(source.getParentFile());
                            if (!DrJavaRestart.deleteRecursively(old)) {
                                DrJavaRestart.message("A new version of DrJava was downloaded. However, the old versioncould not be deleted.\n\nThe new copy is now installed at:\n" + dest.getAbsolutePath() + "\n\nThe old copy is still installed at:\n" + old.getAbsolutePath());
                            }
                        } else {
                            exec = source;
                            if (DrJavaRestart.rename(old, dest)) {
                                DrJavaRestart.message("A new version of DrJava was downloaded. However, it could not be\ninstalled in the same place as the old DrJava.\n\nThe new copy is now installed at:\n" + source.getAbsolutePath() + "\n\nThe old copy is still installed at:\n" + dest.getAbsolutePath());
                            } else {
                                DrJavaRestart.message("A new version of DrJava was downloaded. However, it could not be\ninstalled in the same place as the old DrJava.\n\nThe new copy is now installed at:\n" + source.getAbsolutePath() + "\n\nThe old copy is still installed at:\n" + old.getAbsolutePath());
                            }
                        }
                    } else {
                        exec = source;
                        DrJavaRestart.message("A new version of DrJava was downloaded. However, it could not be\ninstalled in the same place as the old DrJava.\n\nThe new copy is now installed at:\n" + source.getAbsolutePath() + "\n\nThe old copy is still installed at:\n" + dest.getAbsolutePath());
                    }
                    File macOpenFile = new File("/usr/bin/open");
                    LOG.log("Searching for " + macOpenFile);
                    if (!macOpenFile.exists()) {
                        String path = System.getenv("PATH");
                        for (String p2 : path.split(System.getProperty("path.separator"))) {
                            macOpenFile = new File(p2, "tar");
                            LOG.log("Searching for " + macOpenFile);
                            if (macOpenFile.exists()) break;
                        }
                    }
                    if (macOpenFile.exists()) {
                        LOG.log("Restarting using ProcessBuilder...");
                        p = new ProcessBuilder(new String[0]).command(macOpenFile.getAbsolutePath(), exec.getAbsolutePath()).redirectErrorStream(true).start();
                        System.exit(0);
                    } else {
                        LOG.log("Restarting using JVMBuilder...");
                        exec = new File(exec, "Contents/Resources/Java/drjava.jar");
                        p = JVMBuilder.DEFAULT.classPath(exec).start(DrJava.class.getName(), "-new", "-delete-after-restart", args[2]);
                        LOG.log("Done with DrJavaRestart");
                        System.exit(0);
                    }
                }
            }
        }
        catch (Exception e) {
            DrJavaRestart.message("A new version of DrJava was downloaded. However, there was an errorduring installation:\n" + e.getMessage());
        }
    }
}

