/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava;

import edu.rice.cs.drjava.DrJavaRoot;
import edu.rice.cs.drjava.RemoteControlClient;
import edu.rice.cs.drjava.config.FileConfiguration;
import edu.rice.cs.drjava.config.OptionConstants;
import edu.rice.cs.drjava.config.ResourceBundleConfiguration;
import edu.rice.cs.drjava.model.DrJavaFileUtils;
import edu.rice.cs.drjava.platform.PlatformFactory;
import edu.rice.cs.drjava.ui.DrJavaErrorHandler;
import edu.rice.cs.javalanglevels.LanguageLevelConverter;
import edu.rice.cs.plt.concurrent.DelayedInterrupter;
import edu.rice.cs.plt.concurrent.JVMBuilder;
import edu.rice.cs.plt.iter.IterUtil;
import edu.rice.cs.plt.reflect.JavaVersion;
import edu.rice.cs.util.ArgumentTokenizer;
import edu.rice.cs.util.Log;
import edu.rice.cs.util.UnexpectedException;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JOptionPane;

public class DrJava {
    public static volatile Log _log = new Log("DrJava.txt", false);
    private static final String DEFAULT_MAX_HEAP_SIZE_ARG = "-Xmx128M";
    private static final ArrayList<String> _filesToOpen = new ArrayList();
    private static final ArrayList<String> _jvmArgs = new ArrayList();
    static volatile boolean _showDebugConsole = false;
    static volatile boolean _forceNewInstance = false;
    static volatile boolean _doRestart = false;
    static volatile boolean _alreadyRestarted = false;
    static volatile boolean _restartedDrJavaUsesRemoteControl = true;
    private static final int WAIT_BEFORE_DECLARING_SUCCESS = 5000;
    private static final int NUM_REMOTE_CONTROL_RETRIES = 15;
    private static final int WAIT_BEFORE_REMOTE_CONTROL_RETRY = 500;
    public static final File DEFAULT_PROPERTIES_FILE;
    private static volatile File _propertiesFile;
    private static volatile FileConfiguration _config;
    public static final String RESOURCE_BUNDLE_NAME = "edu.rice.cs.drjava.config.options";

    public static File getPropertiesFile() {
        return _propertiesFile;
    }

    public static synchronized FileConfiguration getConfig() {
        if (_config == null) {
            _config = DrJava._initConfig();
        }
        return _config;
    }

    public static synchronized String[] getFilesToOpen() {
        return _filesToOpen.toArray(new String[0]);
    }

    public static synchronized void addFileToOpen(String s) {
        _filesToOpen.add(s);
        boolean isProjectFile = s.endsWith(".drjava") || s.endsWith(".xml") || s.endsWith(".pjt");
        _forceNewInstance |= isProjectFile;
        if (_doRestart && _alreadyRestarted) {
            _log.log("addFileToOpen: already done the restart, trying to use remote control");
            if (DrJava.getConfig().getSetting(OptionConstants.REMOTE_CONTROL_ENABLED).booleanValue()) {
                _log.log("\tremote control...");
                DrJava.openWithRemoteControl(_filesToOpen, 15);
                _log.log("\tclearing _filesToOpen");
                DrJava.clearFilesToOpen();
            }
        }
    }

    public static synchronized void clearFilesToOpen() {
        _filesToOpen.clear();
    }

    public static synchronized boolean openWithRemoteControl(ArrayList<String> files, int numAttempts) {
        if (!DrJava.getConfig().getSetting(OptionConstants.REMOTE_CONTROL_ENABLED).booleanValue() || !_restartedDrJavaUsesRemoteControl || files.size() == 0) {
            return false;
        }
        ArrayList<String> fs = new ArrayList<String>(files);
        int failCount = 0;
        while (failCount < numAttempts) {
            try {
                RemoteControlClient.openFile(null);
                if (RemoteControlClient.isServerRunning()) {
                    for (int i = 0; i < fs.size(); ++i) {
                        _log.log("opening with remote control " + fs.get(i));
                        RemoteControlClient.openFile(new File(fs.get(i)));
                        files.remove(fs.get(i));
                    }
                    return true;
                }
                _log.log("Failed to open with remote control, attempt " + ++failCount + " of " + 15);
                if (failCount >= numAttempts) {
                    return false;
                }
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException i) {
                }
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
        return false;
    }

    public static boolean getShowDebugConsole() {
        return _showDebugConsole;
    }

    public static void main(String[] args) {
        if (DrJava.handleCommandLineArgs(args)) {
            PlatformFactory.ONLY.beforeUISetup();
            DrJava.configureAndLoadDrJavaRoot(args);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static void configureAndLoadDrJavaRoot(String[] args) {
        try {
            LinkedList<String> classArgs;
            block18: {
                if (!_forceNewInstance && DrJava.getConfig().getSetting(OptionConstants.REMOTE_CONTROL_ENABLED).booleanValue() && _filesToOpen.size() > 0 && DrJava.openWithRemoteControl(_filesToOpen, 1)) {
                    System.exit(0);
                }
                int failCount = 0;
                while (failCount < 2) {
                    String masterMemory = DrJava.getConfig().getSetting(OptionConstants.MASTER_JVM_XMX).trim();
                    boolean _doRestart = DrJava.getConfig().getSetting(OptionConstants.MASTER_JVM_ARGS).length() > 0 || !"".equals(masterMemory) && !OptionConstants.heapSizeChoices.get(0).equals(masterMemory);
                    _log.log("_doRestart: " + _doRestart);
                    classArgs = new LinkedList<String>();
                    if (_showDebugConsole) {
                        classArgs.addFirst("-debugConsole");
                    }
                    if (!_propertiesFile.equals(DEFAULT_PROPERTIES_FILE)) {
                        classArgs.addFirst(_propertiesFile.getAbsolutePath());
                        classArgs.addFirst("-config");
                    }
                    Class<DrJava> clazz = DrJava.class;
                    // MONITORENTER : edu.rice.cs.drjava.DrJava.class
                    classArgs.addAll(_filesToOpen);
                    DrJava.clearFilesToOpen();
                    _log.log("_filesToOpen copied into class arguments, clearing _filesToOpen");
                    // MONITOREXIT : clazz
                    if (!_doRestart) break block18;
                    _restartedDrJavaUsesRemoteControl = DrJava.getConfig().getSetting(OptionConstants.REMOTE_CONTROL_ENABLED) != false ? !RemoteControlClient.isServerRunning() : false;
                    try {
                        boolean failed = false;
                        JVMBuilder jvmb = JVMBuilder.DEFAULT.jvmArguments(_jvmArgs);
                        _log.log("JVMBuilder: classPath = " + jvmb.classPath());
                        ArrayList<File> extendedClassPath = new ArrayList<File>();
                        for (File f : jvmb.classPath()) {
                            extendedClassPath.add(f);
                        }
                        _log.log("JVMBuilder: extendedClassPath = " + extendedClassPath);
                        jvmb = jvmb.classPath(IterUtil.asSizedIterable(extendedClassPath));
                        _log.log("JVMBuilder: jvmArguments = " + jvmb.jvmArguments());
                        _log.log("JVMBuilder: classPath = " + jvmb.classPath());
                        _log.log("JVMBuilder: mainParams = " + classArgs);
                        Process p = jvmb.start(DrJavaRoot.class.getName(), classArgs);
                        _alreadyRestarted = true;
                        _log.log("_alreadyRestarted = true");
                        DelayedInterrupter timeout = new DelayedInterrupter(5000L);
                        try {
                            int exitValue = p.waitFor();
                            timeout.abort();
                            failed = exitValue != 0;
                        }
                        catch (InterruptedException exitValue) {
                            // empty catch block
                        }
                        _log.log("failed = " + failed);
                        if (!failed) {
                            _log.log("not failed, send remaining files via remote control: " + _filesToOpen);
                            DrJava.openWithRemoteControl(_filesToOpen, 15);
                            return;
                        }
                        if (failCount > 0) {
                            JOptionPane.showMessageDialog(null, "DrJava was unable to start, and resetting your configuration\ndid not help. Please file a support request at\nhttps://sourceforge.net/projects/drjava/", "Could Not Start DrJava", 0);
                            System.exit(1);
                            return;
                        }
                        int result = JOptionPane.showConfirmDialog(null, "DrJava was unable to start. Your configuration file (.drjava)\nmight be corrupt. Do you want to reset your configuration?", "Could Not Start DrJava", 0);
                        if (result != 0) {
                            System.exit(0);
                        }
                        DrJava.getConfig().resetToDefaults();
                        DrJava.getConfig().saveConfiguration();
                        if (!DrJava.handleCommandLineArgs(args)) {
                            System.exit(0);
                        }
                        ++failCount;
                    }
                    catch (IOException ioe) {
                        String[] text = new String[]{"DrJava was unable to load its compiler and debugger.  Would you ", "like to start DrJava without a compiler and debugger?", "\nReason: " + ioe.toString()};
                        int result = JOptionPane.showConfirmDialog(null, text, "Could Not Load Compiler and Debugger", 0);
                        if (result == 0) return;
                        System.exit(0);
                        return;
                    }
                }
                return;
            }
            DrJavaRoot.main(classArgs.toArray(new String[0]));
            ArrayList<String> fs = new ArrayList<String>(_filesToOpen);
            Iterator<String> iterator = fs.iterator();
            while (iterator.hasNext()) {
                String f = iterator.next();
                DrJavaRoot.handleRemoteOpenFile(new File(f), -1);
            }
            return;
        }
        catch (Throwable t) {
            System.out.println(t.getClass().getName() + ": " + t.getMessage());
            t.printStackTrace(System.err);
            System.out.println("error thrown");
            DrJavaErrorHandler.record(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean handleCommandLineArgs(String[] args) {
        Object arg;
        boolean heapSizeGiven = false;
        int argIndex = 0;
        int len = args.length;
        _log.log("handleCommandLineArgs. _filesToOpen: " + _filesToOpen);
        while (argIndex < len) {
            if (((String)(arg = args[argIndex++])).equals("-config")) {
                if (len == argIndex) {
                    return true;
                }
                DrJava.setPropertiesFile(args[argIndex++]);
                continue;
            }
            if (((String)arg).startsWith("-X") || ((String)arg).startsWith("-D")) {
                if (((String)arg).startsWith("-Xmx")) {
                    heapSizeGiven = true;
                }
                _jvmArgs.add((String)arg);
                continue;
            }
            if (((String)arg).equals("-debugConsole")) {
                _showDebugConsole = true;
                continue;
            }
            if (((String)arg).equals("-new")) {
                _forceNewInstance = true;
                continue;
            }
            if (((String)arg).equals("-delete-after-restart")) {
                File deleteAfterRestart = new File(args[argIndex++]);
                deleteAfterRestart.delete();
                continue;
            }
            if (((String)arg).equals("-jll")) {
                String[] argsForJLL = new String[args.length - argIndex];
                System.arraycopy(args, argIndex, argsForJLL, 0, argsForJLL.length);
                LanguageLevelConverter.main(argsForJLL);
                System.exit(0);
                continue;
            }
            if (((String)arg).equals("-help") || ((String)arg).equals("-?")) {
                DrJava.displayUsage();
                return false;
            }
            --argIndex;
            break;
        }
        arg = DrJava.class;
        synchronized (DrJava.class) {
            String iconLoc;
            _config = DrJava._initConfig();
            // ** MonitorExit[arg] (shouldn't be in output)
            if (!"".equals(DrJava.getConfig().getSetting(OptionConstants.MASTER_JVM_XMX)) && !OptionConstants.heapSizeChoices.get(0).equals(DrJava.getConfig().getSetting(OptionConstants.MASTER_JVM_XMX))) {
                _jvmArgs.add("-Xmx" + DrJava.getConfig().getSetting(OptionConstants.MASTER_JVM_XMX).trim() + "M");
                heapSizeGiven = true;
            }
            List<String> configArgs = ArgumentTokenizer.tokenize(DrJava.getConfig().getSetting(OptionConstants.MASTER_JVM_ARGS));
            for (String arg2 : configArgs) {
                if (arg2.startsWith("-Xmx")) {
                    heapSizeGiven = true;
                }
                _jvmArgs.add(arg2);
            }
            if (PlatformFactory.ONLY.isMacPlatform() && (iconLoc = System.getProperty("edu.rice.cs.drjava.icon")) != null) {
                _jvmArgs.add("-Xdock:name=DrJava");
                _jvmArgs.add("-Xdock:icon=" + iconLoc);
            }
            if (!heapSizeGiven) {
                _jvmArgs.add(DEFAULT_MAX_HEAP_SIZE_ARG);
            }
            _log.log("_jvmArgs = " + _jvmArgs);
            for (int i = argIndex; i < len; ++i) {
                DrJava.addFileToOpen(args[i]);
            }
            _log.log("\t _filesToOpen now contains: " + _filesToOpen);
            return true;
        }
    }

    static void displayUsage() {
        System.out.println("Usage: java -jar drjava.jar [OPTIONS] [FILES]\n");
        System.out.println("where options include:");
        System.out.println("  -config [FILE]        use a custom config file");
        System.out.println("  -new                  force the creation of a new DrJava instance;");
        System.out.println("                        do not connect to existing instance");
        System.out.println("  -help | -?            print this help message");
        System.out.println("  -X<jvmOption>         specify a JVM configuration option for the master DrJava JVM");
        System.out.println("  -D<name>[=<value>]    set a Java property for the master DrJava JVM");
        System.out.println("  -jll [ARGS]           invoke the Java Language Level converter, specify files in ARGS");
    }

    static void setPropertiesFile(String fileName) {
        if (!DrJavaFileUtils.isSourceFile(fileName)) {
            _propertiesFile = new File(fileName);
        }
    }

    static FileConfiguration _initConfig() throws IllegalStateException {
        File propFile = _propertiesFile;
        try {
            propFile.createNewFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        FileConfiguration config = new FileConfiguration(propFile);
        try {
            config.loadConfiguration();
        }
        catch (Exception e) {
            config.storeStartupException(e);
        }
        _config = new ResourceBundleConfiguration(RESOURCE_BUNDLE_NAME, config);
        return _config;
    }

    protected static void _saveConfig() {
        try {
            DrJava.getConfig().saveConfiguration();
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(null, "Could not save the location of tools.jar in \nthe '.drjava' file in your home directory. \nAnother process may be using the file.\n\n" + e, "Could Not Save Changes", 0);
            DrJavaErrorHandler.record(new UnexpectedException(e, "Could not save the location of tools.jar in \nthe '.drjava' file in your home directory. \nAnother process may be using the file.\n\n"));
        }
    }

    public static void cleanUp() {
        _log.log("cleanUp. _filesToOpen: " + _filesToOpen);
        DrJava.clearFilesToOpen();
        _log.log("\t_filesToOpen cleared");
        _jvmArgs.clear();
    }

    public static boolean warnIfLinuxWithCompiz() {
        try {
            if (!System.getProperty("os.name").equals("Linux")) {
                return false;
            }
            if (!DrJava.getConfig().getSetting(OptionConstants.WARN_IF_COMPIZ).booleanValue()) {
                return false;
            }
            File ps = new File("/bin/ps");
            ProcessBuilder pb = new ProcessBuilder(ps.getAbsolutePath(), "-A");
            Process psProc = pb.start();
            psProc.waitFor();
            BufferedReader br = new BufferedReader(new InputStreamReader(psProc.getInputStream()));
            boolean compiz = false;
            String line = null;
            while ((line = br.readLine()) != null) {
                if (!line.endsWith("compiz") && !line.endsWith("compiz.real")) continue;
                compiz = true;
                break;
            }
            if (!compiz) {
                return false;
            }
            JavaVersion.FullVersion ver160_20 = JavaVersion.parseFullVersion("1.6.0_20");
            if (JavaVersion.CURRENT_FULL.compareTo(ver160_20) >= 0) {
                return false;
            }
            Object[] options = new String[]{"Yes", "Yes, and ignore from now on", "No"};
            int res = JOptionPane.showOptionDialog(null, "<html>DrJava has detected that you are using Compiz with a version<br>of Java that is older than " + ver160_20 + ".<br><br>Compiz and older versions of Java are incompatible and can cause<br>DrJava or your computer to crash.<br><br>We recommend that you <b>update to " + ver160_20 + " or newer</b>,<br>or that you disable Compiz if you still experience problems.<br>On Ubuntu, go to System->Preferences->Appearence, display the<br>Visual Effects tab, and select 'None'.<br><br>For more information, please go to http://drjava.org/compiz<br><br>Do you want to start DrJava anyway?</html>", "Compiz detected", -1, 2, null, options, options[0]);
            switch (res) {
                case 1: {
                    DrJava.getConfig().setSetting(OptionConstants.WARN_IF_COMPIZ, false);
                    break;
                }
                case 2: {
                    System.exit(0);
                }
            }
            return compiz;
        }
        catch (IOException ioe) {
            return false;
        }
        catch (InterruptedException ie) {
            return false;
        }
    }

    static {
        _propertiesFile = DEFAULT_PROPERTIES_FILE = new File(System.getProperty("user.home"), ".drjava");
    }
}

