/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.cunit.util;

import java.lang.ref.SoftReference;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SoftHashMap<K, V>
implements Map<K, V> {
    private HashMap<K, SoftReference<V>> _map;
    static final int DEFAULT_INITIAL_CAPACITY = 16;
    static final int MAXIMUM_CAPACITY = 0x40000000;
    static final float DEFAULT_LOAD_FACTOR = 0.75f;

    public SoftHashMap(int initialCapacity, float loadFactor) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Illegal initial capacity: " + initialCapacity);
        }
        if (initialCapacity > 0x40000000) {
            initialCapacity = 0x40000000;
        }
        if (loadFactor <= 0.0f || Float.isNaN(loadFactor)) {
            throw new IllegalArgumentException("Illegal load factor: " + loadFactor);
        }
        this._map = new HashMap(initialCapacity, loadFactor);
    }

    public SoftHashMap(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public SoftHashMap() {
        this._map = new HashMap();
    }

    public SoftHashMap(Map<? extends K, ? extends V> m) {
        this._map = new HashMap(m.size(), 0.75f);
        for (K key : m.keySet()) {
            V value = m.get(key);
            if (value == null) continue;
            this._map.put(key, new SoftReference<V>(value));
        }
    }

    @Override
    public V get(Object key) {
        SoftReference<V> sr = this._map.get(key);
        if (sr == null) {
            return null;
        }
        V value = sr.get();
        if (value == null) {
            this._map.remove(key);
            return null;
        }
        return value;
    }

    public void compact() {
        for (K key : this._map.keySet()) {
            V value;
            SoftReference<V> sr = this._map.get(key);
            if (sr == null || (value = sr.get()) != null) continue;
            this._map.remove(key);
        }
    }

    @Override
    public int size() {
        this.compact();
        return this._map.size();
    }

    @Override
    public boolean isEmpty() {
        this.compact();
        return this._map.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        this.compact();
        return this._map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        for (K key : this._map.keySet()) {
            SoftReference<V> sr = this._map.get(key);
            if (sr == null) continue;
            V v = sr.get();
            if (value.equals(v)) {
                return true;
            }
            if (v != null) continue;
            this._map.remove(key);
        }
        return false;
    }

    @Override
    public V put(K k, V v) {
        SoftReference<V> sr = this._map.get(k);
        this._map.put(k, new SoftReference<V>(v));
        if (sr == null) {
            return null;
        }
        return sr.get();
    }

    @Override
    public V remove(Object key) {
        SoftReference<V> sr = this._map.get(key);
        this._map.remove(key);
        if (sr == null) {
            return null;
        }
        return sr.get();
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        this.compact();
        for (K key : map.keySet()) {
            V value = map.get(key);
            if (value == null) continue;
            this._map.put(key, new SoftReference<V>(value));
        }
    }

    @Override
    public void clear() {
        this._map.clear();
    }

    @Override
    public Set<K> keySet() {
        this.compact();
        return this._map.keySet();
    }

    @Override
    public Collection<V> values() {
        throw new UnsupportedOperationException("entrySet not supported by SoftHashMap");
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        throw new UnsupportedOperationException("entrySet not supported by SoftHashMap");
    }
}

