/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.cunit.instrumentors.threadCheck;

import edu.rice.cs.cunit.instrumentors.threadCheck.ThreadCheckAnnotationRecord;
import edu.rice.cs.cunit.util.XMLConfig;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;

public class ThreadCheckDefinitionRecord
implements Serializable {
    public final ThreadCheckAnnotationRecord invariant;
    public final HashSet<String> classNames;
    public final HashMap<String, Boolean> methodClassAndSigs;

    public ThreadCheckDefinitionRecord(ThreadCheckAnnotationRecord inv) {
        this.invariant = inv;
        this.classNames = new HashSet();
        this.methodClassAndSigs = new HashMap();
    }

    public void addClass(String className) {
        this.classNames.add(className);
    }

    public void addMethod(String className, String methodSig, boolean suppressSubtypingWarning) {
        this.methodClassAndSigs.put(className + "::" + methodSig, suppressSubtypingWarning);
    }

    public boolean appliesToClass(String className) {
        return this.classNames.contains(className);
    }

    public boolean appliesToMethod(String className, String methodSig) {
        return this.methodClassAndSigs.keySet().contains(className + "::" + methodSig);
    }

    public ThreadCheckAnnotationRecord getInvariant() {
        return this.invariant;
    }

    public boolean empty() {
        return this.classNames.size() == 0 && this.methodClassAndSigs.size() == 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ThreadCheckDefinitionRecord that = (ThreadCheckDefinitionRecord)o;
        if (!this.classNames.equals(that.classNames)) {
            return false;
        }
        if (!this.invariant.equals(that.invariant)) {
            return false;
        }
        return this.methodClassAndSigs.equals(that.methodClassAndSigs);
    }

    public int hashCode() {
        int result = this.invariant.hashCode();
        result = 31 * result + this.classNames.hashCode();
        result = 31 * result + this.methodClassAndSigs.hashCode();
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Invariant: ");
        sb.append(this.invariant);
        sb.append(XMLConfig.NL);
        if (this.classNames.size() > 0) {
            sb.append("\tClasses: " + this.classNames.size());
            for (String s : this.classNames) {
                sb.append("\t\t");
                sb.append(s);
                sb.append(XMLConfig.NL);
            }
        }
        if (this.methodClassAndSigs.size() > 0) {
            sb.append("\tMethods: " + this.methodClassAndSigs.size());
            for (String s : this.classNames) {
                sb.append("\t\t");
                sb.append(s);
                sb.append(XMLConfig.NL);
            }
        }
        return super.toString();
    }
}

