/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.cunit.classFile.code.instructions;

import edu.rice.cs.cunit.classFile.code.Opcode;
import edu.rice.cs.cunit.classFile.code.instructions.AInstruction;
import edu.rice.cs.cunit.classFile.code.instructions.LineNumberTable;
import edu.rice.cs.cunit.util.Types;

public class WideBranchInstruction
extends AInstruction {
    protected byte _opcode;
    protected int _target;

    public WideBranchInstruction(byte opcode, int target) {
        switch (opcode) {
            case -56: 
            case -55: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid wide branch opcode");
            }
        }
        this._opcode = opcode;
        this._target = target;
    }

    public byte getOpcode() {
        return this._opcode;
    }

    public int getBytecodeLength(int pc) {
        return 5;
    }

    public WideBranchInstruction(byte[] bytecode, int pc, int paddingPC, LineNumberTable lnt) {
        this._opcode = bytecode[pc];
        this._target = lnt.getLineNumber(pc + Types.intFromBytes(bytecode, pc + 1));
    }

    public byte[] getBytecode(int pc, LineNumberTable lnt) {
        byte[] b = new byte[this.getBytecodeLength(pc)];
        b[0] = this.getOpcode();
        Types.bytesFromInt(lnt.getPC(this._target) - pc, b, 1);
        return b;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof WideBranchInstruction)) {
            return false;
        }
        WideBranchInstruction wideBranchInstruction = (WideBranchInstruction)o;
        if (this._opcode != wideBranchInstruction._opcode) {
            return false;
        }
        return this._target == wideBranchInstruction._target;
    }

    public int hashCode() {
        int result = this._opcode;
        result = 29 * result + this._target;
        return result;
    }

    public int[] getBranchTargets() {
        return new int[]{this._target};
    }

    public void setBranchTargets(int[] branchTargets) {
        if (branchTargets.length != 1) {
            throw new IllegalArgumentException("Wide branch instruction can only have one target");
        }
        this._target = branchTargets[0];
    }

    public String toString() {
        StringBuilder x = new StringBuilder();
        x.append(Opcode.getOpcodeName(this._opcode));
        x.append(" ");
        x.append(this._target);
        return x.toString();
    }
}

