/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.cunit.classFile.code.instructions;

import edu.rice.cs.cunit.classFile.code.Opcode;
import edu.rice.cs.cunit.classFile.code.instructions.AInstruction;
import edu.rice.cs.cunit.classFile.code.instructions.LineNumberTable;
import edu.rice.cs.cunit.util.Types;
import java.util.Arrays;

public class TableSwitchInstruction
extends AInstruction {
    protected long _low;
    protected long _high;
    protected int[] _targets;

    public TableSwitchInstruction(int defaultTarget, long low, long high, int[] targets) {
        if (low > high) {
            throw new IllegalArgumentException("High cannot be greater than low.");
        }
        this._low = low;
        this._high = high;
        long npairs = high - low + 1L;
        if (npairs != (long)targets.length) {
            throw new IllegalArgumentException("Invalid number of targets");
        }
        this._targets = new int[(int)npairs + 1];
        this._targets[0] = defaultTarget;
        System.arraycopy(targets, 0, this._targets, 1, (int)npairs);
    }

    public byte getOpcode() {
        return -86;
    }

    public int getBytecodeLength(int pc) {
        int pad = 3 - pc % 4;
        int res = pad + 9 + this._targets.length * 4;
        assert (res <= 65535);
        return res;
    }

    public TableSwitchInstruction(byte[] bytecode, int pc, int paddingPC, LineNumberTable lnt) {
        int[] branchTargets = Opcode.getBranchTargets(bytecode, pc, paddingPC);
        int pad = 3 - paddingPC % 4;
        this._low = Types.intFromBytes(bytecode, pc + pad + 5);
        this._high = Types.intFromBytes(bytecode, pc + pad + 9);
        this._targets = new int[branchTargets.length];
        int i = 0;
        for (int bt : branchTargets) {
            this._targets[i++] = lnt.getLineNumber(bt);
        }
    }

    public byte[] getBytecode(int pc, LineNumberTable lnt) {
        int pad = 3 - pc % 4;
        byte[] b = new byte[this.getBytecodeLength(pc)];
        b[0] = this.getOpcode();
        Types.bytesFromInt(lnt.getPC(this._targets[0]) - pc, b, pad + 1);
        Types.bytesFromInt((int)this._low, b, pad + 5);
        Types.bytesFromInt((int)this._high, b, pad + 9);
        for (int i = 1; i < this._targets.length; ++i) {
            Types.bytesFromInt(lnt.getPC(this._targets[i]) - pc, b, pad + 9 + i * 4);
        }
        return b;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TableSwitchInstruction)) {
            return false;
        }
        TableSwitchInstruction tableSwitchInstruction = (TableSwitchInstruction)o;
        if (this._high != tableSwitchInstruction._high) {
            return false;
        }
        if (this._low != tableSwitchInstruction._low) {
            return false;
        }
        return Arrays.equals(this._targets, tableSwitchInstruction._targets);
    }

    public int hashCode() {
        int result = (int)(this._low ^ this._low >>> 32);
        result = 29 * result + (int)(this._high ^ this._high >>> 32);
        return result;
    }

    public int[] getBranchTargets() {
        int[] bt = new int[this._targets.length];
        int i = 0;
        for (int t : this._targets) {
            bt[i++] = t;
        }
        return bt;
    }

    public void setBranchTargets(int[] branchTargets) {
        if (branchTargets.length != this._targets.length) {
            throw new IllegalArgumentException("TABLESWITCH has incorrect number of targets");
        }
        for (int i = 0; i < branchTargets.length; ++i) {
            assert (branchTargets[i] <= 65535);
            this._targets[i] = branchTargets[i];
        }
    }

    public String toString() {
        StringBuilder x = new StringBuilder();
        x.append(Opcode.getOpcodeName((byte)-86));
        x.append(" default = ");
        x.append(this._targets[0]);
        x.append(" low = ");
        x.append(this._low);
        x.append(" high = ");
        x.append(this._high);
        x.append(" n = ");
        x.append(this._targets.length - 1);
        for (int i = 0; i < this._targets.length - 1; ++i) {
            x.append(" (");
            x.append(this._low + (long)i);
            x.append("->");
            x.append(this._targets[i + 1]);
            x.append(")");
        }
        return x.toString();
    }
}

