/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.cunit.classFile.attributes;

import edu.rice.cs.cunit.classFile.attributes.AAttributeInfo;
import edu.rice.cs.cunit.classFile.attributes.visitors.IAttributeVisitor;
import edu.rice.cs.cunit.classFile.code.instructions.LineNumberTable;
import edu.rice.cs.cunit.classFile.constantPool.AUTFPoolInfo;
import edu.rice.cs.cunit.classFile.constantPool.ConstantPool;
import edu.rice.cs.cunit.util.Types;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LineNumberTableAttributeInfo
extends AAttributeInfo {
    public LineNumberTableAttributeInfo(AUTFPoolInfo name, byte[] data, ConstantPool cp) throws ClassFormatError {
        super(name, data, cp);
    }

    public int getLineNumberCount() {
        int res = Types.ushortFromBytes(this._data, 0);
        assert (res <= 65535);
        return res;
    }

    public LineNumberRecord[] getLineNumbers() throws ClassFormatError {
        int count = this.getLineNumberCount();
        LineNumberRecord[] lnr = new LineNumberRecord[count];
        for (int i = 0; i < count; ++i) {
            lnr[i] = new LineNumberRecord(Types.ushortFromBytes(this._data, 2 + 4 * i), Types.ushortFromBytes(this._data, 4 + 4 * i));
        }
        return lnr;
    }

    public void setLineNumbers(LineNumberRecord[] lnr) {
        byte[] newData = new byte[2 + 4 * lnr.length];
        Types.bytesFromShort((short)lnr.length, newData, 0);
        for (int i = 0; i < lnr.length; ++i) {
            Types.bytesFromShort((short)(0xFFFF & lnr[i].startPC), newData, 2 + 4 * i);
            Types.bytesFromShort((short)(0xFFFF & lnr[i].lineNo), newData, 4 + 4 * i);
        }
        this.setData(newData);
    }

    @Override
    public <R, D> R execute(IAttributeVisitor<R, D> visitor, D param) {
        return visitor.lineNumberTableCase(this, param);
    }

    @Override
    public String toString() {
        StringBuilder x = new StringBuilder();
        x.append(this._name + " <" + this.getLineNumberCount() + " line numbers { ");
        boolean first = true;
        for (LineNumberRecord lnr : this.getLineNumbers()) {
            if (first) {
                first = false;
            } else {
                x.append(", ");
            }
            x.append("(PC=" + lnr.startPC + " @ " + lnr.lineNo + ")");
        }
        x.append(" } >");
        return x.toString();
    }

    @Override
    public void adjustPC(int startPC, int deltaPC) {
        LineNumberRecord[] lnrs;
        for (LineNumberRecord l : lnrs = this.getLineNumbers()) {
            if (l.startPC < startPC) continue;
            l.startPC += deltaPC;
        }
        this.setLineNumbers(lnrs);
    }

    @Override
    public void translatePC(int index, int deltaIndex, LineNumberTable oldLnt, LineNumberTable newLnt) {
        LineNumberRecord[] lnrs;
        for (LineNumberRecord l : lnrs = this.getLineNumbers()) {
            int oldLineNo;
            l.startPC = (short)newLnt.getPC(oldLineNo += (oldLineNo = oldLnt.getLineNumber(l.startPC)) > index ? deltaIndex : 0);
        }
        this.setLineNumbers(lnrs);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public static String getAttributeName() {
        return "LineNumberTable";
    }

    public static class LineNumberRecord {
        public int startPC;
        public int lineNo;

        public LineNumberRecord(int startPC, int lineNo) {
            assert (startPC <= 65535);
            assert (lineNo <= 65535);
            this.startPC = startPC;
            this.lineNo = lineNo;
        }
    }
}

