/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.cunit.classFile.attributes;

import edu.rice.cs.cunit.classFile.ClassFileTools;
import edu.rice.cs.cunit.classFile.attributes.AAttributeInfo;
import edu.rice.cs.cunit.classFile.attributes.visitors.IAttributeVisitor;
import edu.rice.cs.cunit.classFile.code.instructions.LineNumberTable;
import edu.rice.cs.cunit.classFile.constantPool.APoolInfo;
import edu.rice.cs.cunit.classFile.constantPool.ASCIIPoolInfo;
import edu.rice.cs.cunit.classFile.constantPool.AUTFPoolInfo;
import edu.rice.cs.cunit.classFile.constantPool.ClassPoolInfo;
import edu.rice.cs.cunit.classFile.constantPool.ConstantPool;
import edu.rice.cs.cunit.classFile.constantPool.EmptyPoolInfo;
import edu.rice.cs.cunit.classFile.constantPool.UnicodePoolInfo;
import edu.rice.cs.cunit.classFile.constantPool.visitors.ADefaultPoolInfoVisitor;
import edu.rice.cs.cunit.classFile.constantPool.visitors.CheckClassOrEmptyVisitor;
import edu.rice.cs.cunit.classFile.constantPool.visitors.CheckUTFOrEmptyVisitor;
import edu.rice.cs.cunit.util.Types;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InnerClassesAttributeInfo
extends AAttributeInfo {
    public InnerClassesAttributeInfo(AUTFPoolInfo name, byte[] data, ConstantPool cp) throws ClassFormatError {
        super(name, data, cp);
    }

    public int getInnerClassCount() {
        int res = Types.ushortFromBytes(this._data, 0);
        assert (res <= 65535);
        return res;
    }

    public InnerClassesRecord[] getInnerClasses() throws ClassFormatError {
        int count = this.getInnerClassCount();
        assert (count <= 65535);
        InnerClassesRecord[] arr = new InnerClassesRecord[count];
        for (int i = 0; i < count; i = (int)((short)(i + 1))) {
            arr[i] = new InnerClassesRecord(((APoolInfo)this._constantPool.get(Types.ushortFromBytes(this._data, 2 + 8 * i))).execute(CheckClassOrEmptyVisitor.singleton(), null), ((APoolInfo)this._constantPool.get(Types.ushortFromBytes(this._data, 4 + 8 * i))).execute(CheckClassOrEmptyVisitor.singleton(), null), ((APoolInfo)this._constantPool.get(Types.ushortFromBytes(this._data, 6 + 8 * i))).execute(CheckUTFOrEmptyVisitor.singleton(), null), (short)(Types.ushortFromBytes(this._data, 8 + 8 * i) & 0xFFFF));
        }
        return arr;
    }

    public void setLocalVariables(InnerClassesRecord[] arr) {
        byte[] newData = new byte[2 + 8 * arr.length];
        Types.bytesFromShort((short)arr.length, newData, 0);
        for (int i = 0; i < arr.length; ++i) {
            Types.bytesFromShort(this._constantPool.indexOf(arr[i].innerClass), newData, 2 + 8 * i);
            Types.bytesFromShort(this._constantPool.indexOf(arr[i].outerClass), newData, 4 + 8 * i);
            Types.bytesFromShort(this._constantPool.indexOf(arr[i].innerName), newData, 6 + 8 * i);
            Types.bytesFromShort(arr[i].innerFlags, newData, 8 + 8 * i);
        }
        this.setData(newData);
    }

    @Override
    public <R, D> R execute(IAttributeVisitor<R, D> visitor, D param) {
        return visitor.innerClassesCase(this, param);
    }

    @Override
    public String toString() {
        StringBuilder x = new StringBuilder();
        x.append(this._name + " <" + this.getInnerClassCount() + " inner classes { ");
        boolean first = true;
        for (InnerClassesRecord inc : this.getInnerClasses()) {
            if (first) {
                first = false;
            } else {
                x.append(", ");
            }
            x.append("(inner class=" + inc.innerClass.execute(new ADefaultPoolInfoVisitor<String, Object>(){

                @Override
                public String defaultCase(APoolInfo host, Object param) {
                    return null;
                }

                @Override
                public String emptyCase(EmptyPoolInfo host, Object param) {
                    return "null";
                }

                @Override
                public String classCase(ClassPoolInfo host, Object param) {
                    return host.getName().toString();
                }
            }, null) + ", outer class=" + inc.outerClass.execute(new ADefaultPoolInfoVisitor<String, Object>(){

                @Override
                public String defaultCase(APoolInfo host, Object param) {
                    return null;
                }

                @Override
                public String emptyCase(EmptyPoolInfo host, Object param) {
                    return "<not a member>";
                }

                @Override
                public String classCase(ClassPoolInfo host, Object param) {
                    return host.getName().toString();
                }
            }, null) + ", inner name=" + inc.innerName.execute(new ADefaultPoolInfoVisitor<String, Object>(){

                @Override
                public String defaultCase(APoolInfo host, Object param) {
                    return null;
                }

                @Override
                public String emptyCase(EmptyPoolInfo host, Object param) {
                    return "<anonymous>";
                }

                @Override
                public String asciizCase(ASCIIPoolInfo host, Object param) {
                    return host.toString();
                }

                @Override
                public String unicodeCase(UnicodePoolInfo host, Object param) {
                    return host.toString();
                }
            }, null) + ", flags=" + ClassFileTools.getAccessString(inc.innerFlags) + ")");
        }
        x.append(" } >");
        return x.toString();
    }

    @Override
    public void adjustPC(int startPC, int deltaPC) {
    }

    @Override
    public void translatePC(int index, int deltaIndex, LineNumberTable oldLnt, LineNumberTable newLnt) {
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public static String getAttributeName() {
        return "InnerClasses";
    }

    public static class InnerClassesRecord {
        public APoolInfo innerClass;
        public APoolInfo outerClass;
        public APoolInfo innerName;
        public short innerFlags;

        public InnerClassesRecord(APoolInfo innerClass, APoolInfo outerClass, APoolInfo innerName, short innerFlags) {
            this.innerClass = innerClass;
            this.outerClass = outerClass;
            this.innerName = innerName;
            this.innerFlags = innerFlags;
        }
    }
}

