/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.cunit.classFile.attributes;

import edu.rice.cs.cunit.classFile.ClassFileTools;
import edu.rice.cs.cunit.classFile.attributes.AAttributeInfo;
import edu.rice.cs.cunit.classFile.attributes.visitors.IAttributeVisitor;
import edu.rice.cs.cunit.classFile.code.instructions.LineNumberTable;
import edu.rice.cs.cunit.classFile.constantPool.APoolInfo;
import edu.rice.cs.cunit.classFile.constantPool.AUTFPoolInfo;
import edu.rice.cs.cunit.classFile.constantPool.ClassPoolInfo;
import edu.rice.cs.cunit.classFile.constantPool.ConstantPool;
import edu.rice.cs.cunit.classFile.constantPool.EmptyPoolInfo;
import edu.rice.cs.cunit.classFile.constantPool.visitors.ADefaultPoolInfoVisitor;
import edu.rice.cs.cunit.classFile.constantPool.visitors.CheckClassVisitor;
import edu.rice.cs.cunit.util.Types;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExceptionsAttributeInfo
extends AAttributeInfo {
    public ExceptionsAttributeInfo(AUTFPoolInfo name, byte[] data, ConstantPool cp) throws ClassFormatError {
        super(name, data, cp);
    }

    public int getExceptionCount() throws ClassFormatError {
        int res = Types.ushortFromBytes(this._data, 0);
        assert (res <= 65535);
        return res;
    }

    public ClassPoolInfo[] getExceptions() throws ClassFormatError {
        int count = this.getExceptionCount();
        assert (count <= 65535);
        ClassPoolInfo[] cpi = new ClassPoolInfo[count];
        for (int i = 0; i < count; i = (int)((short)(i + 1))) {
            cpi[i] = ((APoolInfo)this._constantPool.get(Types.ushortFromBytes(this._data, 2 + 2 * i))).execute(new ADefaultPoolInfoVisitor<ClassPoolInfo, Object>(){

                @Override
                public ClassPoolInfo defaultCase(APoolInfo host, Object o) {
                    throw new ClassFormatError("Checked exceptions list must contain class or empty items.");
                }

                @Override
                public ClassPoolInfo classCase(ClassPoolInfo host, Object o) {
                    return host;
                }

                @Override
                public ClassPoolInfo emptyCase(EmptyPoolInfo host, Object o) {
                    return null;
                }
            }, null);
        }
        return cpi;
    }

    public void setExceptions(ClassPoolInfo[] cpi) {
        byte[] newData = new byte[2 + 2 * cpi.length];
        Types.bytesFromShort((short)cpi.length, newData, 0);
        for (int i = 0; i < cpi.length; ++i) {
            if (cpi[i] != null) {
                Types.bytesFromShort(this._constantPool.indexOf(cpi[i].execute(CheckClassVisitor.singleton(), null)), newData, 2 + 2 * i);
                continue;
            }
            newData[2 + 2 * i] = 0;
            newData[3 + 2 * i] = 0;
        }
        this.setData(newData);
    }

    @Override
    public String toString() {
        StringBuilder x = new StringBuilder();
        x.append(this._name + " <" + this.getExceptionCount() + " exceptions { ");
        boolean first = true;
        for (ClassPoolInfo cpi : this.getExceptions()) {
            if (first) {
                first = false;
            } else {
                x.append(", ");
            }
            if (cpi != null) {
                x.append(ClassFileTools.getClassName(cpi.getName().toString()));
                continue;
            }
            x.append("empty item");
        }
        x.append(" } >");
        return x.toString();
    }

    @Override
    public <R, D> R execute(IAttributeVisitor<R, D> visitor, D param) {
        return visitor.exceptionsCase(this, param);
    }

    @Override
    public void adjustPC(int startPC, int deltaPC) {
    }

    @Override
    public void translatePC(int index, int deltaIndex, LineNumberTable oldLnt, LineNumberTable newLnt) {
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public static String getAttributeName() {
        return "Exceptions";
    }
}

