/*
 * Decompiled with CFR 0.152.
 */
package edu.gburg.nand2tetris;

import com.cburch.logisim.data.BitWidth;
import com.cburch.logisim.data.Value;
import com.cburch.logisim.instance.InstanceData;
import com.cburch.logisim.instance.InstanceState;
import com.cburch.logisim.instance.StdAttr;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.image.BufferedImage;

class ScreenData
implements InstanceData,
Cloneable {
    private Value lastClock;
    public BufferedImage image;
    public Value[][] memory;

    public static ScreenData get(InstanceState instanceState, BitWidth bitWidth) {
        ScreenData screenData = (ScreenData)instanceState.getData();
        if (screenData == null) {
            screenData = new ScreenData(null);
            instanceState.setData((InstanceData)screenData);
        }
        return screenData;
    }

    public ScreenData(Value value) {
        this.lastClock = value;
        this.memory = new Value[256][32];
        this.image = new BufferedImage(512, 256, 12);
        Graphics graphics = this.image.getGraphics();
        graphics.setColor(Color.WHITE);
        graphics.clearRect(0, 0, this.image.getWidth(), this.image.getHeight());
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public boolean updateClock(Value value, Object object) {
        Value value2 = this.lastClock;
        this.lastClock = value;
        if (object == null || object == StdAttr.TRIG_RISING) {
            return value2 == Value.FALSE && value == Value.TRUE;
        }
        if (object == StdAttr.TRIG_FALLING) {
            return value2 == Value.TRUE && value == Value.FALSE;
        }
        if (object == StdAttr.TRIG_HIGH) {
            return value == Value.TRUE;
        }
        if (object == StdAttr.TRIG_LOW) {
            return value == Value.FALSE;
        }
        return value2 == Value.FALSE && value == Value.TRUE;
    }

    public Value getValue(Value value) {
        int n = this.memory[0].length;
        int n2 = value.toIntValue();
        int n3 = n2 / n;
        int n4 = n2 % n;
        return this.memory[n3][n4];
    }

    public void setValue(Value value, Value value2) {
        int n = this.memory[0].length;
        int n2 = value2.toIntValue();
        int n3 = n2 / n;
        int n4 = n2 % n;
        this.memory[n3][n4] = value;
        Graphics graphics = this.image.getGraphics();
        int n5 = value.toIntValue();
        int n6 = 1;
        int n7 = n4 * 16;
        int n8 = n3;
        for (int i = 0; i < 16; ++i) {
            if ((n6 & n5) != 0) {
                graphics.setColor(Color.WHITE);
            } else {
                graphics.setColor(Color.BLACK);
            }
            graphics.drawLine(n7, n8, n7, n8);
            n6 <<= 1;
            ++n7;
        }
    }
}

