/*
 * Decompiled with CFR 0.152.
 */
package edu.gburg.nand2tetris;

import com.cburch.logisim.data.Attribute;
import com.cburch.logisim.data.BitWidth;
import com.cburch.logisim.data.Bounds;
import com.cburch.logisim.data.Direction;
import com.cburch.logisim.data.Value;
import com.cburch.logisim.instance.InstanceFactory;
import com.cburch.logisim.instance.InstancePainter;
import com.cburch.logisim.instance.InstanceState;
import com.cburch.logisim.instance.Port;
import com.cburch.logisim.instance.StdAttr;
import com.cburch.logisim.util.GraphicsUtil;
import com.cburch.logisim.util.StringUtil;
import edu.gburg.nand2tetris.PCData;
import java.awt.Color;
import java.awt.Graphics;

class PC
extends InstanceFactory {
    private static final int PC_WIDTH = 160;
    private static final int PC_HEIGHT = 40;
    private static final int ULX = -160;
    private static final int ULY = -20;
    private static final int TOP_SEP = 40;
    private static final int LEFT_SEP = 10;
    private static final int IN = 0;
    private static final int IN_INC = 1;
    private static final int IN_LOAD = 2;
    private static final int IN_RESET = 3;
    private static final int OUT = 4;
    private static final int CK = 5;
    private static final int NUM_PORTS = 6;

    public PC() {
        super("PC");
        this.setOffsetBounds(Bounds.create((int)-160, (int)-20, (int)160, (int)40));
        this.setAttributes(new Attribute[]{StdAttr.WIDTH, StdAttr.EDGE_TRIGGER}, new Object[]{BitWidth.create((int)16), StdAttr.TRIG_RISING});
        Port[] portArray = new Port[]{new Port(-160, -10, "input", StdAttr.WIDTH), new Port(-120, -20, "input", 1), new Port(-80, -20, "input", 1), new Port(-40, -20, "input", 1), new Port(0, 0, "output", StdAttr.WIDTH), new Port(-160, 10, "input", 1)};
        this.setPorts(portArray);
    }

    public void propagate(InstanceState instanceState) {
        BitWidth bitWidth = (BitWidth)instanceState.getAttributeValue(StdAttr.WIDTH);
        PCData pCData = PCData.get(instanceState, bitWidth);
        Object object = instanceState.getAttributeValue(StdAttr.EDGE_TRIGGER);
        boolean bl = pCData.updateClock(instanceState.getPortValue(5), object);
        if (bl) {
            pCData.setValue(PC.nextValue(instanceState, pCData.getValue()));
            instanceState.setPort(4, pCData.getValue(), 9);
        }
    }

    public void paintInstance(InstancePainter instancePainter) {
        Bounds bounds = instancePainter.getBounds();
        BitWidth bitWidth = (BitWidth)instancePainter.getAttributeValue(StdAttr.WIDTH);
        PCData pCData = PCData.get((InstanceState)instancePainter, bitWidth);
        GraphicsUtil.drawCenteredText((Graphics)instancePainter.getGraphics(), (String)("PC:" + StringUtil.toHexString((int)bitWidth.getWidth(), (int)pCData.getValue().toIntValue())), (int)(bounds.getX() + bounds.getWidth() / 2), (int)(bounds.getY() + 3 * bounds.getHeight() / 4));
        instancePainter.drawRectangle(instancePainter.getBounds(), "");
        Graphics graphics = instancePainter.getGraphics();
        graphics.setColor(Color.BLACK);
        instancePainter.drawClockSymbol(bounds.getX(), bounds.getY() + 30);
        instancePainter.drawPort(5, "", Direction.EAST);
        instancePainter.drawPort(0, "in", Direction.EAST);
        instancePainter.drawPort(4, "out", Direction.WEST);
        instancePainter.drawPort(1, "inc", Direction.NORTH);
        instancePainter.drawPort(2, "load", Direction.NORTH);
        instancePainter.drawPort(3, "reset", Direction.NORTH);
    }

    static Value nextValue(InstanceState instanceState, Value value) {
        int n;
        Value value2 = instanceState.getPortValue(4);
        BitWidth bitWidth = value2.getBitWidth();
        if (instanceState.getPortValue(3) == Value.TRUE) {
            n = 0;
        } else if (instanceState.getPortValue(2) == Value.TRUE) {
            Value value3 = instanceState.getPortValue(0);
            if (!value3.isFullyDefined()) {
                return value;
            }
            n = value3.toIntValue();
        } else if (instanceState.getPortValue(1) == Value.TRUE) {
            n = value.toIntValue() + 1;
        } else {
            return value;
        }
        return Value.createKnown((BitWidth)bitWidth, (int)n);
    }
}

