/*
 * Decompiled with CFR 0.152.
 */
package edu.gburg.nand2tetris;

import com.cburch.logisim.data.BitWidth;
import com.cburch.logisim.data.Value;
import com.cburch.logisim.instance.InstanceData;
import com.cburch.logisim.instance.InstanceState;
import com.cburch.logisim.instance.StdAttr;
import edu.gburg.nand2tetris.ALU;

class CPUData
implements InstanceData,
Cloneable {
    private Value lastClock;
    private Value regA;
    private Value regD;
    private Value regPC;
    private Value outM;
    private Value writeM;
    private Value addressM;

    public static CPUData get(InstanceState instanceState, BitWidth bitWidth) {
        CPUData cPUData = (CPUData)instanceState.getData();
        if (cPUData == null) {
            cPUData = new CPUData(null);
            instanceState.setData((InstanceData)cPUData);
        }
        return cPUData;
    }

    public CPUData(Value value) {
        this.lastClock = value;
        this.regA = Value.createKnown((BitWidth)BitWidth.create((int)16), (int)0);
        this.regD = Value.createKnown((BitWidth)BitWidth.create((int)16), (int)0);
        this.regPC = Value.createKnown((BitWidth)BitWidth.create((int)15), (int)0);
        this.outM = Value.createKnown((BitWidth)BitWidth.create((int)16), (int)0);
        this.writeM = Value.createKnown((BitWidth)BitWidth.create((int)1), (int)0);
        this.addressM = Value.createKnown((BitWidth)BitWidth.create((int)15), (int)0);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public boolean updateClock(Value value, Object object) {
        Value value2 = this.lastClock;
        this.lastClock = value;
        if (object == null || object == StdAttr.TRIG_RISING) {
            return value2 == Value.FALSE && value == Value.TRUE;
        }
        if (object == StdAttr.TRIG_FALLING) {
            return value2 == Value.TRUE && value == Value.FALSE;
        }
        if (object == StdAttr.TRIG_HIGH) {
            return value == Value.TRUE;
        }
        if (object == StdAttr.TRIG_LOW) {
            return value == Value.FALSE;
        }
        return value2 == Value.FALSE && value == Value.TRUE;
    }

    public Value getRegA() {
        return this.regA;
    }

    public Value getRegD() {
        return this.regD;
    }

    public Value getRegPC() {
        return this.regPC;
    }

    public Value getOut() {
        return this.outM;
    }

    public Value getWrite() {
        return this.writeM;
    }

    public Value getAddr() {
        return this.addressM;
    }

    public Value[] set(Value value, Value value2, Value value3, boolean bl) {
        Value[] valueArray = CPUData.compute(value, value2, value3, this.regA, this.regD, this.regPC, this.outM, bl);
        this.outM = valueArray[0];
        this.addressM = valueArray[1];
        this.writeM = valueArray[2];
        this.regPC = valueArray[3];
        this.regA = valueArray[4];
        this.regD = valueArray[5];
        return valueArray;
    }

    public static Value[] compute(Value value, Value value2, Value value3, Value value4, Value value5, Value value6, Value value7, boolean bl) {
        boolean bl2;
        boolean bl3;
        boolean bl4 = value.get(15) == Value.TRUE;
        long l = value.get(5).toIntValue() << 2 | value.get(4).toIntValue() << 1 | value.get(3).toIntValue() << 0;
        boolean bl5 = l == 4L || l == 5L || l == 6L || l == 7L;
        boolean bl6 = l == 2L || l == 3L || l == 6L || l == 7L;
        boolean bl7 = l == 1L || l == 3L || l == 5L || l == 7L;
        boolean bl8 = !bl4 || bl5 && bl4;
        boolean bl9 = bl6 && bl4;
        Value value8 = bl7 && bl4 ? Value.TRUE : Value.FALSE;
        Value value9 = value4;
        if (bl && bl8) {
            value4 = !bl4 ? value : value7;
        }
        Value value10 = value4;
        if (bl && bl9) {
            value5 = value7;
        }
        Value value11 = value5;
        Value value12 = value.get(12);
        Value value13 = value12 == Value.FALSE ? value4 : value2;
        Value value14 = value.get(11);
        Value value15 = value.get(10);
        Value value16 = value.get(9);
        Value value17 = value.get(8);
        Value value18 = value.get(7);
        Value value19 = value.get(6);
        Value[] valueArray = ALU.compute(value11, value13, value14, value15, value16, value17, value18, value19);
        value7 = valueArray[0];
        long l2 = value.get(2).toIntValue() << 2 | value.get(1).toIntValue() << 1 | value.get(0).toIntValue() << 0;
        boolean bl10 = valueArray[1] == Value.TRUE;
        boolean bl11 = valueArray[2] == Value.TRUE;
        boolean bl12 = bl11 || bl10;
        boolean bl13 = bl3 = bl4 && (l2 == 2L && bl10 || l2 == 5L && !bl10 || l2 == 4L && bl11 || l2 == 6L && bl12 || l2 == 1L && !bl12 || l2 == 3L && !bl11 || l2 == 7L);
        boolean bl14 = bl2 = !bl3;
        if (bl) {
            if (value3 == Value.TRUE) {
                value6 = Value.createKnown((BitWidth)value6.getBitWidth(), (int)0);
            } else if (bl13) {
                value6 = value9;
            } else if (bl2) {
                int n = value6.toIntValue();
                value6 = Value.createKnown((BitWidth)value6.getBitWidth(), (int)(n + 1));
            }
        }
        Value[] valueArray2 = new Value[]{value7, value10, value8, value6, value4, value5};
        return valueArray2;
    }
}

