/*
 * Decompiled with CFR 0.152.
 */
package edu.gburg.nand2tetris;

import com.cburch.logisim.data.Attribute;
import com.cburch.logisim.data.BitWidth;
import com.cburch.logisim.data.Bounds;
import com.cburch.logisim.data.Direction;
import com.cburch.logisim.data.Value;
import com.cburch.logisim.instance.InstanceFactory;
import com.cburch.logisim.instance.InstancePainter;
import com.cburch.logisim.instance.InstanceState;
import com.cburch.logisim.instance.Port;
import com.cburch.logisim.instance.StdAttr;
import com.cburch.logisim.util.GraphicsUtil;
import java.awt.Color;
import java.awt.Graphics;

class ALU
extends InstanceFactory {
    private static final int ALU_WIDTH = 140;
    private static final int ALU_HEIGHT = 80;
    private static final int ULX = -140;
    private static final int ULY = -40;
    private static final int TOP_SEP = 20;
    private static final int BOT_SEP = 50;
    private static final int LEFT_SEP = 30;
    private static final int IN_X = 0;
    private static final int IN_Y = 1;
    private static final int IN_ZX = 2;
    private static final int IN_NX = 3;
    private static final int IN_ZY = 4;
    private static final int IN_NY = 5;
    private static final int IN_F = 6;
    private static final int IN_NO = 7;
    private static final int OUT = 8;
    private static final int OUT_ZR = 9;
    private static final int OUT_NG = 10;

    ALU() {
        super("ALU");
        this.setAttributes(new Attribute[]{StdAttr.WIDTH}, new Object[]{BitWidth.create((int)8)});
        this.setOffsetBounds(Bounds.create((int)-140, (int)-40, (int)140, (int)80));
        Port[] portArray = new Port[]{new Port(-140, -10, "input", StdAttr.WIDTH), new Port(-140, 20, "input", StdAttr.WIDTH), new Port(-120, -40, "input", 1), new Port(-100, -40, "input", 1), new Port(-80, -40, "input", 1), new Port(-60, -40, "input", 1), new Port(-40, -40, "input", 1), new Port(-20, -40, "input", 1), new Port(0, 0, "output", StdAttr.WIDTH), new Port(-90, 40, "output", 1), new Port(-40, 40, "output", 1)};
        this.setPorts(portArray);
    }

    public void propagate(InstanceState instanceState) {
        Value value = ALU.nextValue(instanceState);
        instanceState.setPort(8, value, value.getWidth() + 1);
        Value value2 = value.toIntValue() == 0 ? Value.TRUE : Value.FALSE;
        instanceState.setPort(9, value2, value.getWidth() + 2);
        int n = value.getWidth() - 1;
        Value value3 = value.get(n);
        instanceState.setPort(10, value3, value.getWidth() + 2);
    }

    public void paintInstance(InstancePainter instancePainter) {
        Bounds bounds = instancePainter.getBounds();
        instancePainter.drawRectangle(instancePainter.getBounds(), "");
        Graphics graphics = instancePainter.getGraphics();
        graphics.setColor(Color.BLACK);
        GraphicsUtil.drawCenteredText((Graphics)graphics, (String)"ALU", (int)(bounds.getX() + bounds.getWidth() / 2), (int)(bounds.getY() + bounds.getHeight() / 2));
        instancePainter.drawPort(0, "x", Direction.EAST);
        instancePainter.drawPort(1, "y", Direction.EAST);
        instancePainter.drawPort(2, "zx", Direction.NORTH);
        instancePainter.drawPort(3, "nx", Direction.NORTH);
        instancePainter.drawPort(4, "zy", Direction.NORTH);
        instancePainter.drawPort(5, "ny", Direction.NORTH);
        instancePainter.drawPort(6, "f", Direction.NORTH);
        instancePainter.drawPort(7, "no", Direction.NORTH);
        instancePainter.drawPort(8, "out", Direction.WEST);
        instancePainter.drawPort(9, "zr", Direction.SOUTH);
        instancePainter.drawPort(10, "ng", Direction.SOUTH);
    }

    static Value nextValue(InstanceState instanceState) {
        int n;
        Value value = instanceState.getPortValue(8);
        BitWidth bitWidth = value.getBitWidth();
        Value value2 = instanceState.getPortValue(0);
        Value value3 = instanceState.getPortValue(1);
        int n2 = value2.toIntValue();
        if (instanceState.getPortValue(2) == Value.TRUE) {
            n2 = 0;
        }
        if (instanceState.getPortValue(3) == Value.TRUE) {
            n2 ^= 0xFFFFFFFF;
        }
        int n3 = value3.toIntValue();
        if (instanceState.getPortValue(4) == Value.TRUE) {
            n3 = 0;
        }
        if (instanceState.getPortValue(5) == Value.TRUE) {
            n3 ^= 0xFFFFFFFF;
        }
        int n4 = n = instanceState.getPortValue(6) == Value.TRUE ? n2 + n3 : n2 & n3;
        if (instanceState.getPortValue(7) == Value.TRUE) {
            n ^= 0xFFFFFFFF;
        }
        return Value.createKnown((BitWidth)bitWidth, (int)n);
    }

    public static Value[] compute(Value value, Value value2, Value value3, Value value4, Value value5, Value value6, Value value7, Value value8) {
        Value value9;
        Value value10;
        int n;
        if (value3 == Value.TRUE) {
            value = Value.createKnown((BitWidth)value.getBitWidth(), (int)0);
        }
        if (value4 == Value.TRUE) {
            value = value.not();
        }
        if (value5 == Value.TRUE) {
            value2 = Value.createKnown((BitWidth)value2.getBitWidth(), (int)0);
        }
        if (value6 == Value.TRUE) {
            value2 = value2.not();
        }
        if (value7 == Value.TRUE) {
            int n2 = value.toIntValue();
            int n3 = value2.toIntValue();
            n = n2 + n3;
            value10 = Value.createKnown((BitWidth)value.getBitWidth(), (int)n);
        } else {
            value10 = value.and(value2);
        }
        if (value8 == Value.TRUE) {
            value10 = value10.not();
        }
        Value value11 = value10.equals((Object)(value9 = Value.createKnown((BitWidth)value10.getBitWidth(), (int)0))) ? Value.TRUE : Value.FALSE;
        n = value10.getWidth() - 1;
        Value value12 = value10.get(n);
        Value[] valueArray = new Value[]{value10, value11, value12};
        return valueArray;
    }
}

