/*
 * Decompiled with CFR 0.152.
 */
package cs1.android;

import android.app.AlertDialog;
import android.view.WindowManager;
import cs1.android.AndroidApp;
import cs1.android.Circle;
import cs1.android.Fling;
import cs1.android.Image;
import cs1.android.Line;
import cs1.android.Point;
import cs1.android.Reader;
import cs1.android.ReaderChar;
import cs1.android.ReaderFloat;
import cs1.android.ReaderInt;
import cs1.android.ReaderKeypad;
import cs1.android.ReaderList;
import cs1.android.Rectangle;
import cs1.android.Shape;
import cs1.android.Square;
import cs1.android.Text;
import cs1.android.Touch;
import cs1.android.Triangle;
import cs1.android.Utils;
import cs1.android.state;

public class canvas {
    private static void drawObject(Shape shape, String color) {
        shape.setColor(color);
        state.view.drawObject(shape);
    }

    public static Point drawPoint(double x, double y) {
        return canvas.drawPoint(x, y, "white");
    }

    public static Point drawPoint(double x, double y, String color) {
        Point point = new Point(x, y);
        canvas.drawObject(point, color);
        return point;
    }

    public static Line drawLine(double x1, double y1, double x2, double y2) {
        return canvas.drawLine(x1, y1, x2, y2, "white");
    }

    public static Line drawLine(double x1, double y1, double x2, double y2, String color) {
        Line line = new Line(x1, y1, x2, y2);
        canvas.drawObject(line, color);
        return line;
    }

    public static Circle drawCircle(double x, double y, double radius) {
        return canvas.drawCircle(x, y, radius, "white");
    }

    public static Circle drawCircle(double x, double y, double radius, String color) {
        Circle circle = new Circle(x, y, radius);
        canvas.drawObject(circle, color);
        return circle;
    }

    public static Rectangle drawRectangle(double x, double y, double w, double h) {
        return canvas.drawRectangle(x, y, w, h, "white");
    }

    public static Rectangle drawRectangle(double x, double y, double w, double h, String color) {
        Rectangle rect = new Rectangle(x, y, w, h);
        canvas.drawObject(rect, color);
        return rect;
    }

    public static Square drawSquare(double x, double y, double s) {
        return canvas.drawSquare(x, y, s, "white");
    }

    public static Square drawSquare(double x, double y, double s, String color) {
        Square square = new Square(x, y, s);
        canvas.drawObject(square, color);
        return square;
    }

    public static Triangle drawTriangle(double x1, double y1, double x2, double y2, double x3, double y3) {
        return canvas.drawTriangle(x1, y1, x2, y2, x3, y3, "white");
    }

    public static Triangle drawTriangle(double x1, double y1, double x2, double y2, double x3, double y3, String color) {
        Triangle tri = new Triangle(x1, y1, x2, y2, x3, y3);
        canvas.drawObject(tri, color);
        return tri;
    }

    public static Text drawText(double x, double y, String str) {
        return canvas.drawText(x, y, str, 12, "white");
    }

    public static Text drawText(double x, double y, String str, int size) {
        return canvas.drawText(x, y, str, size, "white");
    }

    public static Text drawText(double x, double y, String str, String color) {
        return canvas.drawText(x, y, str, 12, color);
    }

    public static Text drawText(double x, double y, String str, int size, String color) {
        Text text = new Text(x, y, str, size);
        canvas.drawObject(text, color);
        return text;
    }

    public static Text drawText(double x, double y, char ch) {
        String str = "" + ch;
        return canvas.drawText(x, y, str, 12, "white");
    }

    public static Text drawText(double x, double y, char ch, int size) {
        String str = "" + ch;
        return canvas.drawText(x, y, str, size, "white");
    }

    public static Text drawText(double x, double y, char ch, String color) {
        String str = "" + ch;
        return canvas.drawText(x, y, str, 12, color);
    }

    public static Text drawText(double x, double y, char ch, int size, String color) {
        String str = "" + ch;
        return canvas.drawText(x, y, str, size, color);
    }

    public static Text drawText(double x, double y, int num) {
        String str = String.valueOf(num);
        return canvas.drawText(x, y, str, 12, "white");
    }

    public static Text drawText(double x, double y, int num, int size) {
        String str = String.valueOf(num);
        return canvas.drawText(x, y, str, size, "white");
    }

    public static Text drawText(double x, double y, int num, String color) {
        String str = String.valueOf(num);
        return canvas.drawText(x, y, str, 12, color);
    }

    public static Text drawText(double x, double y, int num, int size, String color) {
        String str = String.valueOf(num);
        return canvas.drawText(x, y, str, size, color);
    }

    public static Text drawText(double x, double y, double num) {
        String str = String.valueOf(num);
        return canvas.drawText(x, y, str, 12, "white");
    }

    public static Text drawText(double x, double y, double num, int size) {
        String str = String.valueOf(num);
        return canvas.drawText(x, y, str, size, "white");
    }

    public static Text drawText(double x, double y, double num, String color) {
        String str = String.valueOf(num);
        return canvas.drawText(x, y, str, 12, color);
    }

    public static Text drawText(double x, double y, double num, int size, String color) {
        String str = String.valueOf(num);
        return canvas.drawText(x, y, str, size, color);
    }

    public static Image drawImage(double x, double y, String filename) {
        Image image = new Image(x, y, filename);
        state.view.drawObject(image);
        return image;
    }

    public static String getRandomColor() {
        return Utils.getRandomColor();
    }

    public static int getWidth() {
        WindowManager mWinMgr = (WindowManager)state.context.getSystemService("window");
        int displayWidth = mWinMgr.getDefaultDisplay().getWidth();
        return displayWidth;
    }

    public static int getHeight() {
        WindowManager mWinMgr = (WindowManager)state.context.getSystemService("window");
        int displayHeight = mWinMgr.getDefaultDisplay().getHeight();
        return displayHeight;
    }

    public static void clear() {
        state.view.clear();
    }

    public static void setBackground(String color) {
        state.view.setBackgroundColorDeferred(color);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sleep(double secs) {
        AndroidApp androidApp = state.app;
        synchronized (androidApp) {
            try {
                state.app.wait((int)(1000.0 * secs));
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public static String readString(String prompt) {
        ReaderKeypad reader = new ReaderKeypad(state.context);
        String str = canvas.readInput(reader, prompt);
        if (str == null) {
            System.out.println("readSring null input; retrying...");
            return canvas.readString(prompt);
        }
        return str;
    }

    public static char readChar(String prompt) {
        ReaderChar reader = new ReaderChar(state.context);
        String str = canvas.readInput(reader, prompt);
        if (str == null) {
            System.out.println("readChar null input; retrying...");
            return canvas.readChar(prompt);
        }
        return str.charAt(0);
    }

    public static int readInt(String prompt) {
        ReaderInt reader = new ReaderInt(state.context);
        String str = canvas.readInput(reader, prompt);
        try {
            int value = Integer.parseInt(str);
            return value;
        }
        catch (Exception e) {
            System.out.println("readInt parseInt failed; retrying...");
            return canvas.readInt(prompt);
        }
    }

    public static float readFloat(String prompt) {
        ReaderFloat reader = new ReaderFloat(state.context);
        String str = canvas.readInput(reader, prompt);
        try {
            float value = Float.parseFloat(str);
            return value;
        }
        catch (Exception e) {
            System.out.println("readFloat parseFloat failed; retrying...");
            return canvas.readFloat(prompt);
        }
    }

    public static String readSelection(String prompt, String ... items) {
        ReaderList reader = new ReaderList(state.context);
        reader.loadItems(items);
        String input = canvas.readInput(reader, prompt);
        if (input == null) {
            System.out.println("readSelection (String) null input; retrying...");
            return canvas.readSelection(prompt, items);
        }
        return input;
    }

    public static int readSelection(String prompt, Integer ... items) {
        ReaderList reader = new ReaderList(state.context);
        reader.loadItems(items);
        String str = canvas.readInput(reader, prompt);
        try {
            int value = Integer.parseInt(str);
            return value;
        }
        catch (Exception e) {
            System.out.println("readSelection (Integer) parseInt failed; retrying...");
            return canvas.readSelection(prompt, items);
        }
    }

    public static float readSelection(String prompt, Float ... items) {
        ReaderList reader = new ReaderList(state.context);
        reader.loadItems(items);
        String str = canvas.readInput(reader, prompt);
        try {
            float value = Float.parseFloat(str);
            return value;
        }
        catch (Exception e) {
            System.out.println("readSelection (Float) parseFloat failed; retrying...");
            return canvas.readSelection(prompt, items);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readInput(Reader reader, String prompt) {
        if (state.dialog == null) {
            state.reader = reader;
            state.reader.setPrompt(prompt);
            state.waitType = state.WAIT_TYPE.DIALOG;
        } else {
            AlertDialog alertDialog = state.dialog;
            synchronized (alertDialog) {
                state.reader = reader;
                state.reader.setPrompt(prompt);
                state.waitType = state.WAIT_TYPE.DIALOG;
            }
        }
        String input = null;
        AndroidApp androidApp = state.app;
        synchronized (androidApp) {
            try {
                state.app.wait();
                input = reader.getText();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        state.waitType = state.WAIT_TYPE.NONE;
        state.reader = null;
        return input;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Touch waitForTouch() {
        state.waitType = state.WAIT_TYPE.TOUCH;
        Touch touch = null;
        AndroidApp androidApp = state.app;
        synchronized (androidApp) {
            try {
                state.app.wait();
                touch = state.touch;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        state.touch = null;
        state.waitType = state.WAIT_TYPE.NONE;
        return touch;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Fling waitForFling() {
        state.waitType = state.WAIT_TYPE.FLING;
        Fling fling = null;
        AndroidApp androidApp = state.app;
        synchronized (androidApp) {
            try {
                state.app.wait();
                fling = state.fling;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        state.fling = null;
        state.waitType = state.WAIT_TYPE.NONE;
        return fling;
    }
}

