/*
 * Decompiled with CFR 0.152.
 */
package cs1.android;

import android.graphics.Canvas;
import android.graphics.Path;
import cs1.android.Point;
import cs1.android.Shape;

public class Triangle
extends Shape {
    private Point p1;
    private Point p2;
    private Point p3;

    public Triangle(double x1, double y1, double x2, double y2, double x3, double y3) {
        this(new Point(x1, y1), new Point(x2, y2), new Point(x3, y3));
    }

    public Triangle(Point p, Point q, Point r) {
        this.p1 = new Point(p);
        this.p2 = new Point(q);
        this.p3 = new Point(r);
    }

    public Point getP1() {
        return new Point(this.p1);
    }

    public Point getP2() {
        return new Point(this.p2);
    }

    public Point getP3() {
        return new Point(this.p3);
    }

    @Override
    public Point getCenter() {
        double cx = (this.p1.X + this.p2.X + this.p3.X) / 3.0;
        double cy = (this.p1.Y + this.p2.Y + this.p3.Y) / 3.0;
        return new Point(cx, cy);
    }

    @Override
    public void move(double dx, double dy) {
        this.p1.move(dx, dy);
        this.p2.move(dx, dy);
        this.p3.move(dx, dy);
    }

    @Override
    public boolean contains(Point point) {
        Point p1 = new Point(this.p1);
        Point p2 = new Point(this.p2.X - this.p1.X, this.p2.Y - this.p1.Y);
        Point p3 = new Point(this.p3.X - this.p1.X, this.p3.Y - this.p1.Y);
        double detP1P2 = p1.X * p2.Y - p1.Y * p2.X;
        double detP1P3 = p1.X * p3.Y - p1.Y * p3.X;
        double detP2P3 = p2.X * p3.Y - p2.Y * p3.X;
        double detPtP3 = point.X * p3.Y - point.Y * p3.X;
        double detPtP2 = point.X * p2.Y - point.Y * p2.X;
        double a = (detPtP3 - detP1P3) / detP2P3;
        double b = -(detPtP2 - detP1P2) / detP2P3;
        return a > 0.0 && b > 0.0 && a + b < 1.0;
    }

    @Override
    public void draw(Canvas canvas2) {
        Path path = new Path();
        path.setFillType(Path.FillType.EVEN_ODD);
        path.moveTo((float)this.p1.X, (float)this.p1.Y);
        path.lineTo((float)this.p2.X, (float)this.p2.Y);
        path.lineTo((float)this.p3.X, (float)this.p3.Y);
        path.lineTo((float)this.p1.X, (float)this.p1.Y);
        path.close();
        Shape.paint.setColor(this.color);
        canvas2.drawPath(path, Shape.paint);
    }
}

