/*
 * Decompiled with CFR 0.152.
 */
package cs1.android;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import cs1.android.Point;
import cs1.android.Shape;

public class Text
extends Shape {
    public static final int DEFAULT_SIZE = 12;
    private String text;
    private int size;
    private int yOffset;
    private Point center;

    public Text(double x, double y, String t) {
        this(new Point(x, y), t, 12);
    }

    public Text(double x, double y, String t, int s) {
        this(new Point(x, y), t, s);
    }

    public Text(Point cen, String t) {
        this(cen, t, 12);
    }

    public Text(Point cen, String t, int s) {
        this.text = t;
        this.size = s;
        this.center = new Point(cen);
        Shape.paint.setTextSize((float)this.size);
        Rect bounds = new Rect();
        if (this.text.toLowerCase().equals(this.text)) {
            Shape.paint.getTextBounds("x", 0, 1, bounds);
        } else {
            Shape.paint.getTextBounds("X", 0, 1, bounds);
        }
        this.yOffset = bounds.height() / 2;
    }

    public String getText() {
        return this.text;
    }

    @Override
    public Point getCenter() {
        return new Point(this.center);
    }

    @Override
    public void move(double dx, double dy) {
        this.center.move(dx, dy);
    }

    @Override
    public boolean contains(Point point) {
        return false;
    }

    @Override
    public void draw(Canvas canvas2) {
        Shape.paint.setColor(this.color);
        Shape.paint.setTextAlign(Paint.Align.CENTER);
        Shape.paint.setTextSize((float)this.size);
        canvas2.drawText(this.text, (float)this.center.X, (float)this.center.Y + (float)this.yOffset, Shape.paint);
    }
}

