/*
 * Decompiled with CFR 0.152.
 */
package cs1.android;

import android.graphics.Canvas;
import android.graphics.Paint;
import cs1.android.Point;
import cs1.android.Utils;
import cs1.android.state;

public abstract class Shape {
    public static final String DEFAULT_COLOR = "white";
    private static final int DEFAULT_COLOR_INT = Utils.getColor("white");
    protected int color;
    private String label;
    protected static Paint paint = new Paint(1);

    public Shape() {
        this.color = DEFAULT_COLOR_INT;
        this.label = "";
    }

    protected Shape(Shape s) {
        this.color = s.color;
        this.label = s.label;
    }

    public int getColor() {
        return this.color;
    }

    public void setColor(String name) {
        this.setColor(Utils.getColor(name));
    }

    public void setColor(int c) {
        this.color = c;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void erase() {
        state.view.eraseObject(this);
    }

    public void draw() {
        state.view.drawObject(this);
    }

    public abstract void draw(Canvas var1);

    public abstract Point getCenter();

    public abstract void move(double var1, double var3);

    public abstract boolean contains(Point var1);

    public static double distance(Shape s1, Shape s2) {
        return Math.sqrt(Shape.distance_squared(s1, s2));
    }

    public static double distance_squared(Shape s1, Shape s2) {
        return Point.distance_squared(s1.getCenter(), s2.getCenter());
    }
}

