/*
 * Decompiled with CFR 0.152.
 */
package cs1.android;

import android.graphics.Canvas;
import cs1.android.Point;
import cs1.android.Shape;

public class Rectangle
extends Shape {
    private Point upperLeft;
    private Point lowerRight;

    public Rectangle(double cx, double cy, double w, double h) {
        this(new Point(cx, cy), w, h);
    }

    public Rectangle(Point cen, double w, double h) {
        this.upperLeft = new Point(cen.X - w / 2.0, cen.Y - h / 2.0);
        this.lowerRight = new Point(cen.X + w / 2.0, cen.Y + h / 2.0);
    }

    @Override
    public Point getCenter() {
        double x = (this.upperLeft.X + this.lowerRight.X) / 2.0;
        double y = (this.upperLeft.Y + this.lowerRight.Y) / 2.0;
        return new Point(x, y);
    }

    public double getWidth() {
        return this.lowerRight.X - this.upperLeft.X;
    }

    public double getHeight() {
        return this.lowerRight.Y - this.upperLeft.Y;
    }

    @Override
    public void move(double dx, double dy) {
        this.upperLeft.move(dx, dy);
        this.lowerRight.move(dx, dy);
    }

    @Override
    public boolean contains(Point point) {
        return this.upperLeft.getX() < point.getX() && point.getX() < this.lowerRight.getX() && this.upperLeft.getY() < point.getY() && point.getY() < this.lowerRight.getY();
    }

    @Override
    public void draw(Canvas canvas2) {
        Shape.paint.setColor(this.color);
        canvas2.drawRect((float)this.upperLeft.X, (float)this.upperLeft.Y, (float)this.lowerRight.X, (float)this.lowerRight.Y, Shape.paint);
    }
}

