/*
 * Decompiled with CFR 0.152.
 */
package cs1.android;

import android.graphics.Canvas;
import cs1.android.Shape;

public class Point
extends Shape {
    public double X;
    public double Y;

    public Point(double xx, double yy) {
        this.X = xx;
        this.Y = yy;
    }

    protected Point(Point p) {
        super(p);
        this.X = p.X;
        this.Y = p.Y;
    }

    public double getX() {
        return this.X;
    }

    public double getY() {
        return this.Y;
    }

    @Override
    public Point getCenter() {
        return new Point(this.X, this.Y);
    }

    @Override
    public void move(double dx, double dy) {
        this.X += dx;
        this.Y += dy;
    }

    @Override
    public void draw(Canvas canvas2) {
        Shape.paint.setColor(this.color);
        canvas2.drawPoint((float)this.X, (float)this.Y, Shape.paint);
    }

    @Override
    public boolean contains(Point point) {
        return false;
    }

    public static double distance_squared(double x1, double y1, double x2, double y2) {
        double dx = x1 - x2;
        double dy = y1 - y2;
        return dx * dx + dy * dy;
    }

    public static double distance_squared(Point p1, Point p2) {
        return Point.distance_squared(p1.X, p1.Y, p2.X, p2.Y);
    }

    public static double distance(double x1, double y1, double x2, double y2) {
        return Math.sqrt(Point.distance_squared(x1, y1, x2, y2));
    }

    public static double distance(Point p1, Point p2) {
        return Point.distance(p1.X, p1.Y, p2.X, p2.Y);
    }
}

