/*
 * Decompiled with CFR 0.152.
 */
package cs1.android;

import android.graphics.Canvas;
import cs1.android.Point;
import cs1.android.Shape;

public class Line
extends Shape {
    private double TOUCH_DIST_SQR = 4.0;
    private Point p1;
    private Point p2;

    public Line(double x1, double y1, double x2, double y2) {
        this(new Point(x1, y1), new Point(x2, y2));
    }

    public Line(Point p, Point q) {
        this.p1 = new Point(p);
        this.p2 = new Point(q);
    }

    public Point getP1() {
        return new Point(this.p1);
    }

    public Point getP2() {
        return new Point(this.p2);
    }

    @Override
    public Point getCenter() {
        double cx = (this.p1.X + this.p2.X) / 2.0;
        double cy = (this.p1.Y + this.p2.Y) / 2.0;
        return new Point(cx, cy);
    }

    @Override
    public void move(double dx, double dy) {
        this.p1.move(dx, dy);
        this.p2.move(dx, dy);
    }

    @Override
    public boolean contains(Point p0) {
        double x1x2 = this.p2.X - this.p1.X;
        double y0y1 = this.p1.Y - p0.Y;
        double x0x1 = this.p1.X - p0.X;
        double y1y2 = this.p2.Y - this.p1.Y;
        double numer = x1x2 * y0y1 - x0x1 * y1y2;
        double denom = x1x2 * x1x2 + y1y2 * y1y2;
        double dist_sq = numer * numer / denom;
        return dist_sq < this.TOUCH_DIST_SQR;
    }

    @Override
    public void draw(Canvas canvas2) {
        Shape.paint.setColor(this.color);
        canvas2.drawLine((float)this.p1.X, (float)this.p1.Y, (float)this.p2.X, (float)this.p2.Y, Shape.paint);
    }
}

