/*
 * Decompiled with CFR 0.152.
 */
package cs1.android;

import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import cs1.android.Point;
import cs1.android.Shape;
import cs1.android.state;
import java.util.HashMap;

public class Image
extends Shape {
    private static HashMap<String, Bitmap> imageCache = new HashMap();
    private Point upperLeft;
    private Bitmap image;
    private String filename;

    public Image(double x, double y, String filename) {
        this(new Point(x, y), filename);
    }

    public Image(Point cen, String name) {
        this.filename = name;
        this.image = imageCache.get(this.filename);
        if (this.image == null) {
            String basename = this.filename.substring(0, this.filename.indexOf(46));
            int imageID = state.context.getResources().getIdentifier(basename, "drawable", state.context.getPackageName());
            this.image = BitmapFactory.decodeResource((Resources)state.context.getResources(), (int)imageID);
            imageCache.put(this.filename, this.image);
        }
        this.upperLeft = new Point(cen.X - (double)(this.image.getWidth() / 2), cen.Y - (double)(this.image.getHeight() / 2));
    }

    public int getWidth() {
        return this.image.getWidth();
    }

    public int getHeight() {
        return this.image.getHeight();
    }

    public String getName() {
        return this.filename;
    }

    @Override
    public Point getCenter() {
        double x = this.upperLeft.X + (double)(this.image.getWidth() / 2);
        double y = this.upperLeft.Y + (double)(this.image.getHeight() / 2);
        return new Point(x, y);
    }

    @Override
    public void move(double dx, double dy) {
        this.upperLeft.move(dx, dy);
    }

    @Override
    public boolean contains(Point point) {
        double dx = point.X - this.upperLeft.X;
        double dy = point.Y - this.upperLeft.Y;
        return dx > 0.0 && dx < (double)this.image.getWidth() && dy > 0.0 && dy < (double)this.image.getHeight();
    }

    @Override
    public void draw(Canvas canvas2) {
        canvas2.drawBitmap(this.image, (float)this.upperLeft.X, (float)this.upperLeft.Y, null);
    }
}

