/*
 * Decompiled with CFR 0.152.
 */
package cs1.android;

import android.graphics.Canvas;
import cs1.android.Point;
import cs1.android.Shape;

public class Circle
extends Shape {
    private Point center;
    private double radius;

    public Circle(double x, double y, double r) {
        this.center = new Point(x, y);
        this.radius = r;
    }

    public Circle(Point cen, double r) {
        this.center = new Point(cen);
        this.radius = r;
    }

    public Circle(Point cen, Point pt) {
        double dx = cen.X - pt.X;
        double dy = cen.Y - pt.Y;
        double r = Math.sqrt(dx * dx + dy * dy);
        this.center = new Point(cen);
        this.radius = r;
    }

    @Override
    public Point getCenter() {
        return new Point(this.center);
    }

    public double getRadius() {
        return this.radius;
    }

    @Override
    public void move(double dx, double dy) {
        this.center.move(dx, dy);
    }

    @Override
    public boolean contains(Point point) {
        return Point.distance_squared(this.center, point) < this.radius * this.radius;
    }

    @Override
    public void draw(Canvas canvas2) {
        Shape.paint.setColor(this.color);
        canvas2.drawCircle((float)this.center.X, (float)this.center.Y, (float)this.radius, Shape.paint);
    }
}

