/*
 * Decompiled with CFR 0.152.
 */
package cs1.android;

import android.content.Context;
import android.graphics.Canvas;
import android.view.View;
import cs1.android.Point;
import cs1.android.Shape;
import cs1.android.Utils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class AndroidAppView
extends View {
    private List<Shape> shapes = Collections.synchronizedList(new ArrayList());
    private int bgColor = Utils.getColor("black");

    public AndroidAppView(Context context) {
        super(context);
        this.setFocusable(true);
        this.setFocusableInTouchMode(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onDraw(Canvas c) {
        this.setBackgroundColor(this.bgColor);
        List<Shape> list = this.shapes;
        synchronized (list) {
            for (Shape shape : this.shapes) {
                shape.draw(c);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawObject(Shape object) {
        List<Shape> list = this.shapes;
        synchronized (list) {
            if (!this.shapes.contains(object)) {
                this.shapes.add(object);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void eraseObject(Shape object) {
        List<Shape> list = this.shapes;
        synchronized (list) {
            this.shapes.remove(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        List<Shape> list = this.shapes;
        synchronized (list) {
            this.shapes.clear();
        }
    }

    public void setBackgroundColorDeferred(String color) {
        this.bgColor = Utils.getColor(color);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Shape getShape(Point point) {
        Shape shape = null;
        List<Shape> list = this.shapes;
        synchronized (list) {
            int i = 0;
            while (i < this.shapes.size()) {
                Shape currShape = this.shapes.get(i);
                if (currShape.contains(point)) {
                    shape = currShape;
                }
                ++i;
            }
        }
        return shape;
    }
}

