/*
 * Decompiled with CFR 0.152.
 */
package cs1.android;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import cs1.android.AndroidApp;
import cs1.android.AndroidAppView;
import cs1.android.Fling;
import cs1.android.Point;
import cs1.android.Reader;
import cs1.android.Touch;
import cs1.android.state;

public class AndroidAppCanvas
extends Activity {
    private GestureDetector gestureDetector;

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.getWindow().setFlags(1024, 1024);
        this.requestWindowFeature(1);
        state.view = new AndroidAppView((Context)this);
        this.setContentView(state.view);
        state.view.requestFocus();
        state.context = this;
        final int delay = state.frameRate;
        final Handler handler = new Handler();
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                state.view.invalidate();
                if (state.reader != null) {
                    Reader reader = state.reader;
                    synchronized (reader) {
                        if (state.waitType == state.WAIT_TYPE.DIALOG && !state.reader.isShown()) {
                            try {
                                state.reader.show();
                            }
                            catch (Exception e) {
                                System.out.println("Showing input dialog failed; waiting for next cycle...");
                                state.dialog = null;
                            }
                        }
                    }
                }
                handler.postDelayed((Runnable)this, (long)delay);
            }
        };
        handler.postDelayed(runnable, (long)delay);
        state.view.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                return AndroidAppCanvas.this.gestureDetector.onTouchEvent(event);
            }
        });
        this.gestureDetector = new GestureDetector((GestureDetector.OnGestureListener)new GestureDetector.SimpleOnGestureListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean onDoubleTap(MotionEvent e) {
                if (state.waitType != state.WAIT_TYPE.TOUCH) {
                    return true;
                }
                state.touch = new Touch(e.getX(), e.getY(), 2);
                state.touch.setShape(state.view.getShape(new Point(e.getX(), e.getY())));
                AndroidApp androidApp = state.app;
                synchronized (androidApp) {
                    state.app.notify();
                }
                state.view.invalidate();
                return true;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean onSingleTapConfirmed(MotionEvent e) {
                if (state.waitType != state.WAIT_TYPE.TOUCH) {
                    return true;
                }
                state.touch = new Touch(e.getX(), e.getY(), 1);
                state.touch.setShape(state.view.getShape(new Point(e.getX(), e.getY())));
                AndroidApp androidApp = state.app;
                synchronized (androidApp) {
                    state.app.notify();
                }
                state.view.invalidate();
                return true;
            }

            public boolean onDown(MotionEvent e) {
                return true;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean onFling(MotionEvent e1, MotionEvent e2, float vx, float vy) {
                if (state.waitType != state.WAIT_TYPE.FLING) {
                    return true;
                }
                state.fling = new Fling(e1.getX(), e1.getY(), e2.getX(), e2.getY(), vx, vy);
                state.fling.setShape(state.view.getShape(new Point(e1.getX(), e1.getY())));
                AndroidApp androidApp = state.app;
                synchronized (androidApp) {
                    state.app.notify();
                }
                state.view.invalidate();
                return true;
            }
        });
        this.gestureDetector.setIsLongpressEnabled(true);
        Thread appThread = new Thread(state.app);
        appThread.start();
    }
}

