/*
 * Decompiled with CFR 0.152.
 */
package edu.gburg.nand2tetris;

import com.cburch.logisim.data.Attribute;
import com.cburch.logisim.data.BitWidth;
import com.cburch.logisim.data.Bounds;
import com.cburch.logisim.data.Direction;
import com.cburch.logisim.data.Value;
import com.cburch.logisim.instance.InstanceFactory;
import com.cburch.logisim.instance.InstancePainter;
import com.cburch.logisim.instance.InstanceState;
import com.cburch.logisim.instance.Port;
import com.cburch.logisim.instance.StdAttr;
import edu.gburg.nand2tetris.ScreenData;
import java.awt.Color;
import java.awt.Graphics;

class Screen
extends InstanceFactory {
    private static final int SCR_WIDTH = 540;
    private static final int SCR_HEIGHT = 280;
    private static final int ULX = -540;
    private static final int ULY = -140;
    private static final int LEFT_SEP = 10;
    private static final int IN = 0;
    private static final int IN_ADDR = 1;
    private static final int IN_LOAD = 2;
    private static final int OUT = 3;
    private static final int CK = 4;
    private static final int NUM_PORTS = 5;

    public Screen() {
        super("Screen");
        this.setOffsetBounds(Bounds.create((int)-540, (int)-140, (int)540, (int)280));
        this.setAttributes(new Attribute[]{StdAttr.WIDTH, StdAttr.EDGE_TRIGGER}, new Object[]{BitWidth.create((int)16), StdAttr.TRIG_RISING});
        Port[] portArray = new Port[]{new Port(-540, 0, "input", StdAttr.WIDTH), new Port(-540, 30, "input", 13), new Port(-540, 60, "input", 1), new Port(0, 0, "output", StdAttr.WIDTH), new Port(-540, -130, "input", 1)};
        this.setPorts(portArray);
    }

    public void propagate(InstanceState instanceState) {
        BitWidth bitWidth = (BitWidth)instanceState.getAttributeValue(StdAttr.WIDTH);
        ScreenData screenData = ScreenData.get(instanceState, bitWidth);
        Object object = instanceState.getAttributeValue(StdAttr.EDGE_TRIGGER);
        boolean bl = screenData.updateClock(instanceState.getPortValue(4), object);
        Value value = instanceState.getPortValue(3);
        BitWidth bitWidth2 = value.getBitWidth();
        Value value2 = instanceState.getPortValue(1);
        if (!value2.isFullyDefined()) {
            Value value3 = Value.createKnown((BitWidth)bitWidth2, (int)0);
            instanceState.setPort(3, value3, 9);
        } else if (bl) {
            Value value4 = screenData.getValue(value2);
            if (value4 == null) {
                value4 = Value.createKnown((BitWidth)bitWidth2, (int)0);
            }
            instanceState.setPort(3, value4, 9);
            if (instanceState.getPortValue(2) == Value.TRUE) {
                Value value5 = instanceState.getPortValue(0);
                if (!value5.isFullyDefined()) {
                    value5 = Value.createError((BitWidth)bitWidth2);
                }
                screenData.setValue(value5, value2);
            }
        }
    }

    public void paintInstance(InstancePainter instancePainter) {
        Bounds bounds = instancePainter.getNominalBounds();
        instancePainter.drawRectangle(bounds, "");
        Graphics graphics = instancePainter.getGraphics();
        graphics.setColor(Color.BLACK);
        instancePainter.drawClockSymbol(bounds.getX(), bounds.getY() + 10);
        instancePainter.drawPort(4, "", Direction.EAST);
        instancePainter.drawPort(0, "I", Direction.EAST);
        instancePainter.drawPort(3, "O", Direction.WEST);
        instancePainter.drawPort(1, "A", Direction.EAST);
        instancePainter.drawPort(2, "L", Direction.EAST);
        BitWidth bitWidth = (BitWidth)instancePainter.getAttributeValue(StdAttr.WIDTH);
        ScreenData screenData = ScreenData.get((InstanceState)instancePainter, bitWidth);
        int n = (540 - screenData.image.getWidth()) / 2;
        int n2 = (280 - screenData.image.getHeight()) / 2;
        graphics.drawImage(screenData.image, bounds.getX() + n, bounds.getY() + n2, screenData.image.getWidth(), screenData.image.getHeight(), null);
    }
}

