/*
 * Decompiled with CFR 0.152.
 */
package edu.gburg.nand2tetris;

import com.cburch.logisim.data.BitWidth;
import com.cburch.logisim.data.Bounds;
import com.cburch.logisim.data.Value;
import com.cburch.logisim.instance.InstancePainter;
import com.cburch.logisim.instance.InstancePoker;
import com.cburch.logisim.instance.InstanceState;
import com.cburch.logisim.instance.StdAttr;
import edu.gburg.nand2tetris.PCData;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;

public class PCPoker
extends InstancePoker {
    private MouseEvent lastEvent;
    private Bounds boundsPC;
    private EditType editType = EditType.NONE;

    public static Bounds[] getRegBounds(Bounds bounds) {
        Font font = new Font("Monospaced", 0, 12);
        Canvas canvas = new Canvas();
        FontMetrics fontMetrics = canvas.getFontMetrics(font);
        int n = fontMetrics.stringWidth("PC: ");
        int n2 = fontMetrics.stringWidth("0000");
        int n3 = fontMetrics.getHeight();
        int n4 = bounds.getX() + 80;
        int n5 = bounds.getY() + 30;
        Bounds bounds2 = Bounds.create((int)((n4 -= n2 / 2) - n), (int)(n5 -= n3 / 2), (int)(n2 + n), (int)n3);
        Bounds[] boundsArray = new Bounds[]{bounds2};
        return boundsArray;
    }

    public boolean init(InstanceState instanceState, MouseEvent mouseEvent) {
        Bounds bounds = instanceState.getInstance().getNominalBounds();
        if (!bounds.contains(mouseEvent.getX(), mouseEvent.getY())) {
            this.editType = EditType.NONE;
            return false;
        }
        Bounds[] boundsArray = PCPoker.getRegBounds(bounds);
        this.boundsPC = boundsArray[0];
        return true;
    }

    public void mouseReleased(InstanceState instanceState, MouseEvent mouseEvent) {
        this.editType = EditType.NONE;
        if (this.boundsPC.contains(mouseEvent.getX(), mouseEvent.getY())) {
            this.editType = EditType.REG_PC;
        }
    }

    public void paint(InstancePainter instancePainter) {
        if (this.editType == EditType.NONE) {
            return;
        }
        Graphics graphics = instancePainter.getGraphics();
        Color color = graphics.getColor();
        graphics.setColor(Color.RED);
        switch (this.editType) {
            case REG_PC: {
                graphics.drawRect(this.boundsPC.getX(), this.boundsPC.getY(), this.boundsPC.getWidth(), this.boundsPC.getHeight());
            }
        }
        graphics.setColor(color);
    }

    public void keyTyped(InstanceState instanceState, KeyEvent keyEvent) {
        if (this.editType == EditType.NONE) {
            return;
        }
        boolean bl = keyEvent.getKeyChar() == '\u007f' || keyEvent.getKeyChar() == '\b';
        int n = Character.digit(keyEvent.getKeyChar(), 16);
        BitWidth bitWidth = (BitWidth)instanceState.getAttributeValue(StdAttr.WIDTH);
        if (!(bl || n >= 0 && (n & bitWidth.getMask()) == n)) {
            return;
        }
        PCData pCData = PCData.get(instanceState, bitWidth);
        switch (this.editType) {
            case REG_PC: {
                int n2 = bl ? 0 : pCData.getValue().toIntValue() * 16 + n & bitWidth.getMask();
                Value value = Value.createKnown((BitWidth)bitWidth, (int)n2);
                pCData.setValue(value);
            }
        }
        instanceState.fireInvalidated();
    }

    private static enum EditType {
        NONE,
        REG_PC;

    }
}

