/*
 * Decompiled with CFR 0.152.
 */
package edu.gburg.nand2tetris;

import com.cburch.logisim.data.Attribute;
import com.cburch.logisim.data.BitWidth;
import com.cburch.logisim.data.Bounds;
import com.cburch.logisim.data.Direction;
import com.cburch.logisim.data.Value;
import com.cburch.logisim.instance.InstanceFactory;
import com.cburch.logisim.instance.InstancePainter;
import com.cburch.logisim.instance.InstanceState;
import com.cburch.logisim.instance.Port;
import com.cburch.logisim.instance.StdAttr;
import com.cburch.logisim.util.GraphicsUtil;
import edu.gburg.nand2tetris.PCData;
import edu.gburg.nand2tetris.PCPoker;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;

class PC
extends InstanceFactory {
    public static final int WIDTH = 160;
    public static final int HEIGHT = 40;
    private static final int ULX = -160;
    private static final int ULY = -20;
    private static final int TOP_SEP = 40;
    private static final int LEFT_SEP = 10;
    private static final int IN = 0;
    private static final int INC = 1;
    private static final int LOAD = 2;
    private static final int RESET = 3;
    private static final int OUT = 4;
    private static final int CK = 5;
    private static final int NUM_PORTS = 6;

    public PC() {
        super("PC");
        this.setOffsetBounds(Bounds.create((int)-160, (int)-20, (int)160, (int)40));
        this.setAttributes(new Attribute[]{StdAttr.WIDTH, StdAttr.EDGE_TRIGGER}, new Object[]{BitWidth.create((int)16), StdAttr.TRIG_RISING});
        Port[] portArray = new Port[]{new Port(-160, -10, "input", StdAttr.WIDTH), new Port(-120, -20, "input", 1), new Port(-80, -20, "input", 1), new Port(-40, -20, "input", 1), new Port(0, 0, "output", StdAttr.WIDTH), new Port(-160, 10, "input", 1)};
        this.setPorts(portArray);
        this.setInstancePoker(PCPoker.class);
    }

    public void propagate(InstanceState instanceState) {
        BitWidth bitWidth = (BitWidth)instanceState.getAttributeValue(StdAttr.WIDTH);
        PCData pCData = PCData.get(instanceState, bitWidth);
        if (pCData.getValue().isUnknown()) {
            pCData.setValue(Value.createKnown((BitWidth)bitWidth, (int)0));
            instanceState.setPort(4, pCData.getValue(), 9);
        }
        Object object = instanceState.getAttributeValue(StdAttr.EDGE_TRIGGER);
        boolean bl = pCData.updateClock(instanceState.getPortValue(5), object);
        if (bl) {
            pCData.setValue(PC.nextValue(instanceState, pCData.getValue()));
        }
        instanceState.setPort(4, pCData.getValue(), 9);
    }

    public void paintInstance(InstancePainter instancePainter) {
        Bounds bounds = instancePainter.getNominalBounds();
        instancePainter.drawRectangle(bounds, "");
        Graphics graphics = instancePainter.getGraphics();
        graphics.setColor(Color.BLACK);
        instancePainter.drawClockSymbol(bounds.getX(), bounds.getY() + 30);
        instancePainter.drawPort(5, "", Direction.EAST);
        instancePainter.drawPort(0, "in", Direction.EAST);
        instancePainter.drawPort(4, "out", Direction.WEST);
        instancePainter.drawPort(1, "inc", Direction.NORTH);
        instancePainter.drawPort(2, "load", Direction.NORTH);
        instancePainter.drawPort(3, "reset", Direction.NORTH);
        BitWidth bitWidth = (BitWidth)instancePainter.getAttributeValue(StdAttr.WIDTH);
        PCData pCData = PCData.get((InstanceState)instancePainter, bitWidth);
        Value value = pCData.getValue();
        Font font = graphics.getFont();
        Font font2 = new Font("Monospaced", 0, 12);
        Bounds[] boundsArray = PCPoker.getRegBounds(bounds);
        if (instancePainter.getShowState()) {
            graphics.setFont(font2);
            GraphicsUtil.drawCenteredText((Graphics)instancePainter.getGraphics(), (String)("PC:" + value.toHexString()), (int)boundsArray[0].getCenterX(), (int)boundsArray[0].getCenterY());
            graphics.setFont(font);
        }
    }

    static Value nextValue(InstanceState instanceState, Value value) {
        BitWidth bitWidth;
        int n;
        if (instanceState.getPortValue(3) == Value.TRUE) {
            n = 0;
        } else if (instanceState.getPortValue(2) == Value.TRUE) {
            bitWidth = instanceState.getPortValue(0);
            if (!bitWidth.isFullyDefined()) {
                return value;
            }
            n = bitWidth.toIntValue();
        } else if (instanceState.getPortValue(1) == Value.TRUE) {
            n = value.toIntValue() + 1;
        } else {
            return value;
        }
        bitWidth = instanceState.getPortValue(4).getBitWidth();
        return Value.createKnown((BitWidth)bitWidth, (int)n);
    }
}

