/*
 * Decompiled with CFR 0.152.
 */
package edu.gburg.nand2tetris;

import com.cburch.logisim.data.Bounds;
import com.cburch.logisim.data.Direction;
import com.cburch.logisim.data.Value;
import com.cburch.logisim.instance.InstanceFactory;
import com.cburch.logisim.instance.InstancePainter;
import com.cburch.logisim.instance.InstanceState;
import com.cburch.logisim.instance.Port;
import com.cburch.logisim.util.GraphicsUtil;
import edu.gburg.nand2tetris.CPUData;
import edu.gburg.nand2tetris.Utils;
import java.awt.Color;
import java.awt.Graphics;

class Jumper
extends InstanceFactory {
    private static final int WIDTH = 100;
    private static final int HEIGHT = 80;
    private static final int ULX = -100;
    private static final int ULY = -40;
    private static final int TOP_SEP = 20;
    private static final int BOT_SEP = 50;
    private static final int LEFT_SEP = 30;
    private static final int ZR = 0;
    private static final int NG = 1;
    private static final int OPCODE = 2;
    private static final int JUMP = 3;

    Jumper() {
        super("Jumper");
        this.setOffsetBounds(Bounds.create((int)-100, (int)-40, (int)100, (int)80));
        Port[] portArray = new Port[]{new Port(-100, -10, "input", 1), new Port(-100, 0, "input", 1), new Port(-100, 10, "input", 3), new Port(0, 0, "output", 1)};
        this.setPorts(portArray);
    }

    public void propagate(InstanceState instanceState) {
        Value value = instanceState.getPortValue(0);
        Value value2 = instanceState.getPortValue(1);
        int n = instanceState.getPortValue(2).toIntValue();
        boolean bl = CPUData.isJump(n, value, value2);
        instanceState.setPort(3, Utils.boolValue(bl), 1);
    }

    public void paintInstance(InstancePainter instancePainter) {
        Bounds bounds = instancePainter.getNominalBounds();
        instancePainter.drawRectangle(bounds, "");
        Graphics graphics = instancePainter.getGraphics();
        graphics.setColor(Color.BLACK);
        GraphicsUtil.drawCenteredText((Graphics)graphics, (String)"Jumper", (int)(bounds.getX() + bounds.getWidth() / 2), (int)(bounds.getY() + 10));
        instancePainter.drawPort(0, "zr", Direction.EAST);
        instancePainter.drawPort(1, "ng", Direction.EAST);
        instancePainter.drawPort(2, "opcode", Direction.EAST);
        instancePainter.drawPort(3, "jump", Direction.WEST);
    }
}

