/*
 * Decompiled with CFR 0.152.
 */
package edu.gburg.nand2tetris;

import com.cburch.logisim.data.BitWidth;
import com.cburch.logisim.data.Bounds;
import com.cburch.logisim.data.Value;
import com.cburch.logisim.instance.InstancePainter;
import com.cburch.logisim.instance.InstancePoker;
import com.cburch.logisim.instance.InstanceState;
import com.cburch.logisim.instance.StdAttr;
import edu.gburg.nand2tetris.CPUData;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;

public class CPUPoker
extends InstancePoker {
    private MouseEvent lastEvent;
    private Bounds boundsA;
    private Bounds boundsD;
    private Bounds boundsPC;
    private EditType editType = EditType.NONE;

    public static Bounds[] getRegBounds(Bounds bounds) {
        Font font = new Font("Monospaced", 0, 12);
        Canvas canvas = new Canvas();
        FontMetrics fontMetrics = canvas.getFontMetrics(font);
        int n = fontMetrics.stringWidth("A: ");
        int n2 = fontMetrics.stringWidth("D: ");
        int n3 = fontMetrics.stringWidth("PC: ");
        int n4 = fontMetrics.stringWidth("0000");
        int n5 = fontMetrics.getHeight();
        int n6 = 45;
        int n7 = bounds.getX() + 145;
        int n8 = bounds.getY() + n6;
        Bounds bounds2 = Bounds.create((int)((n7 -= n4 / 2) - n), (int)(n8 -= n5 / 2), (int)(n4 + n), (int)n5);
        Bounds bounds3 = Bounds.create((int)(n7 - n2), (int)(n8 += n6), (int)(n4 + n2), (int)n5);
        Bounds bounds4 = Bounds.create((int)(n7 - n3), (int)(n8 += n6), (int)(n4 + n3), (int)n5);
        Bounds[] boundsArray = new Bounds[]{bounds2, bounds3, bounds4};
        return boundsArray;
    }

    public boolean init(InstanceState instanceState, MouseEvent mouseEvent) {
        Bounds bounds = instanceState.getInstance().getNominalBounds();
        if (!bounds.contains(mouseEvent.getX(), mouseEvent.getY())) {
            this.editType = EditType.NONE;
            return false;
        }
        Bounds[] boundsArray = CPUPoker.getRegBounds(bounds);
        this.boundsA = boundsArray[0];
        this.boundsD = boundsArray[1];
        this.boundsPC = boundsArray[2];
        return true;
    }

    public void mouseReleased(InstanceState instanceState, MouseEvent mouseEvent) {
        this.editType = EditType.NONE;
        if (this.boundsA.contains(mouseEvent.getX(), mouseEvent.getY())) {
            this.editType = EditType.REG_A;
        } else if (this.boundsD.contains(mouseEvent.getX(), mouseEvent.getY())) {
            this.editType = EditType.REG_D;
        } else if (this.boundsPC.contains(mouseEvent.getX(), mouseEvent.getY())) {
            this.editType = EditType.REG_PC;
        }
    }

    public void paint(InstancePainter instancePainter) {
        if (this.editType == EditType.NONE) {
            return;
        }
        Graphics graphics = instancePainter.getGraphics();
        Color color = graphics.getColor();
        graphics.setColor(Color.RED);
        switch (this.editType) {
            case REG_A: {
                graphics.drawRect(this.boundsA.getX(), this.boundsA.getY(), this.boundsA.getWidth(), this.boundsA.getHeight());
                break;
            }
            case REG_D: {
                graphics.drawRect(this.boundsD.getX(), this.boundsD.getY(), this.boundsD.getWidth(), this.boundsD.getHeight());
                break;
            }
            case REG_PC: {
                graphics.drawRect(this.boundsPC.getX(), this.boundsPC.getY(), this.boundsPC.getWidth(), this.boundsPC.getHeight());
            }
        }
        graphics.setColor(color);
    }

    public void keyTyped(InstanceState instanceState, KeyEvent keyEvent) {
        if (this.editType == EditType.NONE) {
            return;
        }
        boolean bl = keyEvent.getKeyChar() == '\u007f' || keyEvent.getKeyChar() == '\b';
        int n = Character.digit(keyEvent.getKeyChar(), 16);
        BitWidth bitWidth = (BitWidth)instanceState.getAttributeValue(StdAttr.WIDTH);
        if (!(bl || n >= 0 && (n & bitWidth.getMask()) == n)) {
            return;
        }
        CPUData cPUData = CPUData.get(instanceState, bitWidth);
        switch (this.editType) {
            case REG_A: {
                int n2 = bl ? 0 : cPUData.getRegA().toIntValue() * 16 + n & bitWidth.getMask();
                Value value = Value.createKnown((BitWidth)bitWidth, (int)n2);
                cPUData.setRegA(value);
                break;
            }
            case REG_D: {
                int n3 = bl ? 0 : cPUData.getRegD().toIntValue() * 16 + n & bitWidth.getMask();
                Value value = Value.createKnown((BitWidth)bitWidth, (int)n3);
                cPUData.setRegD(value);
                break;
            }
            case REG_PC: {
                int n4 = bl ? 0 : cPUData.getRegPC().toIntValue() * 16 + n & bitWidth.getMask();
                Value value = Value.createKnown((BitWidth)bitWidth, (int)n4);
                cPUData.setRegPC(value);
            }
        }
        instanceState.fireInvalidated();
    }

    private static enum EditType {
        NONE,
        REG_A,
        REG_D,
        REG_PC;

    }
}

