/*
 * Decompiled with CFR 0.152.
 */
package edu.gburg.nand2tetris;

import com.cburch.logisim.data.BitWidth;
import com.cburch.logisim.data.Value;
import com.cburch.logisim.instance.InstanceData;
import com.cburch.logisim.instance.InstanceState;
import com.cburch.logisim.instance.StdAttr;
import edu.gburg.nand2tetris.ALU;
import edu.gburg.nand2tetris.Utils;

class CPUData
implements InstanceData,
Cloneable {
    private static final int JMP_GT = 1;
    private static final int JMP_EQ = 2;
    private static final int JMP_GE = 3;
    private static final int JMP_LT = 4;
    private static final int JMP_NE = 5;
    private static final int JMP_LE = 6;
    private static final int JMP_DO = 7;
    private Value lastClock;
    private Value regA;
    private Value regD;
    private Value regPC;
    private Value outM;
    private Value writeM;
    private Value addressM;

    public static CPUData get(InstanceState instanceState, BitWidth bitWidth) {
        CPUData cPUData = (CPUData)instanceState.getData();
        if (cPUData == null) {
            cPUData = new CPUData(null);
            instanceState.setData((InstanceData)cPUData);
        }
        return cPUData;
    }

    public CPUData(Value value) {
        this.lastClock = value;
        this.regA = Value.createKnown((BitWidth)BitWidth.create((int)16), (int)0);
        this.regD = Value.createKnown((BitWidth)BitWidth.create((int)16), (int)0);
        this.regPC = Value.createKnown((BitWidth)BitWidth.create((int)15), (int)0);
        this.outM = Value.createKnown((BitWidth)BitWidth.create((int)16), (int)0);
        this.writeM = Value.createKnown((BitWidth)BitWidth.create((int)1), (int)0);
        this.addressM = Value.createKnown((BitWidth)BitWidth.create((int)15), (int)0);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public boolean updateClock(Value value, Object object) {
        Value value2 = this.lastClock;
        this.lastClock = value;
        if (object == null || object == StdAttr.TRIG_RISING) {
            return value2 == Value.FALSE && value == Value.TRUE;
        }
        if (object == StdAttr.TRIG_FALLING) {
            return value2 == Value.TRUE && value == Value.FALSE;
        }
        if (object == StdAttr.TRIG_HIGH) {
            return value == Value.TRUE;
        }
        if (object == StdAttr.TRIG_LOW) {
            return value == Value.FALSE;
        }
        return value2 == Value.FALSE && value == Value.TRUE;
    }

    public Value getRegA() {
        return this.regA;
    }

    public void setRegA(Value value) {
        this.regA = value;
    }

    public Value getRegD() {
        return this.regD;
    }

    public void setRegD(Value value) {
        this.regD = value;
    }

    public Value getRegPC() {
        return this.regPC;
    }

    public void setRegPC(Value value) {
        this.regPC = value;
    }

    public Value getOut() {
        return this.outM;
    }

    public Value getWrite() {
        return this.writeM;
    }

    public Value getAddr() {
        return this.addressM;
    }

    public Value[] set(Value value, Value value2, Value value3, boolean bl) {
        Value[] valueArray = CPUData.compute(value, value2, value3, this.regA, this.regD, this.regPC, this.outM, bl);
        this.outM = valueArray[0];
        this.addressM = valueArray[1];
        this.writeM = valueArray[2];
        this.regPC = valueArray[3];
        this.regA = valueArray[4];
        this.regD = valueArray[5];
        return valueArray;
    }

    public static boolean isJump(int n, Value value, Value value2) {
        boolean bl = value == Value.TRUE;
        boolean bl2 = value2 == Value.TRUE;
        boolean bl3 = bl2 || bl;
        return n == 2 && bl || n == 5 && !bl || n == 4 && bl2 || n == 6 && bl3 || n == 1 && !bl3 || n == 3 && !bl2 || n == 7;
    }

    public static Value[] compute(Value value, Value value2, Value value3, Value value4, Value value5, Value value6, Value value7, boolean bl) {
        Value value8 = value5;
        Value value9 = value.get(12);
        Value value10 = value9 == Value.FALSE ? value4 : value2;
        Value value11 = value.get(11);
        Value value12 = value.get(10);
        Value value13 = value.get(9);
        Value value14 = value.get(8);
        Value value15 = value.get(7);
        Value value16 = value.get(6);
        Value[] valueArray = ALU.compute(value8, value10, value11, value12, value13, value14, value15, value16);
        value7 = valueArray[0];
        Value value17 = valueArray[1];
        Value value18 = valueArray[2];
        boolean bl2 = value.get(15) == Value.TRUE;
        boolean bl3 = !bl2 || value.get(5) == Value.TRUE;
        boolean bl4 = bl2 && value.get(4) == Value.TRUE;
        boolean bl5 = bl2 && value.get(3) == Value.TRUE;
        Value value19 = Utils.boolValue(bl5);
        int n = value.get(2).toIntValue() << 2 | value.get(1).toIntValue() << 1 | value.get(0).toIntValue() << 0;
        boolean bl6 = bl2 && CPUData.isJump(n, value17, value18);
        boolean bl7 = !bl6;
        Value value20 = value4;
        if (bl) {
            if (value3 == Value.TRUE) {
                value6 = Value.createKnown((BitWidth)value6.getBitWidth(), (int)0);
            } else if (bl6) {
                value6 = value20;
            } else if (bl7) {
                int n2 = value6.toIntValue();
                value6 = Value.createKnown((BitWidth)value6.getBitWidth(), (int)(n2 + 1));
            }
        }
        if (bl && bl3) {
            value4 = !bl2 ? value : value7;
        }
        Value value21 = value4;
        if (bl && bl4) {
            value5 = value7;
        }
        Value[] valueArray2 = new Value[]{value7, value21, value19, value6, value4, value5};
        return valueArray2;
    }
}

