/*
 * Decompiled with CFR 0.152.
 */
package edu.gburg.nand2tetris;

import com.cburch.logisim.data.Attribute;
import com.cburch.logisim.data.BitWidth;
import com.cburch.logisim.data.Bounds;
import com.cburch.logisim.data.Direction;
import com.cburch.logisim.data.Value;
import com.cburch.logisim.instance.InstanceFactory;
import com.cburch.logisim.instance.InstancePainter;
import com.cburch.logisim.instance.InstanceState;
import com.cburch.logisim.instance.Port;
import com.cburch.logisim.instance.StdAttr;
import com.cburch.logisim.util.GraphicsUtil;
import edu.gburg.nand2tetris.CPUData;
import edu.gburg.nand2tetris.CPUPoker;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;

class CPU
extends InstanceFactory {
    public static final int WIDTH = 290;
    public static final int HEIGHT = 180;
    private static final int ULX = -290;
    private static final int ULY = -90;
    private static final int LEFT_SEP = 10;
    private static final int P_INSTR = 0;
    private static final int P_IN = 1;
    private static final int P_RESET = 2;
    private static final int P_OUT = 3;
    private static final int P_ADDR = 4;
    private static final int P_WRITE = 5;
    private static final int P_PC = 6;
    private static final int CK = 7;
    private static final int NUM_PORTS = 8;

    public CPU() {
        super("CPU");
        this.setOffsetBounds(Bounds.create((int)-290, (int)-90, (int)290, (int)180));
        this.setAttributes(new Attribute[]{StdAttr.WIDTH, StdAttr.EDGE_TRIGGER}, new Object[]{BitWidth.create((int)16), StdAttr.TRIG_RISING});
        Port[] portArray = new Port[8];
        portArray[0] = new Port(-290, -30, "input", StdAttr.WIDTH);
        portArray[1] = new Port(-290, 0, "input", StdAttr.WIDTH);
        portArray[2] = new Port(-290, 30, "input", 1);
        portArray[3] = new Port(0, -60, "output", StdAttr.WIDTH);
        portArray[5] = new Port(0, -20, "output", 1);
        portArray[4] = new Port(0, 20, "output", 15);
        portArray[6] = new Port(0, 60, "output", 15);
        portArray[7] = new Port(-290, -80, "input", 1);
        this.setPorts(portArray);
        this.setInstancePoker(CPUPoker.class);
    }

    public void propagate(InstanceState instanceState) {
        BitWidth bitWidth = (BitWidth)instanceState.getAttributeValue(StdAttr.WIDTH);
        CPUData cPUData = CPUData.get(instanceState, bitWidth);
        Object object = instanceState.getAttributeValue(StdAttr.EDGE_TRIGGER);
        boolean bl = cPUData.updateClock(instanceState.getPortValue(7), object);
        Value value = instanceState.getPortValue(0);
        Value value2 = instanceState.getPortValue(1);
        Value value3 = instanceState.getPortValue(2);
        cPUData.set(value, value2, value3, bl);
        instanceState.setPort(4, cPUData.getAddr(), 5);
        instanceState.setPort(6, cPUData.getRegPC(), 5);
        instanceState.setPort(3, cPUData.getOut(), 5);
        instanceState.setPort(5, cPUData.getWrite(), 5);
    }

    public void paintInstance(InstancePainter instancePainter) {
        Bounds bounds = instancePainter.getNominalBounds();
        instancePainter.drawRectangle(bounds, "");
        Graphics graphics = instancePainter.getGraphics();
        graphics.setColor(Color.BLACK);
        instancePainter.drawClockSymbol(bounds.getX(), bounds.getY() + 10);
        instancePainter.drawPort(7, "", Direction.EAST);
        instancePainter.drawPort(1, "inM", Direction.EAST);
        instancePainter.drawPort(0, "instruction", Direction.EAST);
        instancePainter.drawPort(2, "reset", Direction.EAST);
        instancePainter.drawPort(3, "outM", Direction.WEST);
        instancePainter.drawPort(5, "writeM", Direction.WEST);
        instancePainter.drawPort(4, "addrM", Direction.WEST);
        instancePainter.drawPort(6, "pc", Direction.WEST);
        BitWidth bitWidth = (BitWidth)instancePainter.getAttributeValue(StdAttr.WIDTH);
        CPUData cPUData = CPUData.get((InstanceState)instancePainter, bitWidth);
        Value value = cPUData.getRegA();
        Value value2 = cPUData.getRegD();
        Value value3 = cPUData.getRegPC();
        int n = 45;
        Font font = graphics.getFont();
        Font font2 = new Font("Monospaced", 0, 12);
        Bounds[] boundsArray = CPUPoker.getRegBounds(bounds);
        graphics.setFont(font2);
        GraphicsUtil.drawCenteredText((Graphics)graphics, (String)("A:" + value.toHexString()), (int)boundsArray[0].getCenterX(), (int)boundsArray[0].getCenterY());
        GraphicsUtil.drawCenteredText((Graphics)graphics, (String)("D:" + value2.toHexString()), (int)boundsArray[1].getCenterX(), (int)boundsArray[1].getCenterY());
        GraphicsUtil.drawCenteredText((Graphics)graphics, (String)("PC:" + value3.toHexString()), (int)boundsArray[2].getCenterX(), (int)boundsArray[2].getCenterY());
        graphics.setFont(font);
    }
}

