/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.Scanner;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTextArea;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultCaret;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Document;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import javax.swing.text.Utilities;
import javax.swing.text.View;

public class ArmSim {
    private static final Color LINE_HIGHLIGHT_COLOR = new Color(118, 215, 196, 125);
    private static final Color ERROR_HIGHLIGHT_COLOR = new Color(245, 183, 177, 125);
    private static final Color CARET_COLOR = Color.CYAN;
    private LineHighlighter painter = new LineHighlighter(this, LINE_HIGHLIGHT_COLOR);
    private JFrame frame;
    private JTextArea textArea;
    private JLabel errorMessage;
    private ChipCPU CPU;
    private ChipMemory RAM;
    private HashMap<String, Integer> labels = new HashMap();
    private JButton playButton;
    private JButton resetButton;
    private JButton stepButton;
    private JSlider speedSlider;
    private Timer playTimer;
    private File selectedFile;
    private HashMap<Integer, Integer> sourceLinePC = new HashMap();
    private HashMap<String, Integer> jumpLineNumbers = new HashMap();
    private static String re_regs = "(";
    private static final String re_regs_list;
    private static final String re_int = "(\\+|\\-)?(0|[1-9]\\d*)";
    private static final String re_int_list;
    private static final String re_shift = "(\\d|[1-2]\\d|30|31|32)";
    private static final String re_op2;
    private static final String re_op2_shift;
    private static final String re_label = "(?!END$)[A-Z][A-Z_]*";
    private static final String re_label_line;
    private static final String re_ident = "[a-z][a-z0-9_]*";
    private static final String re_MOV;
    private static final String re_CMP;
    private static final String re_ARITH;
    private static final String re_ASR;
    private static final String re_BXX;
    private static final String re_DCD;
    private static final String re_LDR1;
    private static final String re_LDR2;
    private static final String re_LDR3;
    private static final String re_STR2;
    private static final String re_STR3;
    private static final String re_LDM;
    private static final String re_STM;
    private static final String re_END;
    private HashMap<String, Integer> variables = new HashMap();

    public void selectFirst(JScrollPane jScrollPane) {
        JPanel jPanel = (JPanel)jScrollPane.getViewport().getView();
        JViewport jViewport = jScrollPane.getViewport();
        jViewport.setViewPosition(new Point(0, 0));
    }

    public void selectLast(JScrollPane jScrollPane) {
        JPanel jPanel = (JPanel)jScrollPane.getViewport().getView();
        JViewport jViewport = jScrollPane.getViewport();
        int n = jViewport.getHeight();
        jViewport.setViewPosition(new Point(0, n));
    }

    void addBorder(JComponent jComponent, String string, int n) {
        TitledBorder titledBorder = BorderFactory.createTitledBorder(string);
        Border border = BorderFactory.createEmptyBorder(n, n, n, n);
        CompoundBorder compoundBorder = BorderFactory.createCompoundBorder(titledBorder, border);
        jComponent.setBorder(compoundBorder);
    }

    private static void addVertSpacing(Box box, int n) {
        Dimension dimension = new Dimension(0, n);
        Dimension dimension2 = new Dimension(0, n);
        Dimension dimension3 = new Dimension(Short.MAX_VALUE, n);
        box.add(new Box.Filler(dimension, dimension2, dimension3));
    }

    private static void addHorizSpacing(Box box, int n) {
        Dimension dimension = new Dimension(n, 0);
        Dimension dimension2 = new Dimension(n, 0);
        Dimension dimension3 = new Dimension(n, 0);
        box.add(new Box.Filler(dimension, dimension2, dimension3));
    }

    private static void restrictSize(JComponent jComponent, Dimension dimension) {
        jComponent.setPreferredSize(dimension);
        jComponent.setMinimumSize(dimension);
        jComponent.setMaximumSize(dimension);
    }

    private static void restrictSize(JComponent jComponent) {
        Dimension dimension = jComponent.getPreferredSize();
        ArmSim.restrictSize(jComponent, dimension);
    }

    private static void restrictSize(JComponent jComponent, int n, int n2) {
        Dimension dimension = new Dimension(n, n2);
        ArmSim.restrictSize(jComponent, dimension);
    }

    private static void restrictSize(Dimension dimension, JComponent ... jComponentArray) {
        for (JComponent jComponent : jComponentArray) {
            ArmSim.restrictSize(jComponent, dimension);
        }
    }

    private static void restrictHorizSize(JComponent jComponent, JComponent ... jComponentArray) {
        int n = jComponent.getPreferredSize().width;
        for (JComponent jComponent2 : jComponentArray) {
            int n2 = jComponent2.getPreferredSize().width;
            if (n2 <= n) continue;
            n = n2;
        }
        Dimension dimension = jComponent.getPreferredSize();
        dimension.width = n;
        ArmSim.restrictSize(jComponent, dimension);
        for (JComponent jComponent3 : jComponentArray) {
            int n3 = jComponent3.getPreferredSize().height;
            Dimension dimension2 = new Dimension(n, n3);
            ArmSim.restrictSize(jComponent3, dimension2);
        }
    }

    private int getSourceLinePC() {
        int n;
        int n2 = this.CPU.getValue("PC");
        ArmSimException.currLine = n = this.sourceLinePC.getOrDefault(n2, -1).intValue();
        return n;
    }

    public ArmSim() {
        this.frame = new JFrame("untitled");
        this.frame.setDefaultCloseOperation(3);
        this.frame.setLayout(new BorderLayout());
        this.textArea = new JTextArea(50, 100);
        this.textArea.setFont(new Font("Monospaced", 1, 14));
        this.textArea.setBackground(Color.BLACK);
        this.textArea.setForeground(Color.WHITE);
        BlockCaret blockCaret = new BlockCaret(CARET_COLOR);
        this.textArea.setCaret(blockCaret);
        this.textArea.setCaretColor(CARET_COLOR);
        this.textArea.setLineWrap(false);
        this.textArea.setWrapStyleWord(false);
        JScrollPane jScrollPane = new JScrollPane(this.textArea);
        this.textArea.setEnabled(false);
        this.playButton = new JButton("Play");
        this.resetButton = new JButton("Reset");
        this.stepButton = new JButton("Step");
        this.playButton.setEnabled(false);
        this.resetButton.setEnabled(false);
        this.stepButton.setEnabled(false);
        this.speedSlider = new JSlider(50, 1000, 1000);
        this.speedSlider.setMajorTickSpacing(300);
        this.speedSlider.setMinorTickSpacing(100);
        this.speedSlider.setPaintTicks(true);
        this.speedSlider.setPaintLabels(true);
        this.speedSlider.setBorder(BorderFactory.createTitledBorder("Play Speed (ms)"));
        Box box = Box.createHorizontalBox();
        box.add(this.playButton);
        box.add(this.resetButton);
        box.add(this.stepButton);
        ArmSim.addHorizSpacing(box, 20);
        box.add(this.speedSlider);
        this.errorMessage = new JLabel(" ");
        this.errorMessage.setFont(new Font("Monospaced", 1, 14));
        this.errorMessage.setHorizontalAlignment(0);
        this.errorMessage.setOpaque(true);
        this.errorMessage.setForeground(Color.RED);
        ArmSim.addHorizSpacing(box, 20);
        box.add(this.errorMessage);
        Box box2 = Box.createVerticalBox();
        box.setAlignmentX(0.0f);
        box2.add(box);
        box2.add(jScrollPane);
        box2.add(Box.createVerticalGlue());
        this.CPU = new ChipCPU();
        this.RAM = new ChipMemory();
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 11;
        jPanel.add((Component)this.CPU.GUI, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 11;
        jPanel.add((Component)this.RAM.GUI, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 11;
        jPanel.add((Component)box2, gridBagConstraints);
        this.frame.pack();
        Dimension dimension = this.RAM.stackScroll.getPreferredSize();
        ArmSim.restrictSize(dimension, this.RAM.stackScroll, this.RAM.datasegScroll);
        this.selectLast(this.RAM.stackScroll);
        ArmSim.restrictSize(this.CPU.GUI);
        ArmSim.restrictSize(this.RAM.GUI);
        ArmSim.restrictSize(jPanel);
        ArmSim.restrictSize(box);
        ArmSim.restrictSize(box2);
        this.frame.add((Component)jPanel, "Center");
        this.addListeners();
        this.showMenuBar();
        this.frame.pack();
        JScrollPane jScrollPane2 = new JScrollPane(jPanel);
        jScrollPane2.setVerticalScrollBarPolicy(20);
        jScrollPane2.setHorizontalScrollBarPolicy(30);
        this.frame.getContentPane().add((Component)jScrollPane2, "Center");
        this.frame.setMaximumSize(this.frame.getPreferredSize());
        this.frame.setPreferredSize(this.frame.getPreferredSize());
        this.frame.setVisible(true);
    }

    private void loadFile(File file) {
        try (BufferedReader bufferedReader = new BufferedReader(new FileReader(file));){
            String string;
            StringBuilder stringBuilder = new StringBuilder();
            while ((string = bufferedReader.readLine()) != null) {
                stringBuilder.append(string).append("\n");
            }
            this.textArea.setText(stringBuilder.toString());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void saveFile(File file) {
        try (BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));){
            String string = this.textArea.getText();
            bufferedWriter.write(string);
            this.frame.setTitle(file.getName());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void showMenuBar() {
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu("File (v9)");
        JMenuItem jMenuItem = new JMenuItem("Load");
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ArmSim.this.errorMessage.setText(" ");
                JFileChooser jFileChooser = new JFileChooser();
                FileNameExtensionFilter fileNameExtensionFilter = new FileNameExtensionFilter("ARM Files", "arm");
                jFileChooser.addChoosableFileFilter(fileNameExtensionFilter);
                jFileChooser.setFileFilter(fileNameExtensionFilter);
                int n = jFileChooser.showOpenDialog(ArmSim.this.frame);
                if (n == 0) {
                    ArmSim.this.selectedFile = jFileChooser.getSelectedFile();
                    ArmSim.this.loadFile(ArmSim.this.selectedFile);
                    ArmSim.this.frame.setTitle(ArmSim.this.selectedFile.getName());
                    ArmSim.this.textArea.setEnabled(true);
                    ArmSim.this.textArea.setCaretPosition(0);
                    ArmSim.this.playButton.setEnabled(true);
                    ArmSim.this.resetButton.setEnabled(true);
                    ArmSim.this.stepButton.setEnabled(true);
                }
            }
        });
        JMenuItem jMenuItem2 = new JMenuItem("New");
        jMenuItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ArmSim.this.errorMessage.setText(" ");
                JFileChooser jFileChooser = new JFileChooser();
                FileNameExtensionFilter fileNameExtensionFilter = new FileNameExtensionFilter("ARM Files", "arm");
                jFileChooser.addChoosableFileFilter(fileNameExtensionFilter);
                jFileChooser.setFileFilter(fileNameExtensionFilter);
                int n = jFileChooser.showSaveDialog(ArmSim.this.frame);
                if (n == 0) {
                    ArmSim.this.selectedFile = jFileChooser.getSelectedFile();
                    if (!ArmSim.this.selectedFile.getName().endsWith(".arm")) {
                        ArmSim.this.errorMessage.setText("file name should end in .arm: " + ArmSim.this.selectedFile.getName());
                        return;
                    }
                    ArmSim.this.frame.setTitle(ArmSim.this.selectedFile.getName());
                    ArmSim.this.textArea.setText("");
                    if (ArmSim.this.selectedFile.exists()) {
                        ArmSim.this.loadFile(ArmSim.this.selectedFile);
                    }
                    ArmSim.this.textArea.setEnabled(true);
                    ArmSim.this.textArea.setCaretPosition(0);
                    ArmSim.this.playButton.setEnabled(true);
                    ArmSim.this.resetButton.setEnabled(true);
                    ArmSim.this.stepButton.setEnabled(true);
                }
            }
        });
        jMenu.add(jMenuItem2);
        jMenu.add(jMenuItem);
        jMenuBar.add(jMenu);
        this.frame.setJMenuBar(jMenuBar);
    }

    private void resetSimulation() {
        this.labels.clear();
        this.sourceLinePC.clear();
        this.jumpLineNumbers.clear();
        this.variables.clear();
        this.RAM.reset();
        this.CPU.reset();
    }

    private void checkProgramSyntax() throws ArmSimException {
        int n = this.textArea.getLineCount();
        try {
            this.textArea.setText(this.textArea.getText().replaceAll("\\s*$", ""));
            for (int i = 0; i < n; ++i) {
                int n2 = this.textArea.getLineStartOffset(i);
                int n3 = this.textArea.getLineEndOffset(i);
                String string = this.textArea.getText(n2, n3 - n2);
                if ((string = string.replaceAll(";.*", "").trim()).isEmpty() || string.matches(re_MOV) || string.matches(re_CMP) || string.matches(re_ARITH) || string.matches(re_ASR) || string.matches(re_BXX) || string.matches(re_DCD) || string.matches(re_LDR1) || string.matches(re_LDR2) || string.matches(re_LDR3) || string.matches(re_STR2) || string.matches(re_STR3) || string.matches(re_LDM) || string.matches(re_STM) || string.matches(re_END) || string.matches(re_label_line)) continue;
                throw new ArmSimException(i, "syntax error: " + string);
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    private String stripComment(String string) {
        return string.replaceFirst(";.*", "").trim();
    }

    private void assignCodeLineNumbers() {
        int n = this.textArea.getLineCount();
        try {
            int n2 = 0;
            for (int i = 0; i < n; ++i) {
                int n3 = this.textArea.getLineStartOffset(i);
                int n4 = this.textArea.getLineEndOffset(i);
                String string = this.textArea.getText(n3, n4 - n3);
                if ((string = this.stripComment(string)).isEmpty()) {
                    ++n2;
                    continue;
                }
                if (string.matches(re_label)) {
                    this.jumpLineNumbers.put(string, -1);
                    ++n2;
                    continue;
                }
                int n5 = i - n2;
                int n6 = 4 * n5;
                this.sourceLinePC.put(n6, i);
                for (Map.Entry<String, Integer> entry : this.jumpLineNumbers.entrySet()) {
                    if (entry.getValue() != -1) continue;
                    entry.setValue(n6);
                }
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    private void addListeners() {
        this.playButton.addActionListener(actionEvent -> {
            if (this.playTimer == null || !this.playTimer.isRunning()) {
                if (this.textArea.getText().trim().isEmpty()) {
                    return;
                }
                this.saveFile(this.selectedFile);
                this.resetSimulation();
                try {
                    this.checkProgramSyntax();
                }
                catch (ArmSimException armSimException) {
                    return;
                }
                this.assignCodeLineNumbers();
                this.textArea.setEnabled(false);
                this.playButton.setEnabled(false);
                this.stepButton.setEnabled(false);
                int n = this.getSourceLinePC();
                if (n != -1) {
                    String string = this.addLineHighlight(n, LINE_HIGHLIGHT_COLOR);
                }
                this.playTimer = new Timer(this.speedSlider.getValue(), new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        if (!ArmSim.this.stepThroughLine()) {
                            ArmSim.this.playTimer.stop();
                        }
                    }
                });
                this.playTimer.start();
            }
            this.adjustPlaySpeed();
        });
        this.resetButton.addActionListener(actionEvent -> {
            if (this.playTimer != null && this.playTimer.isRunning()) {
                this.playTimer.stop();
            }
            this.resetSimulation();
            this.resetHighlighting();
            this.textArea.setEnabled(true);
            this.playButton.setEnabled(true);
            this.stepButton.setEnabled(true);
            this.textArea.requestFocusInWindow();
        });
        this.stepButton.addActionListener(actionEvent -> {
            if (this.textArea.getText().trim().isEmpty()) {
                return;
            }
            if (this.textArea.isEnabled()) {
                this.saveFile(this.selectedFile);
                this.resetSimulation();
                try {
                    this.checkProgramSyntax();
                }
                catch (ArmSimException armSimException) {
                    return;
                }
                this.assignCodeLineNumbers();
                this.textArea.setEnabled(false);
                this.playButton.setEnabled(false);
                int n = this.getSourceLinePC();
                if (n != -1) {
                    String string = this.addLineHighlight(n, LINE_HIGHLIGHT_COLOR);
                }
            } else if (!this.stepThroughLine()) {
                this.stepButton.setEnabled(false);
            }
        });
        this.speedSlider.addChangeListener(changeEvent -> this.adjustPlaySpeed());
    }

    private boolean stepThroughLine() {
        int n = this.getSourceLinePC();
        if (n >= 0) {
            String string = this.addLineHighlight(n, LINE_HIGHLIGHT_COLOR);
            try {
                this.executeLine(string);
            }
            catch (ArmSimException armSimException) {
                return false;
            }
            if (string.matches(re_END)) {
                string = this.addLineHighlight(n, Color.GRAY);
                return false;
            }
            int n2 = this.getSourceLinePC();
            if (n2 >= 0) {
                this.addLineHighlight(n2, LINE_HIGHLIGHT_COLOR);
                return true;
            }
        }
        this.addLineHighlight(n, Color.GRAY);
        return false;
    }

    private void adjustPlaySpeed() {
        if (this.playTimer != null && this.playTimer.isRunning()) {
            this.playTimer.setDelay(this.speedSlider.getValue());
        }
    }

    private String addLineHighlight(int n, Color color) {
        if (n < 0) {
            return "";
        }
        try {
            this.resetHighlighting();
            int n2 = this.textArea.getLineStartOffset(n);
            int n3 = this.textArea.getLineEndOffset(n);
            Highlighter highlighter = this.textArea.getHighlighter();
            LineHighlighter lineHighlighter = new LineHighlighter(this, color);
            highlighter.addHighlight(n2, n3, lineHighlighter);
            String string = this.textArea.getText(n2, n3 - n2).trim();
            this.textArea.setCaretPosition(n3);
            return this.stripComment(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private void resetHighlighting() {
        Highlighter highlighter = this.textArea.getHighlighter();
        highlighter.removeAllHighlights();
    }

    private Scanner toScanner(String string) {
        string = string.replaceAll("[,#=\\!\\[\\]\\{\\}]", " ");
        Scanner scanner = new Scanner(string);
        return scanner;
    }

    private void executeLine(String string) throws ArmSimException {
        try {
            int n = this.CPU.incPC();
            string = string.replaceAll(";.*", "").trim();
            if (!string.matches(re_BXX)) {
                this.CPU.clearStatusBits();
            }
            if (string.matches(re_END)) {
                this.CPU.setPC(n);
                return;
            }
            if (string.matches(re_BXX)) {
                Scanner scanner = this.toScanner(string);
                String string2 = scanner.next();
                String string3 = scanner.next();
                if (this.jumpLineNumbers.get(string3) == null) {
                    throw new ArmSimException("invalid label: " + string3);
                }
                if (string2.equals("BL") || string2.equals("BAL") || string2.equals("BEQ") && this.CPU.getStatus("Z") || string2.equals("BNE") && !this.CPU.getStatus("Z") || string2.equals("BLT") && !this.CPU.getStatus("Z") && this.CPU.getStatus("N") || string2.equals("BLE") && (this.CPU.getStatus("Z") || this.CPU.getStatus("N")) || string2.equals("BGT") && !this.CPU.getStatus("Z") && !this.CPU.getStatus("N") || string2.equals("BGE") && (this.CPU.getStatus("Z") || !this.CPU.getStatus("N"))) {
                    int n2;
                    if (string2.equals("BL")) {
                        n2 = this.CPU.getValue("PC");
                        this.CPU.setValue("LR", n2);
                    }
                    n2 = this.jumpLineNumbers.get(string3);
                    this.CPU.setPC(n2);
                    return;
                }
            } else if (string.matches(re_MOV)) {
                Scanner scanner = this.toScanner(string);
                String string4 = scanner.next();
                String string5 = scanner.next();
                String string6 = scanner.next();
                int n3 = this.CPU.getValue(string6);
                this.CPU.setValue(string5, n3);
            } else if (string.matches(re_CMP)) {
                Scanner scanner = this.toScanner(string);
                String string7 = scanner.next();
                String string8 = scanner.next();
                String string9 = scanner.next();
                int n4 = this.CPU.getValue(string9);
                int n5 = this.CPU.getValue(string8);
                int n6 = n5 - n4;
                this.CPU.setStatusBits(n6);
            } else if (string.matches(re_ARITH)) {
                Scanner scanner = this.toScanner(string);
                String string10 = scanner.next();
                String string11 = scanner.next();
                String string12 = scanner.next();
                String string13 = scanner.next();
                int n7 = this.CPU.getValue(string12);
                int n8 = this.CPU.getValue(string13);
                if (string10.equals("ADD")) {
                    this.CPU.setValue(string11, n7 + n8);
                } else {
                    this.CPU.setValue(string11, n7 - n8);
                }
            } else if (string.matches(re_ASR)) {
                Scanner scanner = this.toScanner(string);
                String string14 = scanner.next();
                String string15 = scanner.next();
                String string16 = scanner.next();
                String string17 = scanner.next();
                int n9 = this.CPU.getValue(string16);
                int n10 = this.CPU.getValue(string17);
                this.CPU.setValue(string15, n9 >> n10);
            } else if (string.matches(re_DCD)) {
                Scanner scanner = this.toScanner(string);
                String string18 = scanner.next();
                String string19 = scanner.next();
                int n11 = this.RAM.dataSegmentOffset + 4 * this.RAM.dataItems;
                this.variables.put(string18, n11);
                while (scanner.hasNextInt()) {
                    int n12 = scanner.nextInt();
                    this.RAM.setCell(n11, n12);
                    ++this.RAM.dataItems;
                    n11 += 4;
                }
            } else if (string.matches(re_LDR1)) {
                Scanner scanner = this.toScanner(string);
                String string20 = scanner.next();
                String string21 = scanner.next();
                String string22 = scanner.next();
                if (this.variables.get(string22) == null) {
                    throw new ArmSimException("invalid identifier: " + string22);
                }
                int n13 = this.variables.get(string22);
                this.CPU.setValue(string21, n13);
            } else if (string.matches(re_LDR2)) {
                Scanner scanner = this.toScanner(string);
                String string23 = scanner.next();
                String string24 = scanner.next();
                String string25 = scanner.next();
                String string26 = scanner.next();
                int n14 = this.CPU.getValue(string25);
                int n15 = this.CPU.getValue(string26);
                int n16 = n14 + n15;
                int n17 = this.RAM.getCell(n16);
                this.CPU.setValue(string24, n17);
            } else if (string.matches(re_LDR3)) {
                Scanner scanner = this.toScanner(string);
                String string27 = scanner.next();
                String string28 = scanner.next();
                String string29 = scanner.next();
                String string30 = scanner.next();
                String string31 = scanner.next();
                int n18 = scanner.nextInt();
                int n19 = this.CPU.getValue(string29);
                int n20 = this.CPU.getValue(string30);
                int n21 = n19 + (n20 << n18);
                int n22 = this.RAM.getCell(n21);
                this.CPU.setValue(string28, n22);
            } else if (string.matches(re_STR2)) {
                Scanner scanner = this.toScanner(string);
                String string32 = scanner.next();
                String string33 = scanner.next();
                String string34 = scanner.next();
                String string35 = scanner.next();
                int n23 = this.CPU.getValue(string34);
                int n24 = this.CPU.getValue(string35);
                int n25 = n23 + n24;
                int n26 = this.CPU.getValue(string33);
                this.RAM.setCell(n25, n26);
            } else if (string.matches(re_STR3)) {
                Scanner scanner = this.toScanner(string);
                String string36 = scanner.next();
                String string37 = scanner.next();
                String string38 = scanner.next();
                String string39 = scanner.next();
                String string40 = scanner.next();
                int n27 = scanner.nextInt();
                int n28 = this.CPU.getValue(string38);
                int n29 = this.CPU.getValue(string39);
                int n30 = n28 + (n29 << n27);
                int n31 = this.CPU.getValue(string37);
                this.RAM.setCell(n30, n31);
            } else if (string.matches(re_LDM)) {
                boolean bl = string.indexOf(33) != -1;
                Scanner scanner = this.toScanner(string);
                String string41 = scanner.next();
                int n32 = string41.endsWith("IB") ? 4 : 0;
                int n33 = string41.endsWith("DB") ? -4 : 0;
                int n34 = string41.endsWith("IA") ? 4 : 0;
                int n35 = string41.endsWith("DA") ? -4 : 0;
                int n36 = n32 + n33;
                int n37 = n34 + n35;
                String string42 = scanner.next();
                String string43 = scanner.nextLine().trim();
                String[] stringArray = string43.split("\\s+");
                Arrays.sort(stringArray, Register.compareIndices);
                int n38 = this.CPU.getValue(string42);
                for (String string44 : stringArray) {
                    int n39 = this.RAM.getCell(n38 += n36);
                    this.CPU.setValue(string44, n39);
                    n38 += n34 + n35;
                }
                if (bl) {
                    this.CPU.setValue(string42, n38);
                }
            } else if (string.matches(re_STM)) {
                boolean bl = string.indexOf(33) != -1;
                Scanner scanner = this.toScanner(string);
                String string45 = scanner.next();
                int n40 = string45.endsWith("IB") ? 4 : 0;
                int n41 = string45.endsWith("DB") ? -4 : 0;
                int n42 = string45.endsWith("IA") ? 4 : 0;
                int n43 = string45.endsWith("DA") ? -4 : 0;
                int n44 = n40 + n41;
                int n45 = n42 + n43;
                String string46 = scanner.next();
                String string47 = scanner.nextLine().trim();
                String[] stringArray = string47.split("\\s+");
                Arrays.sort(stringArray, Register.reverseCompareIndices);
                int n46 = this.CPU.getValue(string46);
                for (String string48 : stringArray) {
                    int n47 = this.CPU.getValue(string48);
                    this.RAM.setCell(n46 += n40 + n41, n47);
                    n46 += n42 + n43;
                }
                if (bl) {
                    this.CPU.setValue(string46, n46);
                }
            }
        }
        catch (ArmSimException armSimException) {
            throw armSimException;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new ArmSimException("unexpected run-time error");
        }
    }

    private static String formatInPairs(int n) {
        String string = String.format("%05d", n);
        return string;
    }

    private static int getRandomInt(int n, int n2) {
        Random random = new Random();
        return random.nextInt(n2 - n + 1) + n;
    }

    public static void main(String[] stringArray) {
        SwingUtilities.invokeLater(ArmSim::new);
    }

    static {
        for (int i = 0; i < 16; ++i) {
            re_regs = re_regs + "R" + i + "|";
        }
        re_regs = re_regs + "FP|SP|LR|PC)";
        re_regs_list = String.format("\\{\\s*%s(\\s*,\\s*%s)*\\s*\\}", re_regs, re_regs);
        re_int_list = String.format("%s(,\\s*%s)*", re_int, re_int);
        re_op2 = String.format("(%s|#%s)", re_regs, re_int);
        re_op2_shift = String.format("(%s|#%s)", re_regs, re_shift);
        re_label_line = String.format("^%s$", re_label);
        re_MOV = String.format("^MOV\\s+%s\\s*,\\s*%s$", re_regs, re_op2);
        re_CMP = String.format("^CMP\\s+%s\\s*,\\s*%s$", re_regs, re_op2);
        re_ARITH = String.format("^(ADD|SUB)\\s+%s\\s*,\\s*%s,\\s*%s$", re_regs, re_regs, re_op2);
        re_ASR = String.format("^ASR\\s+%s\\s*,\\s*%s,\\s*%s$", re_regs, re_regs, re_op2_shift);
        re_BXX = String.format("^(BL|BAL|BEQ|BNE|BGT|BGE|BLT|BLE)\\s+%s$", re_label);
        re_DCD = String.format("^%s\\s+DCD\\s+%s$", re_ident, re_int_list);
        re_LDR1 = String.format("^LDR\\s+%s\\s*,\\s*=%s$", re_regs, re_ident);
        re_LDR2 = String.format("^LDR\\s+%s\\s*,\\s*\\[\\s*%s\\s*,\\s*%s\\s*\\]$", re_regs, re_regs, re_op2);
        re_LDR3 = String.format("^LDR\\s+%s\\s*,\\s*\\[\\s*%s\\s*,\\s*%s\\s*,\\s*LSL\\s+#%s\\s*\\]$", re_regs, re_regs, re_regs, re_shift);
        re_STR2 = String.format("^STR\\s+%s\\s*,\\s*\\[\\s*%s\\s*,\\s*%s\\s*\\]$", re_regs, re_regs, re_op2);
        re_STR3 = String.format("^STR\\s+%s\\s*,\\s*\\[\\s*%s\\s*,\\s*%s\\s*,\\s*LSL\\s+#%s\\s*\\]$", re_regs, re_regs, re_regs, re_shift);
        re_LDM = String.format("^LDM(DB|DA|IB|IA)\\s+%s!?\\s*,\\s*%s$", re_regs, re_regs_list);
        re_STM = String.format("^STM(DB|DA|IB|IA)\\s+%s!?\\s*,\\s*%s$", re_regs, re_regs_list);
        re_END = String.format("^END$", new Object[0]);
    }

    class ChipCPU {
        static final int SP_INIT = 16380;
        HashMap<String, Register> registers = new HashMap();
        HashMap<String, StatusBit> statusBits = new HashMap();
        Box GUI = Box.createVerticalBox();
        JPanel regsGUI;
        JPanel statusGUI;

        ChipCPU() {
            this.setupGUI();
            this.reset();
        }

        void reset() {
            ArmSim.this.textArea.setCaretPosition(0);
            ArmSimException.currLine = -1;
            ArmSim.this.errorMessage.setText(" ");
            for (Register register : this.registers.values()) {
                register.setValue(0);
            }
            this.setValue("SP", 16380);
            this.clearStatusBits();
        }

        void clearStatusBits() {
            for (StatusBit statusBit : this.statusBits.values()) {
                statusBit.update(false);
            }
        }

        private void setStatusBits(int n) {
            StatusBit statusBit = this.statusBits.get("Z");
            statusBit.update(n == 0);
            StatusBit statusBit2 = this.statusBits.get("N");
            statusBit2.update(n < 0);
        }

        private int getValue(String string) {
            Register register = this.registers.get(string);
            if (register != null) {
                return register.value;
            }
            return Integer.valueOf(string);
        }

        private void setValue(String string, int n) {
            Register register = this.registers.get(string);
            register.setValue(n);
        }

        boolean getStatus(String string) {
            return this.statusBits.get((Object)string).value;
        }

        private int incPC() {
            Register register = this.registers.get("PC");
            int n = register.value;
            register.setValue(register.value + 4);
            return n;
        }

        private void setPC(int n) {
            Register register = this.registers.get("PC");
            register.setValue(n);
        }

        void setupGUI() {
            ArmSim.this.addBorder(this.GUI, "CPU", 10);
            this.setupRegsGUI();
            this.setupStatusGUI();
            this.GUI.add(this.statusGUI);
            ArmSim.addVertSpacing(this.GUI, 10);
            this.GUI.add(this.regsGUI);
        }

        void setupRegsGUI() {
            this.regsGUI = new JPanel(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 0;
            gridBagConstraints.insets = new Insets(2, 2, 2, 2);
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            for (int i = 0; i < 16; ++i) {
                Register register = new Register(ArmSim.this, i);
                this.registers.put(register.name, register);
                this.registers.put(register.numericName, register);
                gridBagConstraints.gridx = i % 2;
                gridBagConstraints.gridy = i / 2;
                this.regsGUI.add((Component)register.GUI, gridBagConstraints);
            }
        }

        void setupStatusGUI() {
            String[] stringArray = new String[]{"N", "Z", "C", "V"};
            this.statusGUI = new JPanel(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            int n = 0;
            while (n < stringArray.length) {
                String string = stringArray[n];
                StatusBit statusBit = new StatusBit(this, string);
                this.statusBits.put(string, statusBit);
                if (n != 0) {
                    gridBagConstraints.insets = new Insets(0, 20, 0, 0);
                }
                gridBagConstraints.gridx = n++;
                gridBagConstraints.gridy = 0;
                this.statusGUI.add((Component)statusBit.GUI, gridBagConstraints);
            }
        }

        class StatusBit {
            static final Color STATUS_OFF = Color.WHITE;
            static final Color STATUS_ON = Color.RED;
            static final Border border = BorderFactory.createEmptyBorder(5, 5, 5, 5);
            boolean value = false;
            JLabel GUI = new JLabel();

            StatusBit(ChipCPU chipCPU, String string) {
                this.GUI.setText(string);
                this.GUI.setFont(new Font("Monospaced", 1, 16));
                this.GUI.setOpaque(true);
                this.GUI.setBorder(border);
                this.update(false);
            }

            void update(boolean bl) {
                this.value = bl;
                if (this.value) {
                    this.GUI.setBackground(STATUS_ON);
                } else {
                    this.GUI.setBackground(STATUS_OFF);
                }
            }
        }
    }

    class ArmSimException
    extends Exception {
        static int currLine = -1;

        ArmSimException(String string) {
            this(currLine, string);
        }

        ArmSimException(int n, String string) {
            super(string);
            currLine = n;
            ArmSim.this.textArea.setEnabled(false);
            ArmSim.this.playButton.setEnabled(false);
            ArmSim.this.stepButton.setEnabled(false);
            ArmSim.this.errorMessage.setText(string.replaceAll("\\t", "    "));
            ArmSim.this.addLineHighlight(currLine, ERROR_HIGHLIGHT_COLOR);
        }
    }

    private class LineHighlighter
    extends DefaultHighlighter.DefaultHighlightPainter {
        public LineHighlighter(ArmSim armSim, Color color) {
            super(color);
        }

        @Override
        public Shape paintLayer(Graphics graphics, int n, int n2, Shape shape, JTextComponent jTextComponent, View view) {
            try {
                int n3 = Utilities.getRowStart(jTextComponent, n);
                int n4 = Utilities.getRowEnd(jTextComponent, n2);
                Rectangle rectangle = jTextComponent.modelToView(n3);
                Rectangle rectangle2 = jTextComponent.modelToView(n4);
                Rectangle rectangle3 = new Rectangle(0, rectangle.y, jTextComponent.getWidth(), rectangle2.y - rectangle.y + rectangle2.height);
                graphics.setColor(this.getColor());
                ((Graphics2D)graphics).fill(rectangle3);
                return rectangle3;
            }
            catch (BadLocationException badLocationException) {
                return null;
            }
        }
    }

    public class BlockCaret
    extends DefaultCaret {
        private Color color;

        public BlockCaret(Color color) {
            this.color = color;
        }

        @Override
        protected synchronized void damage(Rectangle rectangle) {
            if (rectangle != null) {
                JTextComponent jTextComponent = this.getComponent();
                FontMetrics fontMetrics = jTextComponent.getFontMetrics(jTextComponent.getFont());
                int n = fontMetrics.charWidth('m');
                this.x = rectangle.x;
                this.y = rectangle.y;
                this.width = n;
                this.height = rectangle.height;
                jTextComponent.repaint();
            }
        }

        @Override
        public void paint(Graphics graphics) {
            JTextComponent jTextComponent = this.getComponent();
            if (jTextComponent != null) {
                Rectangle rectangle = null;
                try {
                    rectangle = jTextComponent.modelToView(this.getDot());
                    if (rectangle != null) {
                        char c = this.getCurrentChar();
                        if (this.isVisible()) {
                            graphics.setColor(this.color);
                            graphics.fillRect(rectangle.x, rectangle.y, this.width, rectangle.height);
                            graphics.setColor(Color.BLACK);
                            graphics.drawString(String.valueOf(c), rectangle.x, rectangle.y + rectangle.height - 2);
                        }
                    }
                }
                catch (BadLocationException badLocationException) {
                    return;
                }
            }
        }

        private char getCurrentChar() {
            JTextComponent jTextComponent = this.getComponent();
            int n = this.getDot();
            Document document = jTextComponent.getDocument();
            try {
                return n < document.getLength() ? document.getText(n, 1).charAt(0) : (char)' ';
            }
            catch (BadLocationException badLocationException) {
                return ' ';
            }
        }
    }

    class ChipMemory {
        static final int MEMORY_VIEW_SIZE = 20;
        static final int MEMORY_SIZE = 16384;
        static final int DATASEG_SIZE = 50;
        TreeMap<Integer, MemoryCell> memoryCells = new TreeMap();
        Box GUI = Box.createHorizontalBox();
        MemoryCell selectedCell = null;
        JPanel datasegPanel;
        JScrollPane datasegScroll;
        JPanel stackPanel;
        JScrollPane stackScroll;
        int dataSegmentOffset = 4 * ArmSim.getRandomInt(50, 75);
        int dataItems = 0;

        public ChipMemory() {
            int n;
            int n2;
            ArmSim.this.addBorder(this.GUI, "RAM", 10);
            this.datasegPanel = new JPanel();
            this.datasegPanel.setLayout(new BoxLayout(this.datasegPanel, 1));
            for (n2 = 0; n2 < 50; ++n2) {
                n = this.dataSegmentOffset + 4 * n2;
                this.addCell(n, 0);
            }
            this.datasegScroll = new JScrollPane(this.datasegPanel);
            this.datasegScroll.setVerticalScrollBarPolicy(22);
            this.datasegScroll.setHorizontalScrollBarPolicy(31);
            ArmSim.this.addBorder(this.datasegScroll, "Data Segment", 5);
            this.stackPanel = new JPanel();
            this.stackPanel.setLayout(new BoxLayout(this.stackPanel, 1));
            n2 = 16380;
            for (n = 0; n < 20; ++n) {
                this.addCell(n2, 0);
                n2 -= 4;
            }
            this.stackScroll = new JScrollPane(this.stackPanel);
            this.stackScroll.setVerticalScrollBarPolicy(22);
            this.stackScroll.setHorizontalScrollBarPolicy(31);
            ArmSim.this.addBorder(this.stackScroll, "Stack", 5);
            this.GUI.add(this.datasegScroll);
            this.GUI.add(this.stackScroll);
            this.reset();
        }

        public void reset() {
            Object object;
            if (this.selectedCell != null) {
                this.selectedCell.addrLabel.setBackground(MemoryCell.ADDR_BG_COLOR);
                this.selectedCell = null;
            }
            int n = this.stackPanel.getComponentCount();
            int n2 = 16380 - 4 * n;
            int n3 = this.dataSegmentOffset + 200;
            Iterator<Map.Entry<Integer, MemoryCell>> iterator = this.memoryCells.entrySet().iterator();
            while (iterator.hasNext()) {
                object = iterator.next();
                int n4 = object.getKey();
                if (n4 <= n3 || n4 >= n2) continue;
                iterator.remove();
                this.stackPanel.remove(0);
            }
            for (Integer n5 : this.memoryCells.keySet()) {
                MemoryCell memoryCell = this.memoryCells.get(n5);
                memoryCell.update(n5, 0);
            }
            object = new TreeMap<Integer, MemoryCell>();
            int n6 = this.dataSegmentOffset;
            this.dataSegmentOffset = 4 * ArmSim.getRandomInt(50, 75);
            this.dataItems = 0;
            for (int i = 0; i < 50; ++i) {
                int n7 = n6 + 4 * i;
                int n8 = this.dataSegmentOffset + 4 * i;
                MemoryCell memoryCell = this.memoryCells.remove(n7);
                memoryCell.update(n8, 0);
                ((TreeMap)object).put(n8, memoryCell);
            }
            this.memoryCells.putAll((Map<Integer, MemoryCell>)object);
            ArmSim.this.selectFirst(this.datasegScroll);
        }

        public boolean isValid(int n) {
            return n >= 0 && n < 16384 && n % 4 == 0;
        }

        public void selectCellByIndex(JScrollPane jScrollPane, int n, MemoryCell memoryCell) {
            JPanel jPanel = (JPanel)jScrollPane.getViewport().getView();
            Rectangle rectangle = memoryCell.GUI.getBounds();
            JViewport jViewport = jScrollPane.getViewport();
            int n2 = rectangle.y - jViewport.getHeight() / 2 + rectangle.height / 2;
            jViewport.setViewPosition(new Point(0, Math.max(n2, 0)));
            if (this.selectedCell != null) {
                this.selectedCell.addrLabel.setBackground(MemoryCell.ADDR_BG_COLOR);
            }
            this.selectedCell = memoryCell;
            memoryCell.addrLabel.setBackground(LINE_HIGHLIGHT_COLOR);
        }

        private int getCellIndex(int n) {
            JPanel jPanel = n >= this.dataSegmentOffset && n <= this.dataSegmentOffset + 200 ? this.datasegPanel : this.stackPanel;
            int n2 = 0;
            for (Integer n3 : this.memoryCells.keySet()) {
                if (n3 == n) break;
                ++n2;
            }
            if (jPanel == this.stackPanel) {
                n2 -= 50;
            }
            return n2;
        }

        private MemoryCell addCell(int n, int n2) {
            JPanel jPanel = n >= this.dataSegmentOffset && n <= this.dataSegmentOffset + 200 ? this.datasegPanel : this.stackPanel;
            int n3 = 0;
            for (Integer n4 : this.memoryCells.keySet()) {
                if (n4 > n) break;
                ++n3;
            }
            if (jPanel == this.stackPanel) {
                n3 -= 50;
            }
            MemoryCell memoryCell = new MemoryCell(ArmSim.this, n, n2);
            this.memoryCells.put(n, memoryCell);
            jPanel.add((Component)memoryCell.GUI, n3);
            return memoryCell;
        }

        private void setCell(int n, int n2) throws ArmSimException {
            if (!this.isValid(n)) {
                throw new ArmSimException("invalid address: " + n);
            }
            MemoryCell memoryCell = this.memoryCells.get(n);
            if (memoryCell != null) {
                memoryCell.update(n, n2);
            } else {
                memoryCell = this.addCell(n, n2);
            }
            JScrollPane jScrollPane = n >= this.dataSegmentOffset && n <= this.dataSegmentOffset + 200 ? this.datasegScroll : this.stackScroll;
            int n3 = this.getCellIndex(n);
            this.selectCellByIndex(jScrollPane, n3, memoryCell);
        }

        private int getCell(int n) throws ArmSimException {
            if (!this.isValid(n)) {
                throw new ArmSimException("invalid address: " + n);
            }
            MemoryCell memoryCell = this.memoryCells.get(n);
            int n2 = 0;
            if (memoryCell == null) {
                memoryCell = this.addCell(n, 0);
            } else {
                n2 = memoryCell.value;
            }
            JScrollPane jScrollPane = n >= this.dataSegmentOffset && n <= this.dataSegmentOffset + 200 ? this.datasegScroll : this.stackScroll;
            int n3 = this.getCellIndex(n);
            this.selectCellByIndex(jScrollPane, n3, memoryCell);
            return n2;
        }
    }

    class Register {
        static final Comparator<String> compareIndices = (string, string2) -> indexFromName.get(string).compareTo(indexFromName.get(string2));
        static final Comparator<String> reverseCompareIndices = (string, string2) -> -compareIndices.compare((String)string, (String)string2);
        static final HashMap<Integer, String> nameFromIndex = new HashMap<Integer, String>(){
            {
                for (int i = 0; i < 12; ++i) {
                    this.put(i, "R" + i);
                }
                this.put(12, "FP");
                this.put(13, "SP");
                this.put(14, "LR");
                this.put(15, "PC");
            }
        };
        static final HashMap<String, Integer> indexFromName = new HashMap<String, Integer>(){
            {
                for (int i = 0; i < 16; ++i) {
                    this.put("R" + i, i);
                }
                this.put("FP", 12);
                this.put("SP", 13);
                this.put("LR", 14);
                this.put("PC", 15);
            }
        };
        int value = 0;
        int index;
        String name;
        String numericName;
        JLabel GUI;

        Register(ArmSim armSim, int n) {
            this.index = n;
            this.name = nameFromIndex.get(n);
            this.numericName = "R" + n;
            this.GUI = new JLabel(this.toString());
            this.GUI.setFont(new Font("Monospaced", 1, 16));
            this.GUI.setHorizontalAlignment(2);
            this.GUI.setOpaque(true);
            this.GUI.setForeground(Color.BLACK);
            this.GUI.setBackground(Color.LIGHT_GRAY);
            this.GUI.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        }

        void setValue(int n) {
            this.value = n;
            this.GUI.setText(this.toString());
        }

        public String toString() {
            return String.format(" %-4s %5d ", this.name, this.value);
        }
    }

    class MemoryCell {
        static final Color ADDR_BG_COLOR = new Color(220, 220, 220);
        static final Color VALUE_BG_COLOR = Color.WHITE;
        int value;
        JLabel valueLabel;
        JLabel addrLabel;
        Box GUI = Box.createHorizontalBox();

        MemoryCell(ArmSim armSim, int n, int n2) {
            this.addrLabel = new JLabel();
            this.addrLabel.setFont(new Font("Monospaced", 1, 16));
            this.addrLabel.setHorizontalAlignment(2);
            this.addrLabel.setOpaque(true);
            this.addrLabel.setBackground(ADDR_BG_COLOR);
            this.GUI.add(this.addrLabel);
            this.valueLabel = new JLabel();
            this.valueLabel.setFont(new Font("Monospaced", 1, 16));
            this.valueLabel.setHorizontalAlignment(2);
            this.valueLabel.setOpaque(true);
            this.valueLabel.setBackground(VALUE_BG_COLOR);
            this.GUI.add(this.valueLabel);
            ArmSim.addHorizSpacing(this.GUI, 5);
            this.update(n, n2);
        }

        void update(int n, int n2) {
            this.value = n2;
            this.addrLabel.setText(String.format("%5d:", n));
            this.valueLabel.setText(String.format(" %s", ArmSim.formatInPairs(n2)));
        }
    }
}

